/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.util;

import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.platform.CommonAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;

public class BiomeUtil {
    private static final Map<BiomeType, ResourceLocation> TYPE_NAMES = new EnumMap<BiomeType, ResourceLocation>(BiomeType.class);
    private static final Set<String> KNOWN_NAMESPACES = Set.of("terraforged", "terralith");

    public static ResourceLocation getRegistryName(BiomeType type) {
        return TYPE_NAMES.get((Object)type);
    }

    public static List<Biome> getOverworldBiomes(RegistryAccess access) {
        return BiomeUtil.getOverworldBiomes((Registry<Biome>)access.m_175515_(Registry.f_122885_));
    }

    public static List<Biome> getOverworldBiomes(Registry<Biome> biomes) {
        List<Biome> overworld = BiomeUtil.getVanillaOverworldBiomes(biomes);
        for (Map.Entry entry : biomes.m_6579_()) {
            Biome biome = (Biome)entry.getValue();
            ResourceLocation name = ((ResourceKey)entry.getKey()).m_135782_();
            if (CommonAPI.get().isOverworldBiome((ResourceKey<Biome>)((ResourceKey)entry.getKey()))) {
                overworld.add(biome);
                continue;
            }
            if (!KNOWN_NAMESPACES.contains(name.m_135827_())) continue;
            overworld.add(biome);
        }
        overworld.sort(BiomeUtil.getBiomeSorter(biomes));
        return overworld;
    }

    public static Comparator<Biome> getBiomeSorter(Registry<Biome> biomes) {
        return (o1, o2) -> {
            ResourceLocation k1 = biomes.m_7981_(o1);
            ResourceLocation k2 = biomes.m_7981_(o2);
            Objects.requireNonNull(k1);
            Objects.requireNonNull(k2);
            return k1.compareTo(k2);
        };
    }

    public static BiomeType getType(Biome biome) {
        return switch (biome.m_47567_()) {
            case Biome.BiomeCategory.MESA, Biome.BiomeCategory.DESERT -> BiomeType.DESERT;
            case Biome.BiomeCategory.PLAINS -> BiomeUtil.getByTemp(biome, BiomeType.COLD_STEPPE, BiomeType.GRASSLAND, BiomeType.STEPPE);
            case Biome.BiomeCategory.TAIGA -> BiomeUtil.getByTemp(biome, BiomeType.TUNDRA, BiomeType.TAIGA);
            case Biome.BiomeCategory.ICY -> BiomeType.TUNDRA;
            case Biome.BiomeCategory.SAVANNA -> BiomeType.SAVANNA;
            case Biome.BiomeCategory.JUNGLE -> BiomeType.TROPICAL_RAINFOREST;
            case Biome.BiomeCategory.FOREST -> BiomeUtil.getByRain(biome, BiomeType.TUNDRA, BiomeType.TEMPERATE_RAINFOREST, BiomeType.TEMPERATE_FOREST);
            case Biome.BiomeCategory.MOUNTAIN -> BiomeType.ALPINE;
            default -> null;
        };
    }

    public static BiomeType getByRain(Biome biome, BiomeType frozen, BiomeType wetter, BiomeType dryer) {
        if (biome.m_47530_() == Biome.Precipitation.SNOW) {
            return frozen;
        }
        return (double)biome.m_47548_() >= 0.8 ? wetter : dryer;
    }

    public static BiomeType getByTemp(Biome biome, BiomeType colder, BiomeType warmer) {
        return biome.m_47530_() == Biome.Precipitation.SNOW ? colder : warmer;
    }

    public static BiomeType getByTemp(Biome biome, BiomeType cold, BiomeType temperate, BiomeType hot) {
        if (biome.m_47530_() == Biome.Precipitation.SNOW) {
            return cold;
        }
        if (biome.m_47530_() == Biome.Precipitation.NONE || (double)biome.m_47554_() > 1.0) {
            return hot;
        }
        return temperate;
    }

    private static List<Biome> getVanillaOverworldBiomes(Registry<Biome> biomes) {
        HashSet<Biome> set = new HashSet<Biome>(MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(biomes).m_196676_());
        set.add((Biome)biomes.m_6246_(Biomes.f_186754_));
        return new ArrayList<Biome>(set);
    }

    static {
        for (BiomeType type : BiomeType.values()) {
            TYPE_NAMES.put(type, TerraForged.location(type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

