/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.cave;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.util.NoiseChunkUtil;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;

public class CarverUtil {
    public static void applyCarvers(long seed, ChunkAccess centerChunk, WorldGenRegion region, BiomeManager biomeManager, GenerationStep.Carving step, Generator generator) {
        biomeManager = biomeManager.m_186687_((BiomeManager.NoiseBiomeSource)generator);
        ChunkPos centerPos = centerChunk.m_7697_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
        NoiseChunk noiseChunk = NoiseChunkUtil.getNoiseChunk(centerChunk, generator);
        CarvingContext context = generator.getVanillaGen().createCarvingContext(region, centerChunk, noiseChunk);
        Aquifer aquifer = noiseChunk.m_188817_();
        CarvingMask mask = ((ProtoChunk)centerChunk).m_183613_(step);
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dz = -8; dz <= 8; ++dz) {
                ChunkAccess chunk = region.m_6325_(centerPos.f_45578_ + dx, centerPos.f_45579_ + dz);
                ChunkPos chunkPos = chunk.m_7697_();
                int x = chunkPos.m_45604_();
                int z = chunkPos.m_45605_();
                Biome biome = biomeManager.m_47873_(x >> 2, 0, z >> 2);
                BiomeGenerationSettings settings = biome.m_47536_();
                List carvers = settings.m_47799_(step);
                for (int i = 0; i < carvers.size(); ++i) {
                    ConfiguredWorldCarver carver = (ConfiguredWorldCarver)((Supplier)carvers.get(i)).get();
                    random.m_190068_(seed + (long)i, chunkPos.f_45578_, chunkPos.f_45579_);
                    if (!(random.nextFloat() < 0.5f) || !carver.m_159273_((Random)random)) continue;
                    carver.m_190712_(context, centerChunk, arg_0 -> ((BiomeManager)biomeManager).m_47881_(arg_0), (Random)random, aquifer, chunkPos, mask);
                }
            }
        }
    }
}

