/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.noise;

import com.terraforged.engine.Seed;
import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.GeneratorContext;
import com.terraforged.engine.world.continent.advanced.AdvancedContinentGenerator;
import com.terraforged.engine.world.heightmap.ControlPoints;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.worldgen.noise.NoiseSample;
import com.terraforged.mod.worldgen.noise.RiverCache;
import com.terraforged.noise.source.Line;
import com.terraforged.noise.util.NoiseUtil;
import com.terraforged.noise.util.Vec2f;

public class ContinentNoise
extends AdvancedContinentGenerator {
    protected final float offsetX;
    protected final float offsetZ;
    protected final GeneratorContext context;
    protected final ThreadLocal<RiverCache> localRiverCache = ThreadLocal.withInitial(RiverCache::new);

    public ContinentNoise(Seed seed, GeneratorContext context) {
        super(seed, context);
        Vec2f centre = NoiseUtil.cell(this.seed, 0, 0);
        this.context = context;
        this.offsetX = centre.x * this.jitter / this.frequency;
        this.offsetZ = centre.y * this.jitter / this.frequency;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public RiverCache getRiverCache() {
        return this.localRiverCache.get();
    }

    public ControlPoints getControlPoints() {
        return this.controlPoints;
    }

    public void sampleContinent(float x, float y, NoiseSample sample) {
        float wx = this.warp.getX(x += this.offsetX, y += this.offsetZ);
        float wy = this.warp.getY(x, y);
        x = wx * this.frequency;
        y = wy * this.frequency;
        int xi = NoiseUtil.floor(x);
        int yi = NoiseUtil.floor(y);
        int cellX = xi;
        int cellY = yi;
        float cellPointX = x;
        float cellPointY = y;
        float nearest = Float.MAX_VALUE;
        for (int cy = yi - 1; cy <= yi + 1; ++cy) {
            for (int cx = xi - 1; cx <= xi + 1; ++cx) {
                Vec2f vec = NoiseUtil.cell(this.seed, cx, cy);
                float px = (float)cx + vec.x * this.jitter;
                float py = (float)cy + vec.y * this.jitter;
                float dist2 = Line.dist2(x, y, px, py);
                if (!(dist2 < nearest)) continue;
                cellPointX = px;
                cellPointY = py;
                cellX = cx;
                cellY = cy;
                nearest = dist2;
            }
        }
        nearest = Float.MAX_VALUE;
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int cy = cellY - 1; cy <= cellY + 1; ++cy) {
            for (int cx = cellX - 1; cx <= cellX + 1; ++cx) {
                if (cx == cellX && cy == cellY) continue;
                Vec2f vec = NoiseUtil.cell(this.seed, cx, cy);
                float px = (float)cx + vec.x * this.jitter;
                float py = (float)cy + vec.y * this.jitter;
                float dist2 = ContinentNoise.getDistance(x, y, cellPointX, cellPointY, px, py);
                sumX += px;
                sumY += py;
                if (!(dist2 < nearest)) continue;
                nearest = dist2;
            }
        }
        if (this.shouldSkip(cellX, cellY)) {
            sample.continentNoise = -1.0f;
            sample.continentCentre = 0L;
            sample.terrainType = TerrainType.NONE;
            return;
        }
        int continentX = this.getCorrectedContinentCentre(cellPointX, sumX / 8.0f);
        int continentZ = this.getCorrectedContinentCentre(cellPointY, sumY / 8.0f);
        sample.continentNoise = this.getDistanceValue(x, y, cellX, cellY, nearest);
        sample.continentCentre = PosUtil.pack(continentX, continentZ);
        sample.terrainType = this.getTerrainType(sample);
    }

    public void sampleRiver(float x, float z, NoiseSample sample, RiverCache cache) {
        if (sample.continentNoise <= 0.0f) {
            return;
        }
        Cell cell = cache.cell.reset();
        cell.value = sample.heightNoise;
        cell.terrain = sample.terrainType;
        cell.continentEdge = sample.continentNoise;
        cache.get(sample.continentCentre, this).apply(cell, x += this.offsetX, z += this.offsetZ);
        sample.heightNoise = cell.value;
        sample.terrainType = cell.terrain;
        sample.riverNoise = 1.0f - cell.riverMask;
    }

    private Terrain getTerrainType(NoiseSample sample) {
        if (sample.continentNoise < this.controlPoints.shallowOcean) {
            return TerrainType.DEEP_OCEAN;
        }
        if (sample.continentNoise < this.controlPoints.beach) {
            return TerrainType.SHALLOW_OCEAN;
        }
        if (sample.continentNoise < this.controlPoints.coastMarker) {
            return TerrainType.COAST;
        }
        return TerrainType.NONE;
    }
}

