/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.noise;

import com.terraforged.engine.settings.Settings;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.GeneratorContext;
import com.terraforged.engine.world.heightmap.ControlPoints;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.util.SpiralIterator;
import com.terraforged.mod.worldgen.asset.TerrainNoise;
import com.terraforged.mod.worldgen.noise.ContinentNoise;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.noise.NoiseData;
import com.terraforged.mod.worldgen.noise.NoiseLevels;
import com.terraforged.mod.worldgen.noise.NoiseSample;
import com.terraforged.mod.worldgen.noise.RiverCache;
import com.terraforged.mod.worldgen.noise.erosion.ErodedNoiseGenerator;
import com.terraforged.mod.worldgen.noise.erosion.NoiseTileSize;
import com.terraforged.mod.worldgen.terrain.TerrainBlender;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import com.terraforged.noise.util.NoiseUtil;
import java.util.function.Consumer;

public class NoiseGenerator
implements INoiseGenerator {
    protected final float heightMultiplier = 1.2f;
    protected final long seed;
    protected final NoiseLevels levels;
    protected final Module ocean;
    protected final Module baseHeight;
    protected final TerrainBlender land;
    protected final ContinentNoise continent;
    protected final ControlPoints controlPoints;
    protected final ThreadLocal<NoiseData> localChunk = ThreadLocal.withInitial(NoiseData::new);
    protected final ThreadLocal<NoiseSample> localSample = ThreadLocal.withInitial(NoiseSample::new);

    public NoiseGenerator(long seed, TerrainLevels levels, TerrainNoise[] terrainNoises) {
        this.seed = seed;
        this.levels = levels.noiseLevels;
        this.ocean = NoiseGenerator.createOceanTerrain(seed);
        this.baseHeight = NoiseGenerator.createBaseTerrain(seed);
        this.land = NoiseGenerator.createLandTerrain(seed, terrainNoises);
        this.continent = NoiseGenerator.createContinentNoise(seed, levels);
        this.controlPoints = this.continent.getControlPoints();
    }

    public NoiseGenerator(long seed, TerrainLevels levels, NoiseGenerator other) {
        this.seed = seed;
        this.levels = levels.noiseLevels;
        this.land = other.land.withSeed(seed);
        this.ocean = NoiseGenerator.createOceanTerrain(seed);
        this.baseHeight = NoiseGenerator.createBaseTerrain(seed);
        this.continent = NoiseGenerator.createContinentNoise(seed, levels);
        this.controlPoints = this.continent.getControlPoints();
    }

    @Override
    public NoiseGenerator with(long seed, TerrainLevels levels) {
        return new NoiseGenerator(seed, levels, this);
    }

    @Override
    public NoiseLevels getLevels() {
        return this.levels;
    }

    @Override
    public ContinentNoise getContinent() {
        return this.continent;
    }

    @Override
    public float getHeightNoise(int x, int z) {
        return this.getNoiseSample((int)x, (int)z).heightNoise;
    }

    @Override
    public long find(int x, int z, int minRadius, int maxRadius, Terrain terrain) {
        if (!terrain.isOverground()) {
            return 0L;
        }
        float nx = this.getNoiseCoord(x);
        float nz = this.getNoiseCoord(z);
        SpiralIterator.PositionFinder finder = this.land.findNearest(nx, nz, minRadius, maxRadius, terrain);
        NoiseSample sample = this.localSample.get();
        RiverCache riverCache = this.continent.getRiverCache();
        while (finder.hasNext()) {
            long pos = finder.next();
            if (pos == 0L) continue;
            float px = PosUtil.unpackLeftf(pos) / this.levels.frequency;
            float pz = PosUtil.unpackRightf(pos) / this.levels.frequency;
            this.continent.sampleContinent(px, pz, sample);
            if (sample.continentNoise < this.controlPoints.inland) continue;
            this.continent.sampleRiver(px, pz, sample, riverCache);
            if (sample.riverNoise > 0.25f) continue;
            int xi = NoiseUtil.floor(px);
            int zi = NoiseUtil.floor(pz);
            return PosUtil.pack(xi, zi);
        }
        return 0L;
    }

    @Override
    public void generate(int chunkX, int chunkZ, Consumer<NoiseData> consumer) {
        NoiseData noiseData = this.localChunk.get();
        TerrainBlender.Blender blender = this.land.getBlenderResource();
        RiverCache riverCache = this.continent.getRiverCache();
        NoiseSample sample = noiseData.sample;
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        for (int dz = -1; dz < 17; ++dz) {
            for (int dx = -1; dx < 17; ++dx) {
                int x = startX + dx;
                int z = startZ + dz;
                this.sample(x, z, sample, riverCache, blender);
                noiseData.setNoise(dx, dz, sample);
            }
        }
        consumer.accept(noiseData);
    }

    public INoiseGenerator withErosion() {
        return new ErodedNoiseGenerator(this.seed, NoiseGenerator.getNoiseTileSize(), this);
    }

    public TerrainBlender.Blender getBlenderResource() {
        return this.land.getBlenderResource();
    }

    public NoiseSample getNoiseSample(int x, int z) {
        NoiseSample sample = this.localSample.get();
        TerrainBlender.Blender blender = this.land.getBlenderResource();
        RiverCache riverCache = this.continent.getRiverCache();
        return this.sample(x, z, sample, riverCache, blender);
    }

    public NoiseSample sample(int x, int z, NoiseSample sample, RiverCache riverCache, TerrainBlender.Blender blender) {
        float nx = this.getNoiseCoord(x);
        float nz = this.getNoiseCoord(z);
        this.sampleTerrain(nx, nz, sample, blender);
        this.continent.sampleRiver(nx, nz, sample, riverCache);
        return sample;
    }

    public NoiseSample sampleTerrain(float nx, float nz, NoiseSample sample, TerrainBlender.Blender blender) {
        this.continent.sampleContinent(nx, nz, sample);
        float continentNoise = sample.continentNoise;
        if (continentNoise < this.controlPoints.shallowOcean) {
            this.getOcean(nx, nz, sample, blender);
        } else if (continentNoise > this.controlPoints.inland) {
            this.getInland(nx, nz, sample, blender);
        } else {
            this.getBlend(nx, nz, sample, blender);
        }
        return sample;
    }

    public NoiseSample sampleRiver(float nx, float nz, NoiseSample sample, RiverCache riverCache) {
        this.continent.sampleRiver(nx, nz, sample, riverCache);
        return sample;
    }

    protected void getOcean(float x, float z, NoiseSample sample, TerrainBlender.Blender blender) {
        float rawNoise = this.ocean.getValue(x, z);
        sample.heightNoise = this.levels.toDepthNoise(rawNoise);
        sample.terrainType = TerrainType.DEEP_OCEAN;
    }

    protected void getInland(float x, float z, NoiseSample sample, TerrainBlender.Blender blender) {
        float baseNoise = this.baseHeight.getValue(x, z);
        float rawNoise = this.land.getValue(x, z, blender) * 1.2f;
        sample.heightNoise = this.levels.toHeightNoise(baseNoise, rawNoise);
        sample.terrainType = this.land.getTerrain(blender);
    }

    protected void getBlend(float x, float z, NoiseSample sample, TerrainBlender.Blender blender) {
        float heightNoise;
        float alpha = this.getControlAlpha(sample.continentNoise);
        float lowerRaw = this.ocean.getValue(x, z);
        float lower = this.levels.toDepthNoise(lowerRaw);
        float baseNoise = this.baseHeight.getValue(x, z);
        float upperRaw = this.land.getValue(x, z, blender) * 1.2f;
        float upper = this.levels.toHeightNoise(baseNoise, upperRaw);
        sample.heightNoise = heightNoise = NoiseUtil.lerp(lower, upper, alpha);
        sample.terrainType = this.getTerrain(heightNoise, blender);
    }

    protected float getControlAlpha(float control) {
        return (control - this.controlPoints.shallowOcean) / (this.controlPoints.inland - this.controlPoints.shallowOcean);
    }

    protected Terrain getTerrain(float value, TerrainBlender.Blender blender) {
        if (value < this.levels.heightMin) {
            return TerrainType.SHALLOW_OCEAN;
        }
        return this.land.getTerrain(blender);
    }

    protected static NoiseTileSize getNoiseTileSize() {
        return new NoiseTileSize(2);
    }

    protected static Module createOceanTerrain(long seed) {
        return Source.simplex((int)seed, 64, 3).scale(0.4);
    }

    protected static Module createBaseTerrain(long seed) {
        return Source.simplex((int)seed, 200, 2);
    }

    protected static TerrainBlender createLandTerrain(long seed, TerrainNoise[] terrainNoises) {
        return new TerrainBlender(seed, 400, 0.8f, 0.275f, terrainNoises);
    }

    protected static ContinentNoise createContinentNoise(long seed, TerrainLevels levels) {
        Settings settings = new Settings();
        settings.world.seed = seed;
        settings.world.properties.seaLevel = levels.seaLevel;
        settings.world.properties.worldHeight = levels.maxY;
        settings.rivers.riverCount = 7;
        GeneratorContext context = new GeneratorContext(settings);
        return new ContinentNoise(context.seed, context);
    }
}

