/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.noise;

import com.terraforged.mod.worldgen.terrain.TerrainLevels;

public class NoiseLevels {
    public final boolean auto;
    public final float scale;
    public final float depthMin;
    public final float depthRange;
    public final float heightMin;
    public final float baseRange;
    public final float heightRange;
    public final float frequency;

    public NoiseLevels(boolean autoScale, float scale, int seaLevel, int seaFloor, int genDepth) {
        this.auto = autoScale;
        this.scale = scale;
        this.depthMin = (float)seaFloor / (float)genDepth;
        this.heightMin = (float)seaLevel / (float)genDepth;
        this.baseRange = (float)genDepth * 0.15f / (float)genDepth;
        this.heightRange = 1.0f - (this.heightMin + this.baseRange);
        this.depthRange = this.heightMin - this.depthMin;
        this.frequency = NoiseLevels.calcFrequency(genDepth - seaLevel, this.auto, scale);
    }

    public float toDepthNoise(float noise) {
        return this.depthMin + noise * this.depthRange;
    }

    public float toHeightNoise(float baseNoise, float heightNoise) {
        return this.heightMin + this.baseRange * baseNoise + this.heightRange * heightNoise;
    }

    public static NoiseLevels getDefault() {
        return TerrainLevels.DEFAULT.noiseLevels;
    }

    public static float calcFrequency(int verticalRange, boolean auto, float scale) {
        float f = scale = scale <= 0.0f ? 1.0f : scale;
        if (!auto) {
            return scale;
        }
        float frequency = 194.0f / (float)verticalRange;
        return frequency * scale;
    }
}

