/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.noise.erosion;

import com.terraforged.engine.settings.FilterSettings;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.mod.util.ObjectPool;
import com.terraforged.mod.util.map.LossyCache;
import com.terraforged.mod.worldgen.noise.ContinentNoise;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.noise.NoiseData;
import com.terraforged.mod.worldgen.noise.NoiseGenerator;
import com.terraforged.mod.worldgen.noise.NoiseLevels;
import com.terraforged.mod.worldgen.noise.NoiseSample;
import com.terraforged.mod.worldgen.noise.erosion.ErosionFilter;
import com.terraforged.mod.worldgen.noise.erosion.NoiseResource;
import com.terraforged.mod.worldgen.noise.erosion.NoiseTileSize;
import com.terraforged.mod.worldgen.terrain.TerrainBlender;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import com.terraforged.mod.worldgen.util.ThreadPool;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public class ErodedNoiseGenerator
implements INoiseGenerator {
    private static final int CACHE_SIZE = 256;
    private static final Supplier<float[]> CHUNK_ALLOCATOR = () -> new float[256];
    private static final IntFunction<CompletableFuture<float[]>[]> CHUNK_TASK_ALLOCATOR = CompletableFuture[]::new;
    protected final NoiseTileSize tileSize;
    protected final ErosionFilter erosion;
    protected final NoiseGenerator generator;
    protected final ThreadLocal<NoiseSample> localSample;
    protected final ThreadLocal<NoiseResource> localResource;
    protected final ObjectPool<float[]> pool;
    protected final LossyCache<CompletableFuture<float[]>> cache;

    public ErodedNoiseGenerator(long seed, NoiseTileSize tileSize, NoiseGenerator generator) {
        FilterSettings.Erosion settings = new FilterSettings.Erosion();
        settings.dropletsPerChunk = 200;
        this.tileSize = tileSize;
        this.generator = generator;
        this.erosion = new ErosionFilter((int)seed, tileSize.regionLength, settings);
        this.localSample = ThreadLocal.withInitial(NoiseSample::new);
        this.localResource = ThreadLocal.withInitial(() -> new NoiseResource(tileSize));
        this.pool = new ObjectPool<float[]>(256, CHUNK_ALLOCATOR);
        this.cache = LossyCache.concurrent(256, CHUNK_TASK_ALLOCATOR, this::restore);
    }

    @Override
    public INoiseGenerator with(long seed, TerrainLevels levels) {
        return this.generator.with(seed, levels).withErosion();
    }

    @Override
    public NoiseLevels getLevels() {
        return this.generator.getLevels();
    }

    @Override
    public ContinentNoise getContinent() {
        return this.generator.getContinent();
    }

    @Override
    public float getHeightNoise(int x, int z) {
        return this.generator.getHeightNoise(x, z);
    }

    @Override
    public long find(int x, int z, int minRadius, int maxRadius, Terrain terrain) {
        return this.generator.find(x, z, minRadius, maxRadius, terrain);
    }

    @Override
    public void generate(int chunkX, int chunkZ, Consumer<NoiseData> consumer) {
        try {
            NoiseResource resource = this.localResource.get();
            this.collectNeighbours(chunkX, chunkZ, resource);
            this.generateCenterChunk(chunkX, chunkZ, resource);
            this.awaitNeighbours(resource);
            this.generateErosion(chunkX, chunkZ, resource);
            this.generateRivers(chunkX, chunkZ, resource);
            consumer.accept(resource.chunk);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void collectNeighbours(int chunkX, int chunkZ, NoiseResource resource) {
        for (int dz = this.tileSize.chunkMin; dz < this.tileSize.chunkMax; ++dz) {
            for (int dx = this.tileSize.chunkMin; dx < this.tileSize.chunkMax; ++dx) {
                if (dx == 0 && dz == 0) continue;
                int tileIndex = this.tileSize.chunkIndexOfRel(dx, dz);
                int cx = chunkX + dx;
                int cz = chunkZ + dz;
                resource.chunkCache[tileIndex] = this.getChunk(cx, cz);
            }
        }
    }

    protected void generateCenterChunk(int chunkX, int chunkZ, NoiseResource resource) {
        TerrainBlender.Blender blender = this.generator.getBlenderResource();
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int min = resource.chunk.min();
        int max = resource.chunk.max();
        for (int dz = min; dz < max; ++dz) {
            float nz = this.getNoiseCoord(startZ + dz);
            for (int dx = min; dx < max; ++dx) {
                float nx = this.getNoiseCoord(startX + dx);
                NoiseSample sample = resource.chunkSample.get(dx, dz);
                this.generator.sampleTerrain(nx, nz, sample, blender);
                int tileIndex = this.tileSize.indexOfRel(dx, dz);
                resource.heightmap[tileIndex] = sample.heightNoise;
            }
        }
    }

    protected void awaitNeighbours(NoiseResource resource) {
        for (int cz = this.tileSize.chunkMin; cz < this.tileSize.chunkMax; ++cz) {
            for (int cx = this.tileSize.chunkMin; cx < this.tileSize.chunkMax; ++cx) {
                if (cx == 0 && cz == 0) continue;
                int chunkIndex = this.tileSize.chunkIndexOfRel(cx, cz);
                float[] chunk = resource.chunkCache[chunkIndex].join();
                int relStartX = cx << 4;
                int relStartZ = cz << 4;
                for (int i = 0; i < chunk.length; ++i) {
                    int dx = i & 0xF;
                    int dz = i >> 4;
                    int index = this.tileSize.indexOfRel(relStartX + dx, relStartZ + dz);
                    resource.heightmap[index] = chunk[i];
                }
            }
        }
    }

    protected void generateErosion(int chunkX, int chunkZ, NoiseResource resource) {
        this.erosion.apply(resource.heightmap, chunkX, chunkZ, this.tileSize, resource.erosionResource, resource.random);
    }

    protected void generateRivers(int chunkX, int chunkZ, NoiseResource resource) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int min = resource.chunk.min();
        int max = resource.chunk.max();
        for (int dz = min; dz < max; ++dz) {
            float nz = this.getNoiseCoord(startZ + dz);
            for (int dx = min; dx < max; ++dx) {
                float nx = this.getNoiseCoord(startX + dx);
                int tileIndex = this.tileSize.indexOfRel(dx, dz);
                float height = resource.heightmap[tileIndex];
                int chunkIndex = resource.chunk.index().of(dx, dz);
                NoiseSample sample = resource.chunkSample.get(chunkIndex);
                sample.heightNoise = height;
                this.generator.sampleRiver(nx, nz, sample, resource.riverCache);
                resource.chunk.setNoise(chunkIndex, sample);
            }
        }
    }

    protected void restore(CompletableFuture<float[]> task) {
        task.thenAccept(this.pool::restore);
    }

    protected CompletableFuture<float[]> getChunk(int x, int z) {
        return this.cache.computeIfAbsent(PosUtil.pack(x, z), (Long2ObjectFunction<CompletableFuture<float[]>>)((Long2ObjectFunction)this::generateChunk));
    }

    protected CompletableFuture<float[]> generateChunk(long key) {
        return CompletableFuture.supplyAsync(() -> {
            int chunkX = PosUtil.unpackLeft(key);
            int chunkZ = PosUtil.unpackRight(key);
            int startX = chunkX << 4;
            int startZ = chunkZ << 4;
            float[] height = this.pool.take();
            NoiseSample sample = this.localSample.get();
            TerrainBlender.Blender blender = this.generator.getBlenderResource();
            for (int i = 0; i < height.length; ++i) {
                int dx = i & 0xF;
                int dz = i >> 4;
                float nx = this.getNoiseCoord(startX + dx);
                float nz = this.getNoiseCoord(startZ + dz);
                height[i] = this.generator.sampleTerrain((float)nx, (float)nz, (NoiseSample)sample, (TerrainBlender.Blender)blender).heightNoise;
            }
            return height;
        }, ThreadPool.EXECUTOR);
    }
}

