/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.terrain;

import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.noise.util.NoiseUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.structures.JigsawJunction;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class StructureTerrain {
    private static final int MIN_RADIUS = 4;
    private static final int MAX_RADIUS = 10;
    private static final int RADIUS = 20;
    private final ObjectList<StructurePiece> rigids = new ObjectArrayList(10);
    private final ObjectList<JigsawJunction> junctions = new ObjectArrayList(32);
    protected final ObjectListIterator<StructurePiece> pieceIterator;
    protected final ObjectListIterator<JigsawJunction> junctionIterator;
    protected final BlockState air = Blocks.f_50016_.m_49966_();
    protected final BlockState solid = Blocks.f_50069_.m_49966_();
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public StructureTerrain(ChunkAccess chunk, StructureFeatureManager manager) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_175562_((ChunkAccess)chunk);
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        for (StructureFeature feature : StructureFeature.f_67031_) {
            manager.m_186610_(sectionPos, feature).forEach(start -> {
                for (StructurePiece piece : start.m_73602_()) {
                    if (!piece.m_73411_(chunkPos, 20) || piece.m_142318_() != NoiseEffect.BEARD) continue;
                    if (piece instanceof PoolElementStructurePiece) {
                        PoolElementStructurePiece element = (PoolElementStructurePiece)piece;
                        StructureTemplatePool.Projection projection = element.m_72645_().m_69230_();
                        if (projection == StructureTemplatePool.Projection.RIGID) {
                            this.rigids.add((Object)element);
                        }
                        for (JigsawJunction junction : element.m_72648_()) {
                            int sx = junction.m_68930_();
                            int sz = junction.m_68936_();
                            if (sx <= x - 20 || sz <= z - 20 || sx >= x + 15 + 20 || sz >= z + 15 + 20) continue;
                            this.junctions.add((Object)junction);
                        }
                        continue;
                    }
                    this.rigids.add((Object)piece);
                }
            });
        }
        this.pieceIterator = this.rigids.iterator();
        this.junctionIterator = this.junctions.iterator();
    }

    public void modify(int x, int z, ChunkAccess chunk, TerrainData terrainData) {
        int y = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        float maxY = y;
        int maxPosY = y;
        StructurePiece highest = null;
        while (this.pieceIterator.hasNext()) {
            StructurePiece piece = (StructurePiece)this.pieceIterator.next();
            BoundingBox bounds = piece.m_73547_();
            int length = Math.max(bounds.m_71056_(), bounds.m_71058_());
            float radius = Math.max(4, 20 - length);
            int posY = StructureTerrain.getPieceY(piece);
            maxPosY = Math.max(maxPosY, posY);
            if (highest == null && posY > y) {
                maxY = StructureTerrain.raise(x, z, bounds, posY, maxY, radius);
            }
            if (x < bounds.m_162395_() || x > bounds.m_162399_() || z < bounds.m_162398_() || z > bounds.m_162401_() || highest != null && bounds.m_162396_() <= highest.m_73547_().m_162396_()) continue;
            highest = piece;
        }
        boolean raised = this.raiseTerrain(x, y, z, maxY, chunk, terrainData);
        boolean carved = this.carveTerrain(x, maxPosY, z, chunk, highest);
        if (raised || carved) {
            terrainData.getHeight().set(x, z, chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z));
        }
        this.reset();
    }

    protected boolean raiseTerrain(int x, int y, int z, float maxY, ChunkAccess chunk, TerrainData terrainData) {
        int max = (int)maxY;
        if (y + 1 >= max) {
            return false;
        }
        for (int py = y; py < max; ++py) {
            chunk.m_6978_((BlockPos)this.pos.m_122178_(x, py, z), this.solid, false);
        }
        return true;
    }

    protected boolean carveTerrain(int x, int y, int z, ChunkAccess chunk, StructurePiece piece) {
        if (piece == null) {
            return false;
        }
        int surface = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        int ceiling = Math.max(y, surface);
        BoundingBox bounds = piece.m_73547_();
        int minY = StructureTerrain.getPieceY(piece);
        int maxY = bounds.m_162400_();
        if (ceiling > maxY + 5) {
            float alpha = StructureTerrain.getEllipseDistAlpha(x, z, bounds);
            float depth = (float)(ceiling - maxY) * 0.5f;
            maxY += NoiseUtil.round(depth * alpha);
        }
        for (int py = minY; py <= maxY; ++py) {
            chunk.m_6978_((BlockPos)this.pos.m_122178_(x, py, z), this.air, false);
        }
        return true;
    }

    protected void reset() {
        this.pieceIterator.back(this.rigids.size());
        this.junctionIterator.back(this.rigids.size());
    }

    private static float raise(int x, int z, BoundingBox bounds, float level, float surface, float borderRadius) {
        float radius2 = Math.max(1.0f, borderRadius * borderRadius);
        float distAlpha = 1.0f - StructureTerrain.getDistAlpha(x, z, bounds, radius2);
        float alpha = NoiseUtil.pow(distAlpha, 2.0f - distAlpha);
        return NoiseUtil.lerp(surface, level, alpha);
    }

    protected static float getEllipseDistAlpha(int x, int z, BoundingBox bounds) {
        float radiusX = (float)bounds.m_71056_() * 0.5f;
        float radiusZ = (float)bounds.m_71058_() * 0.5f;
        float centerX = (float)(bounds.m_162395_() + bounds.m_162399_()) * 0.5f;
        float centerZ = (float)(bounds.m_162398_() + bounds.m_162401_()) * 0.5f;
        float dx = (float)x - centerX;
        float dz = (float)z - centerZ;
        float qx = dx * dx / (radiusX * radiusX);
        float qz = dz * dz / (radiusZ * radiusZ);
        return NoiseUtil.clamp(1.0f - qx - qz, 0.0f, 1.0f);
    }

    protected static float getDistAlpha(int x, int z, BoundingBox box, float radius2) {
        int dx = StructureTerrain.getDist(x, box.m_162395_(), box.m_162399_());
        int dz = StructureTerrain.getDist(z, box.m_162398_(), box.m_162401_());
        return StructureTerrain.getDistAlpha(dx, dz, radius2);
    }

    protected static float getDistAlpha(int dx, int dz, float radius2) {
        int d2 = dx * dx + dz * dz;
        if (d2 == 0) {
            return 0.0f;
        }
        if ((float)d2 >= radius2) {
            return 1.0f;
        }
        return NoiseUtil.sqrt((float)d2 / radius2);
    }

    protected static int getOffset(StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece element = (PoolElementStructurePiece)piece;
            return element.m_72647_();
        }
        return 0;
    }

    protected static int getPieceY(StructurePiece piece) {
        int y = piece.m_73547_().m_162396_();
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece element = (PoolElementStructurePiece)piece;
            y += element.m_72647_();
        }
        return y;
    }

    protected static int getDist(int pos, int min, int max) {
        return Math.max(0, Math.max(min - pos, pos - max));
    }

    protected static class Backup
    extends StructureTerrain {
        public Backup(ChunkAccess chunk, StructureFeatureManager manager) {
            super(chunk, manager);
        }

        public void modify(int x, int z, TerrainData terrain) {
            float contribution;
            float height;
            float raised = height = terrain.getHeight().get(x, z);
            float lowered = height;
            while (this.pieceIterator.hasNext()) {
                StructurePiece piece = (StructurePiece)this.pieceIterator.next();
                if (piece.m_142318_() != NoiseEffect.BEARD) continue;
                contribution = Backup.getPieceHeight(x, z, height, piece);
                raised = Math.max(raised, contribution);
                lowered = Math.min(lowered, contribution);
            }
            while (this.junctionIterator.hasNext()) {
                JigsawJunction junction = (JigsawJunction)this.junctionIterator.next();
                contribution = Backup.getJunctionHeight(x, z, height, junction);
                raised = Math.max(raised, contribution);
            }
            if (lowered < height) {
                terrain.getHeight().set(x, z, lowered);
            } else if (raised > height) {
                terrain.getHeight().set(x, z, raised);
            }
            this.reset();
        }

        protected static float getPieceHeight(int x, int z, float height, StructurePiece piece) {
            BoundingBox bounds = piece.m_73547_();
            int pieceY = Backup.getPieceY(piece);
            int length = Math.max(bounds.m_71056_(), bounds.m_71058_());
            float radius = Math.max(4, 24 - length);
            float alpha = Backup.getDistAlpha(x, z, bounds, radius * radius);
            if ((float)pieceY > height) {
                return NoiseUtil.lerp(pieceY, height, alpha);
            }
            if ((float)pieceY < height && alpha == 0.0f) {
                return pieceY;
            }
            return height;
        }

        protected static float getJunctionHeight(int x, int z, float height, JigsawJunction junction) {
            int pieceY = junction.m_68935_() - 1;
            float alpha = Backup.getDistAlpha(x, z, junction.m_68930_(), junction.m_68936_(), 4.0f);
            if ((float)pieceY > height) {
                float fade = 1.0f - alpha;
                fade *= fade;
                fade = 1.0f - fade;
                return NoiseUtil.lerp(pieceY, height, fade);
            }
            return height;
        }

        protected static float getDistAlpha(int x, int z, int px, int pz, float radius2) {
            int dx = x - px;
            int dz = z - pz;
            return Backup.getDistAlpha(dx, dz, radius2);
        }
    }
}

