/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.terrain;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terraforged.mod.codec.Codecs;
import com.terraforged.mod.codec.LazyCodec;
import com.terraforged.mod.util.MathUtil;
import com.terraforged.mod.worldgen.noise.NoiseLevels;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.world.level.dimension.DimensionType;

public class TerrainLevels {
    public static final Codec<TerrainLevels> CODEC = LazyCodec.record(instance -> instance.group((App)Codecs.opt("auto_scale", true, Codec.BOOL).forGetter(l -> l.noiseLevels.auto), (App)Codecs.opt("horizontal_scale", Float.valueOf(1.0f), Codec.floatRange((float)0.0f, (float)10.0f)).forGetter(l -> Float.valueOf(l.noiseLevels.scale)), (App)Codec.intRange((int)Limits.MIN_MIN_Y, (int)0).fieldOf("min_y").forGetter(l -> l.minY), (App)Codec.intRange((int)128, (int)Limits.MAX_MAX_Y).fieldOf("max_y").forGetter(l -> l.maxY), (App)Codec.intRange((int)32, (int)Limits.MAX_SEA_LEVEL).fieldOf("sea_level").forGetter(l -> l.seaLevel), (App)Codec.intRange((int)0, (int)Limits.MAX_SEA_FLOOR).fieldOf("sea_floor").forGetter(l -> l.seaFloor)).apply((Applicative)instance, TerrainLevels::new));
    public static final TerrainLevels DEFAULT = new TerrainLevels(true, 1.0f, -64, 384, 62, 22);
    public final int minY;
    public final int maxY;
    public final int seaFloor;
    public final int seaLevel;
    public final NoiseLevels noiseLevels;

    public TerrainLevels(boolean autoScale, float scale, int minY, int maxY, int seaLevel, int seaFloor) {
        this.minY = MathUtil.clamp(minY, Limits.MIN_MIN_Y, 0);
        this.maxY = MathUtil.clamp(maxY, 128, Limits.MAX_MAX_Y);
        this.seaLevel = MathUtil.clamp(seaLevel, 32, maxY >> 1);
        this.seaFloor = MathUtil.clamp(seaFloor, this.minY, this.seaLevel - 1);
        this.noiseLevels = new NoiseLevels(autoScale, scale, this.seaLevel, this.seaFloor, this.maxY);
    }

    public TerrainLevels copy() {
        return new TerrainLevels(this.noiseLevels.auto, this.noiseLevels.scale, this.minY, this.maxY, this.seaLevel, this.seaFloor);
    }

    public float getScaledHeight(float heightNoise) {
        return heightNoise * (float)this.maxY;
    }

    public int getHeight(float scaledHeight) {
        return NoiseUtil.floor(scaledHeight);
    }

    public String toString() {
        return "TerrainLevels{minY=" + this.minY + ", maxY=" + this.maxY + ", seaFloor=" + this.seaFloor + ", seaLevel=" + this.seaLevel + ", noiseLevels=" + this.noiseLevels + "}";
    }

    public static class Limits {
        public static final int MIN_MIN_Y = DimensionType.f_156653_;
        public static final int MAX_MIN_Y = 0;
        public static final int MIN_SEA_LEVEL = 32;
        public static final int MAX_SEA_LEVEL;
        public static final int MIN_SEA_FLOOR = 0;
        public static final int MAX_SEA_FLOOR;
        public static final int MIN_MAX_Y = 128;
        public static final int MAX_MAX_Y;

        static {
            MAX_SEA_FLOOR = MAX_SEA_LEVEL = DimensionType.f_156651_;
            MAX_MAX_Y = DimensionType.f_156651_;
        }
    }

    public static class Defaults {
        public static final float SCALE = 1.0f;
        public static final int MIN_Y = -64;
        public static final int SEA_LEVEL = 62;
        public static final int SEA_FLOOR = 22;
        public static final int MAXY = 384;
        public static final int LEGACY_GEN_DEPTH = 256;
    }
}

