/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.util;

import com.google.common.base.Suppliers;
import com.terraforged.mod.worldgen.GeneratorResource;
import com.terraforged.mod.worldgen.terrain.StructureTerrain;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.IdMapper;
import net.minecraft.core.QuartPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkUtil {
    public static final FillerBlock FILLER = ChunkUtil::getFiller;
    public static final Supplier<ByteBuf> FULL_SECTION = Suppliers.memoize(ChunkUtil::createFullPalette);

    public static void fillNoiseBiomes(ChunkAccess chunk, BiomeSource source, Climate.Sampler sampler, GeneratorResource resource) {
        ChunkPos pos = chunk.m_7697_();
        int biomeX = QuartPos.m_175400_((int)pos.m_45604_());
        int biomeZ = QuartPos.m_175400_((int)pos.m_45605_());
        LevelHeightAccessor heightAccessor = chunk.m_183618_();
        Biome[] biomeBuffer = resource.biomeBuffer2D;
        for (int dz = 0; dz < 4; ++dz) {
            for (int dx = 0; dx < 4; ++dx) {
                Biome biome;
                biomeBuffer[dz << 2 | dx] = biome = source.m_183546_(biomeX + dx, -1, biomeZ + dz, sampler);
            }
        }
        for (int i = heightAccessor.m_151560_(); i < heightAccessor.m_151561_(); ++i) {
            LevelChunkSection chunkSection = chunk.m_183278_(chunk.m_151566_(i));
            ChunkUtil.fillNoiseBiomes(chunkSection, biomeBuffer);
        }
    }

    private static void fillNoiseBiomes(LevelChunkSection section, Biome[] biomeBuffer) {
        PalettedContainer biomes = section.m_188013_();
        biomes.m_63084_();
        for (int dz = 0; dz < 4; ++dz) {
            for (int dx = 0; dx < 4; ++dx) {
                Biome biome = biomeBuffer[dz << 2 | dx];
                for (int dy = 0; dy < 4; ++dy) {
                    biomes.m_63127_(dx, dy, dz, (Object)biome);
                }
            }
        }
        biomes.m_63120_();
    }

    public static void fillChunk(int seaLevel, ChunkAccess chunk, TerrainData terrainData, FillerBlock filler, GeneratorResource resource) {
        LevelChunkSection section;
        int index;
        int sy;
        int min = ChunkUtil.getLowestSection(terrainData);
        int max = ChunkUtil.getHighestColumn(seaLevel, terrainData);
        FriendlyByteBuf sectionData = resource.fullSection;
        for (sy = chunk.m_141937_(); sy < min; sy += 16) {
            index = chunk.m_151564_(sy);
            section = chunk.m_183278_(index);
            sectionData.resetReaderIndex();
            section.m_63019_().m_63118_(sectionData);
            section.m_63018_();
        }
        for (sy = min; sy < max; sy += 16) {
            index = chunk.m_151564_(sy);
            section = chunk.m_183278_(index);
            ChunkUtil.fillSection(sy, seaLevel, terrainData, chunk, section, filler);
        }
    }

    public static void primeHeightmaps(int seaLevel, ChunkAccess chunk, TerrainData terrainData, FillerBlock filler) {
        BlockState solid = Blocks.f_50069_.m_49966_();
        Heightmap oceanFloor = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurface = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        int i = 0;
        for (int z = 0; z < 16; ++z) {
            int x = 0;
            while (x < 16) {
                int floor = terrainData.getHeight(x, z);
                int surface = Math.max(seaLevel, floor);
                BlockState surfaceBlock = filler.getState(surface, floor);
                oceanFloor.m_64249_(x, floor, z, solid);
                worldSurface.m_64249_(x, surface, z, surfaceBlock);
                ++x;
                ++i;
            }
        }
    }

    public static void buildStructureTerrain(ChunkAccess chunk, TerrainData terrainData, StructureFeatureManager structureFeatures) {
        int x = chunk.m_7697_().m_45604_();
        int z = chunk.m_7697_().m_45605_();
        StructureTerrain operation = new StructureTerrain(chunk, structureFeatures);
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                operation.modify(x + dx, z + dz, chunk, terrainData);
            }
        }
    }

    private static void fillSection(int startY, int waterY, TerrainData terrainData, ChunkAccess chunk, LevelChunkSection section, FillerBlock filler) {
        section.m_62981_();
        int sectionMaxY = startY + 16;
        int i = 0;
        for (int z = 0; z < 16; ++z) {
            int x = 0;
            while (x < 16) {
                int solidY = terrainData.getHeight(x, z);
                int firstAirY = Math.max(solidY, waterY) + 1;
                int exclusiveMaxY = Math.min(sectionMaxY, firstAirY);
                for (int y = startY; y < exclusiveMaxY; ++y) {
                    BlockState state = filler.getState(y, solidY);
                    section.m_62991_(x, y & 0xF, z, state, false);
                    if (state.m_60791_() == 0 || !(chunk instanceof ProtoChunk)) continue;
                    ProtoChunk proto = (ProtoChunk)chunk;
                    proto.m_63277_(new BlockPos(x, y, z));
                }
                ++x;
                ++i;
            }
        }
        section.m_63006_();
    }

    protected static BlockState getFiller(int y, int surfaceSolid) {
        return y <= surfaceSolid ? Blocks.f_50069_.m_49966_() : Blocks.f_49990_.m_49966_();
    }

    protected static int getHighestColumn(int waterMaxY, TerrainData terrainData) {
        return Math.max(waterMaxY, terrainData.getMax() + 1);
    }

    protected static int getLowestSection(TerrainData terrainData) {
        int y = terrainData.getMin();
        return y >> 4 << 4;
    }

    protected static ByteBuf createFullPalette() {
        IdMapper stateRegistry = Block.f_49791_;
        PalettedContainer container = new PalettedContainer((IdMap)stateRegistry, (Object)Blocks.f_50069_.m_49966_(), PalettedContainer.Strategy.f_188137_);
        container.m_63084_();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    container.m_63127_(x, y, z, (Object)Blocks.f_50069_.m_49966_());
                }
            }
        }
        container.m_63120_();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        container.m_63135_(buffer);
        return buffer;
    }

    public static FriendlyByteBuf getFullSection() {
        return new FriendlyByteBuf(FULL_SECTION.get().copy());
    }

    public static interface FillerBlock {
        public BlockState getState(int var1, int var2);
    }
}

