/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.util;

import com.terraforged.mod.util.ReflectionUtil;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.VanillaGen;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.Blender;

public class NoiseChunkUtil {
    private static final MethodHandle SURFACE_CACHE = ReflectionUtil.field(NoiseChunk.class, Long2IntMap.class, new String[0]);
    private static final Supplier<NoiseChunk.NoiseFiller> FILLER = () -> (x, y, z) -> 0.0;

    public static void initChunk(ChunkAccess chunk, Generator generator) {
        NoiseChunkUtil.getNoiseChunk(chunk, generator);
    }

    public static NoiseChunk getNoiseChunk(ChunkAccess chunk, Generator generator) {
        VanillaGen vanilla = generator.getVanillaGen();
        Aquifer.FluidPicker fluidPicker = vanilla.getGlobalFluidPicker();
        NoiseChunk noiseChunk = chunk.m_187640_(vanilla.getNoiseSampler(), FILLER, vanilla.getSettings().get(), fluidPicker, Blender.m_190153_());
        NoiseChunkUtil.initChunk(chunk, noiseChunk, generator);
        return noiseChunk;
    }

    private static void initChunk(ChunkAccess chunk, NoiseChunk noiseChunk, Generator generator) {
        Long2IntMap cache = NoiseChunkUtil.getCache(noiseChunk);
        if (!cache.isEmpty()) {
            return;
        }
        CompletableFuture<TerrainData> terrainData = generator.getChunkDataAsync(chunk.m_7697_());
        NoiseChunkUtil.initSurfaceCache(chunk, cache, terrainData);
    }

    private static void initSurfaceCache(ChunkAccess chunk, Long2IntMap cache, CompletableFuture<TerrainData> terrainData) {
        int dx;
        int dz;
        ChunkPos chunkPos = chunk.m_7697_();
        TerrainData data = terrainData.join();
        int startX = chunkPos.m_45604_();
        int startZ = chunkPos.m_45605_();
        int lowest = Integer.MAX_VALUE;
        for (dz = 0; dz < 16; ++dz) {
            for (dx = 0; dx < 16; ++dx) {
                int qz;
                int qx;
                long index;
                int current;
                int height = data.getHeight(dx, dz);
                if (height >= (current = cache.getOrDefault(index = ChunkPos.m_45589_((int)(qx = QuartPos.m_175400_((int)(startX + dx))), (int)(qz = QuartPos.m_175400_((int)(startZ + dz)))), Integer.MAX_VALUE))) continue;
                cache.put(index, height);
                lowest = Math.min(lowest, height);
            }
        }
        for (dz = -16; dz < 32; ++dz) {
            for (dx = -16; dx < 32; ++dx) {
                if ((dx & 0xF) == dx && (dz & 0xF) == dz) continue;
                int qx = QuartPos.m_175400_((int)(startX + dx));
                int qz = QuartPos.m_175400_((int)(startZ + dz));
                long index = ChunkPos.m_45589_((int)qx, (int)qz);
                cache.put(index, lowest);
            }
        }
    }

    private static Long2IntMap getCache(NoiseChunk noiseChunk) {
        try {
            return SURFACE_CACHE.invokeExact(noiseChunk);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

