/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.mod.codec.LazyCodec;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class WorldgenTag<T> {
    private final ObjectSet<T> items;

    public WorldgenTag(ObjectSet<T> items) {
        this.items = ObjectSets.unmodifiable(items);
    }

    public final ObjectSet<T> items() {
        return this.items;
    }

    public final boolean contains(T item) {
        return this.items.contains(item);
    }

    public String toString() {
        return "WorldgenTag{items=" + this.items + "}";
    }

    private static <T> ObjectSet<T> unwrap(List<Supplier<T>> list) {
        ObjectOpenHashSet set = new ObjectOpenHashSet(list.size());
        for (Supplier<T> item : list) {
            set.add(item.get());
        }
        return set;
    }

    private static <T> List<Supplier<T>> wrap(Set<T> set) {
        ArrayList<Supplier<T>> list = new ArrayList<Supplier<T>>(set.size());
        for (Object item : set) {
            list.add(() -> item);
        }
        return list;
    }

    public static <V, T extends WorldgenTag<V>> Codec<T> codec(Codec<List<Supplier<V>>> listCodec, Function<ObjectSet<V>, T> constructor) {
        return WorldgenTag.codec("items", () -> listCodec, constructor);
    }

    public static <V, T extends WorldgenTag<V>> Codec<T> codec(String key, Supplier<Codec<List<Supplier<V>>>> listCodec, Function<ObjectSet<V>, T> constructor) {
        return LazyCodec.of(() -> RecordCodecBuilder.create(arg_0 -> WorldgenTag.lambda$codec$2((Supplier)listCodec, key, constructor, arg_0)));
    }

    private static /* synthetic */ App lambda$codec$2(Supplier listCodec, String key, Function constructor, RecordCodecBuilder.Instance instance) {
        return instance.group((App)((Codec)listCodec.get()).fieldOf(key).xmap(WorldgenTag::unwrap, WorldgenTag::wrap).forGetter(WorldgenTag::items)).apply((Applicative)instance, constructor);
    }
}

