/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.registry.ModRegistries;
import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.worldgen.asset.ClimateType;
import com.terraforged.mod.worldgen.biome.util.BiomeUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public interface ModClimates
extends ModRegistry {
    public static final float RARE = 1.0f;
    public static final float NORMAL = 5.0f;

    public static void register() {
        Registry registry = BuiltinRegistries.f_123865_;
        List<Holder<Biome>> biomes = BiomeUtil.getOverworldBiomes((Registry<Biome>)registry);
        for (BiomeType type : BiomeType.values()) {
            ModRegistries.register(CLIMATE, type.name().toLowerCase(Locale.ROOT), Factory.create(type, biomes, (Registry<Biome>)registry));
        }
    }

    public static class Factory {
        static ClimateType create(BiomeType type, List<Holder<Biome>> biomes, Registry<Biome> registry) {
            Object2FloatOpenHashMap weights = new Object2FloatOpenHashMap();
            for (Holder<Biome> biome : biomes) {
                BiomeType biomeType = BiomeUtil.getType(biome);
                if (biomeType == null || biomeType != type) continue;
                ResourceKey key = (ResourceKey)biome.m_203543_().orElseThrow();
                weights.put((Object)key.m_135782_(), Factory.getWeight((ResourceKey<Biome>)key, biome));
            }
            return new ClimateType((Object2FloatMap<ResourceLocation>)weights);
        }

        static float getWeight(ResourceKey<Biome> key, Holder<Biome> biome) {
            if (Biome.m_204183_(biome) == Biome.BiomeCategory.MUSHROOM) {
                return 1.0f;
            }
            if (key == Biomes.f_48182_) {
                return 1.0f;
            }
            return 5.0f;
        }
    }
}

