/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.hooks;

import com.mojang.serialization.Lifecycle;
import com.terraforged.mod.Environment;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.worldgen.IGenerator;
import com.terraforged.mod.worldgen.profiler.GeneratorProfiler;
import java.util.OptionalInt;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;

public class GeneratorSeedHook {
    public static Registry<LevelStem> reseed(long seed, Registry<LevelStem> registry) {
        LevelStem overworld = (LevelStem)registry.m_123013_(LevelStem.f_63971_);
        ChunkGenerator generator = overworld.m_63990_();
        if (generator instanceof IGenerator) {
            generator = generator.m_6819_(seed);
        }
        if (Environment.PROFILING && !(generator instanceof GeneratorProfiler)) {
            generator = GeneratorSeedHook.withProfiler(generator);
        }
        if (generator == overworld.m_63990_()) {
            return registry;
        }
        Lifecycle lifecycle = registry.m_6228_((Object)overworld);
        LevelStem levelStem = new LevelStem(overworld.m_204521_(), generator);
        ((MappedRegistry)registry).m_203384_(OptionalInt.empty(), LevelStem.f_63971_, (Object)levelStem, lifecycle);
        TerraForged.LOG.info("Re-seeded TerraForged generator: {}", (Object)seed);
        if (GeneratorProfiler.PROFILING.get()) {
            TerraForged.LOG.info("Attached TerraForged generator profiler");
        }
        return registry;
    }

    public static ChunkGenerator withProfiler(ChunkGenerator generator) {
        if (GeneratorProfiler.PROFILING.get()) {
            return GeneratorProfiler.wrap(generator);
        }
        return generator;
    }
}

