/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.hooks;

import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.Environment;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class RegistryAccessUtil {
    private static final MethodHandle REGISTRY_ACCESS_GETTER = ReflectionUtil.field(RegistryOps.class, RegistryAccess.class, new String[0]);

    public static Optional<RegistryAccess> getRegistryAccess(DynamicOps<?> ops) {
        if (!(ops instanceof RegistryOps)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(RegistryAccessUtil.getRegistryAccess((RegistryOps)ops));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Optional.empty();
        }
    }

    public static RegistryAccess getRegistryAccess(RegistryOps<?> ops) {
        try {
            return REGISTRY_ACCESS_GETTER.invokeExact(ops);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> MappedRegistry<T> copy(Registry<T> input) {
        MappedRegistry copy = new MappedRegistry(input.m_123023_(), input.m_194602_(), null);
        for (Map.Entry e : input.m_6579_()) {
            copy.m_203505_((ResourceKey)e.getKey(), e.getValue(), input.m_6228_(e.getValue()));
        }
        return copy;
    }

    public static <T> void copy(Registry<T> registry, RegistryAccess.Writable holder) {
        WritableRegistry dest = (WritableRegistry)holder.m_206191_(registry.m_123023_());
        for (Map.Entry entry : registry.m_6579_()) {
            dest.m_203505_((ResourceKey)entry.getKey(), entry.getValue(), registry.m_6228_(entry.getValue()));
        }
    }

    public static void printRegistryContents(Registry<?> registry) {
        if (!Environment.DEBUGGING) {
            return;
        }
        TerraForged.LOG.info(" - Registry: {}, Size: {}", (Object)registry.m_123023_().m_135782_(), (Object)registry.m_183450_());
        for (Map.Entry entry : registry.m_6579_()) {
            TerraForged.LOG.info("  - {}", (Object)((ResourceKey)entry.getKey()).m_135782_());
        }
    }
}

