/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.platform.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.terraforged.mod.Common;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.command.TFCommands;
import com.terraforged.mod.data.ModBiomes;
import com.terraforged.mod.data.ModTags;
import com.terraforged.mod.data.gen.DataGen;
import com.terraforged.mod.platform.CommonAPI;
import com.terraforged.mod.platform.forge.client.TFClient;
import com.terraforged.mod.platform.forge.client.TFPreset;
import com.terraforged.mod.platform.forge.util.ForgeRegistrar;
import com.terraforged.mod.registry.lazy.LazyTag;
import com.terraforged.mod.registry.registrar.NoopRegistrar;
import com.terraforged.mod.worldgen.biome.util.matcher.BiomeMatcher;
import com.terraforged.mod.worldgen.biome.util.matcher.BiomeTagMatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="terraforged")
public class TFMain
extends TerraForged {
    public TFMain() {
        super(TFMain::getRootPath);
        CommonAPI.HOLDER.set(new ForgeCommonAPI());
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onGenerateData);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Biome.class, this::onBiomes);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ForgeWorldPreset.class, this::onPresets);
        this.setRegistrar(Registry.f_122885_, NoopRegistrar.none());
        if (FMLLoader.getDist().isClient()) {
            new TFClient();
        }
    }

    void onInit(FMLCommonSetupEvent event) {
        event.enqueueWork(Common.INSTANCE::init);
    }

    void onRegisterCommands(RegisterCommandsEvent event) {
        TFCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    void onBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.register(new ForgeRegistrar<Biome>(event.getRegistry()));
    }

    void onPresets(RegistryEvent.Register<ForgeWorldPreset> event) {
        TerraForged.LOG.debug("Registering world-preset");
        event.getRegistry().register((IForgeRegistryEntry)TFPreset.create());
    }

    void onGenerateData(GatherDataEvent event) {
        Common.INSTANCE.init();
        final Path path = event.getGenerator().m_123916_().resolve("resources/default");
        event.getGenerator().m_123914_(new DataProvider(){

            public String m_6055_() {
                return "TerraForged";
            }

            public void m_6865_(HashCache cache) throws IOException {
                try {
                    DataGen.export(path);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        TerraForged.LOG.warn("Forcibly shutting down datagen process");
                        System.exit(0);
                    }
                }, 1000L);
            }
        });
    }

    private static Path getRootPath() {
        return ((ModContainer)ModList.get().getModContainerById("terraforged").orElseThrow()).getModInfo().getOwningFile().getFile().getFilePath();
    }

    private static class ForgeCommonAPI
    implements CommonAPI {
        public static final LazyTag<Biome> FORGE_OVERWORLD = LazyTag.biome("forge:overworld");

        private ForgeCommonAPI() {
        }

        @Override
        public BiomeMatcher getOverworldMatcher() {
            return new BiomeTagMatcher.Overworld(new TagKey[]{(TagKey)FORGE_OVERWORLD.get(), (TagKey)ModTags.OVERWORLD.get()}){

                @Override
                public boolean test(Holder<Biome> biome) {
                    return super.test(biome) || this.testDictionary(biome);
                }

                @Deprecated
                private boolean testDictionary(Holder<Biome> biome) {
                    return BiomeDictionary.hasType((ResourceKey)((ResourceKey)biome.m_203543_().orElseThrow()), (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD);
                }
            };
        }
    }
}

