/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.platform.forge.client;

import com.terraforged.mod.platform.forge.util.ForgeUtil;
import com.terraforged.mod.worldgen.GeneratorPreset;
import com.terraforged.mod.worldgen.datapack.DataPackExporter;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.ForgeWorldPreset;

public class TFPreset
implements ForgeWorldPreset.IBasicChunkGeneratorFactory {
    public ChunkGenerator createChunkGenerator(RegistryAccess registryAccess, long seed) {
        return GeneratorPreset.build(seed, TerrainLevels.DEFAULT.get(), registryAccess);
    }

    public static ForgeWorldPreset create() {
        return ForgeUtil.withName(new ForgeWorldPreset(new TFPreset()){

            public String getTranslationKey() {
                return GeneratorPreset.TRANSLATION_KEY;
            }

            public Component getDisplayName() {
                return new TranslatableComponent(this.getTranslationKey()).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN));
            }
        }, "terraforged");
    }

    public static void makeDefault() {
        if (Files.exists(DataPackExporter.CONFIG_DIR, new LinkOption[0])) {
            return;
        }
        String current = (String)ForgeConfig.COMMON.defaultWorldType.get();
        if (current.isEmpty() || current.equals("default")) {
            ForgeConfigSpec.ConfigValue configValue = ForgeConfig.COMMON.defaultWorldType;
            configValue.set((Object)"terraforged");
        }
    }
}

