/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class VanillaGen {
    protected final Registry<StructureSet> structureSets;
    protected final NoiseBasedChunkGenerator vanillaGenerator;
    protected final Holder<NoiseGeneratorSettings> settings;
    protected final Registry<NormalNoise.NoiseParameters> parameters;
    protected final int lavaLevel;
    protected final Aquifer.FluidStatus fluidStatus1;
    protected final Aquifer.FluidStatus fluidStatus2;
    protected final Aquifer.FluidPicker globalFluidPicker;
    protected final SurfaceSystem surfaceSystem;

    public VanillaGen(long seed, BiomeSource biomeSource, VanillaGen other) {
        this(seed, biomeSource, other.settings, other.parameters, other.structureSets);
    }

    public VanillaGen(long seed, BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, Registry<NormalNoise.NoiseParameters> parameters, Registry<StructureSet> structures) {
        this.settings = settings;
        this.parameters = parameters;
        this.structureSets = structures;
        this.lavaLevel = Math.min(-54, ((NoiseGeneratorSettings)settings.m_203334_()).f_64444_());
        this.fluidStatus1 = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        this.fluidStatus2 = new Aquifer.FluidStatus(((NoiseGeneratorSettings)settings.m_203334_()).f_64444_(), ((NoiseGeneratorSettings)settings.m_203334_()).f_64441_());
        this.globalFluidPicker = (x, y, z) -> y < this.lavaLevel ? this.fluidStatus1 : this.fluidStatus2;
        int seaLevel = ((NoiseGeneratorSettings)settings.m_203334_()).f_64444_();
        BlockState defaultBlock = ((NoiseGeneratorSettings)settings.m_203334_()).f_64440_();
        WorldgenRandom.Algorithm randomSource = ((NoiseGeneratorSettings)settings.m_203334_()).m_188893_();
        this.surfaceSystem = new SurfaceSystem(parameters, defaultBlock, seaLevel, seed, randomSource);
        this.vanillaGenerator = new NoiseBasedChunkGenerator(structures, parameters, biomeSource, seed, settings);
    }

    public Holder<NoiseGeneratorSettings> getSettings() {
        return this.settings;
    }

    public Registry<StructureSet> getStructureSets() {
        return this.structureSets;
    }

    public Aquifer.FluidPicker getGlobalFluidPicker() {
        return this.globalFluidPicker;
    }

    public SurfaceSystem getSurfaceSystem() {
        return this.surfaceSystem;
    }

    public CarvingContext createCarvingContext(WorldGenRegion region, ChunkAccess chunk, NoiseChunk noiseChunk) {
        return new CarvingContext(this.vanillaGenerator, region.m_5962_(), chunk.m_183618_(), noiseChunk);
    }
}

