/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.asset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terraforged.mod.codec.LazyCodec;
import com.terraforged.mod.util.seed.ContextSeedable;
import com.terraforged.mod.worldgen.cave.CaveType;
import com.terraforged.mod.worldgen.noise.NoiseCodec;
import com.terraforged.noise.Module;
import com.terraforged.noise.util.NoiseUtil;

public class NoiseCave
implements ContextSeedable<NoiseCave> {
    public static final Codec<NoiseCave> CODEC = LazyCodec.record(instance -> instance.group((App)Codec.INT.optionalFieldOf("seed", (Object)0).forGetter(c -> c.seed), (App)CaveType.CODEC.fieldOf("type").forGetter(c -> c.type), (App)NoiseCodec.CODEC.fieldOf("elevation").forGetter(c -> c.elevation), (App)NoiseCodec.CODEC.fieldOf("shape").forGetter(c -> c.shape), (App)NoiseCodec.CODEC.fieldOf("floor").forGetter(c -> c.floor), (App)Codec.INT.fieldOf("size").forGetter(c -> c.size), (App)Codec.INT.optionalFieldOf("min_y", (Object)-32).forGetter(c -> c.minY), (App)Codec.INT.fieldOf("max_y").forGetter(c -> c.maxY)).apply((Applicative)instance, NoiseCave::new));
    private final int seed;
    private final CaveType type;
    private final Module elevation;
    private final Module shape;
    private final Module floor;
    private final int size;
    private final int minY;
    private final int maxY;
    private final int rangeY;

    public NoiseCave(int seed, CaveType type, Module elevation, Module shape, Module floor, int size, int minY, int maxY) {
        this.seed = seed;
        this.type = type;
        this.elevation = elevation;
        this.shape = shape;
        this.floor = floor;
        this.size = size;
        this.minY = minY;
        this.maxY = maxY;
        this.rangeY = maxY - minY;
    }

    @Override
    public NoiseCave withSeed(long seed) {
        Module elevation = this.withSeed(seed, this.elevation, Module.class);
        Module shape = this.withSeed(seed, this.shape, Module.class);
        Module floor = this.withSeed(seed, this.floor, Module.class);
        return new NoiseCave(this.seed, this.type, elevation, shape, floor, this.size, this.minY, this.maxY);
    }

    public int getSeed() {
        return this.seed;
    }

    public CaveType getType() {
        return this.type;
    }

    public int getHeight(int x, int z) {
        return NoiseCave.getScaleValue(x, z, 1.0f, this.minY, this.rangeY, this.elevation);
    }

    public int getCavernSize(int x, int z, float modifier) {
        return NoiseCave.getScaleValue(x, z, modifier, 0, this.size, this.shape);
    }

    public int getFloorDepth(int x, int z, int size) {
        return NoiseCave.getScaleValue(x, z, 1.0f, 0, size, this.floor);
    }

    public String toString() {
        return "NoiseCave{type=" + this.type + ", elevation=" + this.elevation + ", shape=" + this.shape + ", floor=" + this.floor + ", size=" + this.size + ", minY=" + this.minY + ", maxY=" + this.maxY + ", rangeY=" + this.rangeY + "}";
    }

    private static int getScaleValue(int x, int z, float modifier, int min, int range, Module noise) {
        if (range <= 0) {
            return 0;
        }
        return min + NoiseUtil.floor(noise.getValue(x, z) * (float)range * modifier);
    }
}

