/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.biome.decorator.FeatureDecorator;
import com.terraforged.mod.worldgen.biome.decorator.SurfaceDecorator;
import com.terraforged.mod.worldgen.biome.surface.Surface;
import com.terraforged.mod.worldgen.cave.NoiseCaveGenerator;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.mod.worldgen.util.NoiseChunkUtil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;

public class BiomeGenerator {
    private final SurfaceDecorator surfaceDecorator;
    private final FeatureDecorator featureDecorator;
    private final NoiseCaveGenerator noiseCaveGenerator;

    public BiomeGenerator(long seed, RegistryAccess access) {
        this.surfaceDecorator = new SurfaceDecorator();
        this.featureDecorator = new FeatureDecorator(access);
        this.noiseCaveGenerator = new NoiseCaveGenerator(seed, access);
    }

    public BiomeGenerator(long seed, BiomeGenerator other) {
        this.surfaceDecorator = other.surfaceDecorator;
        this.featureDecorator = other.featureDecorator;
        this.noiseCaveGenerator = new NoiseCaveGenerator(seed, other.noiseCaveGenerator);
    }

    public void surface(ChunkAccess chunk, WorldGenRegion region, Generator generator) {
        this.surfaceDecorator.decorate(chunk, region, generator);
        this.surfaceDecorator.decoratePost(chunk, generator);
    }

    public void carve(long seed, ChunkAccess chunk, WorldGenRegion region, BiomeManager biomes, GenerationStep.Carving step, Generator generator) {
        this.noiseCaveGenerator.carve(chunk, generator);
    }

    public void decorate(ChunkAccess chunk, WorldGenLevel region, StructureFeatureManager structures, Generator generator) {
        CompletableFuture<TerrainData> terrain = generator.getChunkDataAsync(chunk.m_7697_());
        this.featureDecorator.decorate(chunk, region, structures, terrain, generator);
        this.noiseCaveGenerator.decorate(chunk, region, generator);
        Surface.smoothWater(chunk, region, terrain.join());
        Surface.applyPost(chunk, terrain.join(), generator);
    }

    protected static void buildVanillaSurface(ChunkAccess chunk, WorldGenRegion region, Generator generator) {
        WorldGenerationContext context = new WorldGenerationContext((ChunkGenerator)generator, (LevelHeightAccessor)region);
        NoiseChunk noiseChunk = NoiseChunkUtil.getNoiseChunk(chunk, generator);
        Registry<Biome> biomes = generator.getBiomeSource().getRegistry();
        BiomeManager biomeManager = region.m_7062_();
        SurfaceSystem surface = generator.getVanillaGen().getSurfaceSystem();
        SurfaceRules.RuleSource surfaceRules = ((NoiseGeneratorSettings)generator.getVanillaGen().getSettings().m_203334_()).f_188871_();
        surface.m_189944_(biomeManager, biomes, false, context, chunk, noiseChunk, surfaceRules);
    }
}

