/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome;

import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.util.map.WeightMap;
import com.terraforged.mod.worldgen.biome.IBiomeSampler;
import com.terraforged.mod.worldgen.biome.util.BiomeMapManager;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.noise.climate.ClimateSample;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeSampler
extends IBiomeSampler.Sampler
implements IBiomeSampler {
    protected final BiomeMapManager biomeMapManager;
    protected final float beachSize = 0.005f;

    public BiomeSampler(INoiseGenerator noiseGenerator, BiomeMapManager biomeMapManager) {
        super(noiseGenerator);
        this.biomeMapManager = biomeMapManager;
    }

    public Holder<Biome> sampleBiome(int x, int z) {
        ClimateSample sample = this.getSample(x, z);
        Holder<Biome> biome = this.getInitialBiome(sample.biomeNoise, sample.climateType);
        return this.getBiomeOverride(biome, sample);
    }

    private Holder<Biome> getInitialBiome(float noise, BiomeType climateType) {
        WeightMap<Holder<Biome>> map = this.biomeMapManager.getBiomeMap().get((Object)climateType);
        if (map == null || map.isEmpty()) {
            return this.biomeMapManager.getBiomes().m_206081_(Biomes.f_48202_);
        }
        return map.getValue(noise);
    }

    protected Holder<Biome> getBiomeOverride(Holder<Biome> input, ClimateSample sample) {
        BiomeType biomeType = sample.climateType;
        if (sample.continentNoise <= 0.25f) {
            return switch (biomeType) {
                case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48171_);
                case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48172_);
                case BiomeType.DESERT, BiomeType.SAVANNA, BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48170_);
                default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48225_);
            };
        }
        if (sample.continentNoise <= 0.5f) {
            return switch (biomeType) {
                case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48168_);
                case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48211_);
                case BiomeType.DESERT, BiomeType.SAVANNA, BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48166_);
                default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48174_);
            };
        }
        if (sample.continentNoise <= 0.505f) {
            return switch (biomeType) {
                case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48148_);
                case BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_186760_);
                default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48217_);
            };
        }
        if ((sample.terrainType.isRiver() || sample.terrainType.isLake()) && sample.riverNoise == 0.0f) {
            return biomeType == BiomeType.TUNDRA ? this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48212_) : this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48208_);
        }
        return input;
    }
}

