/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.surface;

import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;

public class Surface {
    protected static final TagKey<Block> ERODIBLE = BlockTags.f_144274_;

    public static void apply(TerrainData terrainData, ChunkAccess chunk, ChunkGenerator generator) {
        float norm = 55.0f * ((float)generator.m_6331_() / 255.0f);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                BlockState solid;
                int y;
                float gradient = terrainData.getGradient(dx, dz, norm);
                if (y < generator.m_6337_() || gradient < 0.6f || (solid = Surface.findSolid(pos.m_122178_(dx, y, dz), chunk)) == null) continue;
                int bottom = pos.m_123342_();
                for (y = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, dx, dz); y > bottom; --y) {
                    chunk.m_6978_((BlockPos)pos.m_142448_(y), solid, false);
                }
            }
        }
    }

    public static void applyPost(ChunkAccess chunk, TerrainData terrainData, ChunkGenerator generator) {
        float norm = 70.0f * ((float)generator.m_6331_() / 255.0f);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dx, dz) + 1;
                pos.m_122178_(dx, y, dz);
                BlockState state = chunk.m_8055_((BlockPos)pos);
                float gradient = terrainData.getGradient(dx, dz, norm);
                if (gradient < 0.625f) {
                    if (!(state.m_60734_() instanceof SnowLayerBlock)) continue;
                    Surface.smoothSnow(pos, state, chunk, terrainData);
                    continue;
                }
                if (state.m_60795_()) {
                    state = chunk.m_8055_((BlockPos)pos.m_142448_(y - 1));
                }
                if (!state.m_204336_(BlockTags.f_144279_)) continue;
                Surface.erodeSnow(pos, chunk);
            }
        }
    }

    public static void smoothWater(ChunkAccess chunk, WorldGenLevel region, TerrainData terrainData) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minX = chunk.m_7697_().m_45604_();
        int minZ = chunk.m_7697_().m_45605_();
        BlockState waterState = (BlockState)Blocks.f_49990_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(2));
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                if (!Surface.isSmoothable(dx, dz, terrainData)) continue;
                int x = minX + dx;
                int z = minZ + dz;
                int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dx, dz);
                BlockState state = chunk.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                if (!state.m_60713_(Blocks.f_49990_) || (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) != 0 || !Surface.shouldSmooth(x, y, z, chunk, region, pos)) continue;
                chunk.m_6978_((BlockPos)pos.m_122178_(x, y, z), waterState, false);
            }
        }
    }

    protected static boolean shouldSmooth(int x, int y, int z, ChunkAccess chunk, WorldGenLevel region, BlockPos.MutableBlockPos pos) {
        int radius = 6;
        int radius2 = radius * radius;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                int d2 = dx * dx + dz * dz;
                if (d2 == 0 || d2 > radius2) continue;
                pos.m_122178_(x + dx, y, z + dz);
                ChunkAccess world = Surface.sameChunk((BlockPos)pos, chunk.m_7697_()) ? chunk : region;
                BlockState state = world.m_8055_((BlockPos)pos);
                if (!state.m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isSmoothable(int x, int z, TerrainData terrainData) {
        float river = terrainData.getRiver().get(x, z);
        Terrain terrain = terrainData.getTerrain().get(x, z);
        return (terrain.isRiver() || terrain.isLake()) && river == 0.0f;
    }

    protected static void smoothSnow(BlockPos.MutableBlockPos pos, BlockState state, ChunkAccess chunk, TerrainData terrain) {
        float height = terrain.getHeight().get(pos.m_123341_(), pos.m_123343_());
        float delta = height - (float)terrain.getLevels().getHeight(height);
        int layers = 1 + NoiseUtil.floor(delta * 7.9999f);
        state = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers));
        chunk.m_6978_((BlockPos)pos, state, false);
    }

    protected static void erodeSnow(BlockPos.MutableBlockPos pos, ChunkAccess chunk) {
        chunk.m_6978_((BlockPos)pos, Blocks.f_50016_.m_49966_(), false);
        int y0 = pos.m_123342_() - 1;
        int y1 = Math.max(pos.m_123342_() - 15, 0);
        for (int y = y0; y > y1; --y) {
            pos.m_142448_(y);
            BlockState state = chunk.m_8055_((BlockPos)pos);
            if (!Surface.isErodible(state)) {
                return;
            }
            chunk.m_6978_((BlockPos)pos, Blocks.f_50069_.m_49966_(), false);
        }
    }

    public static boolean isErodible(BlockState state) {
        return state.m_204336_(ERODIBLE) || state.m_204336_(BlockTags.f_144279_);
    }

    protected static boolean sameChunk(BlockPos pos, ChunkPos chunk) {
        return pos.m_123341_() >> 4 == chunk.f_45578_ && pos.m_123343_() >> 4 == chunk.f_45579_;
    }

    protected static BlockState findSolid(BlockPos.MutableBlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.m_8055_((BlockPos)pos);
        if (!Surface.isErodible(state)) {
            return null;
        }
        int bottom = Math.max(0, pos.m_123342_() - 20);
        for (int y = pos.m_123342_() - 1; y > bottom; --y) {
            state = chunk.m_8055_((BlockPos)pos.m_142448_(y));
            if (Surface.isErodible(state)) continue;
            return state;
        }
        return null;
    }
}

