/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.util;

import com.terraforged.mod.worldgen.biome.util.DelegateBiomeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;

public class BufferedBiomeManager
extends DelegateBiomeManager {
    private static final ThreadLocal<BufferedBiomeManager> LOCAL_BIOME_MANAGER = ThreadLocal.withInitial(BufferedBiomeManager::new);
    protected int misses;
    protected int requests;
    protected ChunkPos chunkPos;
    protected final Holder<Biome>[] buffer = new Holder[256];
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    void set(ChunkPos chunkPos, BiomeManager biomeManager) {
        this.misses = 0;
        this.requests = 0;
        this.chunkPos = chunkPos;
        this.setDelegate(biomeManager);
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                Holder biome;
                this.pos.m_122178_(x + dx, 64, z + dz);
                this.buffer[BufferedBiomeManager.index((int)dx, (int)dz)] = biome = biomeManager.m_204214_((BlockPos)this.pos);
            }
        }
    }

    @Override
    public Holder<Biome> m_204214_(BlockPos pos) {
        ++this.requests;
        int x = pos.m_123341_() >> 4;
        int z = pos.m_123343_() >> 4;
        if (x == this.chunkPos.f_45578_ && z == this.chunkPos.f_45579_) {
            int dx = pos.m_123341_() - this.chunkPos.m_45604_();
            int dz = pos.m_123343_() - this.chunkPos.m_45605_();
            return this.buffer[BufferedBiomeManager.index(dx, dz)];
        }
        ++this.misses;
        return this.delegate.m_204214_(pos);
    }

    public void report() {
    }

    private static int index(int dx, int dz) {
        return dz << 4 | dx;
    }

    public static BufferedBiomeManager assign(ChunkPos chunkPos, BiomeManager biomeManager) {
        BufferedBiomeManager manager = LOCAL_BIOME_MANAGER.get();
        manager.set(chunkPos, biomeManager);
        return manager;
    }
}

