/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.cave;

import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.util.ObjectPool;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.asset.NoiseCave;
import com.terraforged.mod.worldgen.cave.CarverChunk;
import com.terraforged.mod.worldgen.cave.CaveType;
import com.terraforged.mod.worldgen.cave.NoiseCaveCarver;
import com.terraforged.mod.worldgen.cave.NoiseCaveDecorator;
import com.terraforged.mod.worldgen.cave.UniqueCaveDistributor;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;

public class NoiseCaveGenerator {
    protected static final int POOL_SIZE = 32;
    protected static final float DENSITY = 0.05f;
    protected static final float BREACH_THRESHOLD = 0.7f;
    protected static final int GLOBAL_CAVE_REPS = 2;
    protected final NoiseCave[] caves;
    protected final Module uniqueCaveNoise;
    protected final Module caveBreachNoise;
    protected final ObjectPool<CarverChunk> pool;
    protected final Map<ChunkPos, CarverChunk> cache = new ConcurrentHashMap<ChunkPos, CarverChunk>();

    public NoiseCaveGenerator(long seed, RegistryAccess access) {
        this.uniqueCaveNoise = NoiseCaveGenerator.createUniqueNoise((int)seed, 500, 0.05f);
        this.caveBreachNoise = NoiseCaveGenerator.createBreachNoise((int)seed + 12, 300, 0.7f);
        this.caves = NoiseCaveGenerator.createArray(seed, (Iterable<NoiseCave>)access.m_175515_((ResourceKey)ModRegistry.CAVE.get()));
        this.pool = new ObjectPool<CarverChunk>(32, this::createCarverChunk);
    }

    public NoiseCaveGenerator(long seed, NoiseCaveGenerator other) {
        this.caves = NoiseCaveGenerator.copyOf(seed, other.caves);
        this.uniqueCaveNoise = NoiseCaveGenerator.createUniqueNoise((int)seed, 500, 0.05f);
        this.caveBreachNoise = NoiseCaveGenerator.createBreachNoise((int)seed + 12, 300, 0.7f);
        this.pool = new ObjectPool<CarverChunk>(32, this::createCarverChunk);
    }

    public void carve(ChunkAccess chunk, Generator generator) {
        CarverChunk carver = this.getPreCarveChunk(chunk);
        carver.terrainData = generator.getChunkData(chunk.m_7697_());
        carver.mask = this.caveBreachNoise;
        for (NoiseCave config : this.caves) {
            carver.modifier = this.getModifier(config);
            NoiseCaveCarver.carve(chunk, carver, generator, config, true);
        }
    }

    public void decorate(ChunkAccess chunk, WorldGenLevel region, Generator generator) {
        CarverChunk carver = this.getPostCarveChunk(chunk, generator);
        for (NoiseCave config : this.caves) {
            NoiseCaveDecorator.decorate(chunk, carver, region, generator, config);
        }
        this.pool.restore(carver);
    }

    private CarverChunk getPreCarveChunk(ChunkAccess chunk) {
        return this.cache.computeIfAbsent(chunk.m_7697_(), p -> this.pool.take().reset());
    }

    private CarverChunk getPostCarveChunk(ChunkAccess chunk, Generator generator) {
        CarverChunk carver = this.cache.remove(chunk.m_7697_());
        if (carver != null) {
            return carver;
        }
        carver = this.pool.take().reset();
        carver.mask = this.caveBreachNoise;
        carver.terrainData = generator.getChunkData(chunk.m_7697_());
        for (NoiseCave config : this.caves) {
            carver.modifier = this.getModifier(config);
            NoiseCaveCarver.carve(chunk, carver, generator, config, false);
        }
        return carver;
    }

    private Module getModifier(NoiseCave cave) {
        return switch (cave.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CaveType.GLOBAL -> Source.ONE;
            case CaveType.UNIQUE -> this.uniqueCaveNoise;
        };
    }

    private CarverChunk createCarverChunk() {
        return new CarverChunk(this.caves.length);
    }

    private static Module createUniqueNoise(int seed, int scale, float density) {
        return new UniqueCaveDistributor(seed + 1286745, 1.0f / (float)scale, 0.75f, density).clamp(0.2, 1.0).map(0.0, 1.0).warp(seed + 781624, 30, 1, 20.0);
    }

    private static Module createBreachNoise(int seed, int scale, float threshold) {
        return Source.simplexRidge(seed, scale, 2).clamp(threshold * 0.8f, threshold).map(0.0, 1.0);
    }

    private static NoiseCave[] copyOf(long seed, NoiseCave[] other) {
        NoiseCave[] array = Arrays.copyOf(other, other.length);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].withSeed(seed);
        }
        return array;
    }

    private static NoiseCave[] createArray(long seed, Iterable<NoiseCave> source) {
        int length = 0;
        for (NoiseCave cave : source) {
            length += NoiseCaveGenerator.getCount(cave);
        }
        NoiseCave[] array = new NoiseCave[length];
        int i = 0;
        for (NoiseCave cave : source) {
            int count = NoiseCaveGenerator.getCount(cave);
            for (int j = 0; j < count; ++j) {
                array[i++] = cave.withSeed(seed + (long)j * 16421058L);
            }
        }
        return array;
    }

    private static int getCount(NoiseCave cave) {
        return cave.getType() == CaveType.GLOBAL ? 2 : 1;
    }
}

