/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.datapack;

import com.terraforged.mod.TerraForged;
import com.terraforged.mod.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.world.level.DataPackConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DataPackExporter {
    public static final String PACK = "file/TerraForged.zip";
    public static final Path CONFIG_DIR = Paths.get("config", "terraforged").toAbsolutePath();
    public static final Path DEFAULT_PACK_DIR = CONFIG_DIR.resolve("pack-v0.1");

    public static void extractDefaultPack() {
        try {
            TerraForged.LOG.info("Extracting default datapack to {}", (Object)DEFAULT_PACK_DIR);
            Path root = TerraForged.getPlatform().getContainer();
            FileUtil.createDirCopy(root, "default", DEFAULT_PACK_DIR);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Pair<Path, String> getDefaultsPath() {
        if (!Files.exists(DEFAULT_PACK_DIR, new LinkOption[0])) {
            DataPackExporter.extractDefaultPack();
            if (!Files.exists(DEFAULT_PACK_DIR, new LinkOption[0])) {
                TerraForged.LOG.warn("Failed to extract default datapack to {}", (Object)DEFAULT_PACK_DIR);
                return Pair.of((Object)TerraForged.getPlatform().getContainer(), (Object)"default");
            }
        }
        return Pair.of((Object)DEFAULT_PACK_DIR, (Object)".");
    }

    public static DataPackConfig setup(@Nullable Path dir, DataPackConfig config) {
        if (dir == null) {
            throw new NullPointerException("Dir is null!");
        }
        TerraForged.LOG.info("Generating TerraForged datapack");
        try {
            Pair<Path, String> src = DataPackExporter.getDefaultsPath();
            Path dest = dir.resolve("TerraForged.zip");
            FileUtil.createZipCopy((Path)src.getLeft(), (String)src.getRight(), dest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> enabled = new ArrayList<String>(config.m_45850_());
        enabled.add(PACK);
        ArrayList disabled = new ArrayList(config.m_45855_());
        disabled.remove(PACK);
        return new DataPackConfig(enabled, disabled);
    }
}

