/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.profiler;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.terraforged.mod.util.ReflectionUtil;
import com.terraforged.mod.worldgen.IGenerator;
import com.terraforged.mod.worldgen.profiler.GenTimer;
import com.terraforged.mod.worldgen.profiler.ProfilerStages;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class GeneratorProfiler
extends ChunkGenerator
implements IGenerator {
    public static final Codec<GeneratorProfiler> CODEC = ChunkGenerator.f_62136_.xmap(GeneratorProfiler::wrap, GeneratorProfiler::getGenerator);
    public static final AtomicBoolean PROFILING = new AtomicBoolean(true);
    protected static final MethodHandle STRUCTURE_REGISTRY = ReflectionUtil.field(ChunkGenerator.class, Registry.class, new String[0]);
    protected static final MethodHandle STRUCTURE_OVERRIDES = ReflectionUtil.field(ChunkGenerator.class, Optional.class, new String[0]);
    private static final long LOG_INTERVAL_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final long DEBUG_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
    protected final ChunkGenerator generator;
    protected final ProfilerStages stages = new ProfilerStages();

    private GeneratorProfiler(Registry<StructureSet> structures, Optional<HolderSet<StructureSet>> overrides, ChunkGenerator generator) {
        super(structures, overrides, generator.m_62218_());
        this.generator = generator;
    }

    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new GeneratorProfiler((Registry<StructureSet>)this.f_207955_, this.f_207956_, this.generator.m_6819_(seed));
    }

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> m_187743_() {
        return this.generator.m_187743_();
    }

    public Climate.Sampler m_183403_() {
        return this.generator.m_183403_();
    }

    public Holder<Biome> m_203495_(int p_187755_, int p_187756_, int p_187757_) {
        return this.generator.m_203495_(p_187755_, p_187756_, p_187757_);
    }

    public void m_62199_(RegistryAccess p_62200_, StructureFeatureManager p_62201_, ChunkAccess p_62202_, StructureManager p_62203_, long p_62204_) {
        GenTimer timer = this.stages.starts.start();
        this.generator.m_62199_(p_62200_, p_62201_, p_62202_, p_62203_, p_62204_);
        timer.punchOut();
    }

    public void m_62177_(WorldGenLevel p_62178_, StructureFeatureManager p_62179_, ChunkAccess p_62180_) {
        GenTimer timer = this.stages.refs.start();
        this.generator.m_62177_(p_62178_, p_62179_, p_62180_);
        timer.punchOut();
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_196743_, Executor p_196744_, Blender p_196745_, StructureFeatureManager p_196746_, ChunkAccess p_196747_) {
        return CompletableFuture.completedFuture(this.stages.biomes.start()).thenCombine((CompletionStage)this.generator.m_196423_(p_196743_, p_196744_, p_196745_, p_196746_, p_196747_), GenTimer::punchOut);
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor p_187748_, Blender p_187749_, StructureFeatureManager p_187750_, ChunkAccess p_187751_) {
        return CompletableFuture.completedFuture(this.stages.noise.start()).thenCombine((CompletionStage)this.generator.m_183489_(p_187748_, p_187749_, p_187750_, p_187751_), GenTimer::punchOut);
    }

    public void m_183621_(WorldGenRegion p_187697_, StructureFeatureManager p_187698_, ChunkAccess p_187699_) {
        GenTimer timer = this.stages.surface.start();
        this.generator.m_183621_(p_187697_, p_187698_, p_187699_);
        timer.punchOut();
    }

    public void m_183516_(WorldGenRegion p_187691_, long p_187692_, BiomeManager p_187693_, StructureFeatureManager p_187694_, ChunkAccess p_187695_, GenerationStep.Carving p_187696_) {
        GenTimer timer = this.stages.carve.start();
        this.generator.m_183516_(p_187691_, p_187692_, p_187693_, p_187694_, p_187695_, p_187696_);
        timer.punchOut();
    }

    public void m_183372_(WorldGenLevel p_187712_, ChunkAccess p_187713_, StructureFeatureManager p_187714_) {
        GenTimer timer = this.stages.decoration.start();
        this.generator.m_183372_(p_187712_, p_187713_, p_187714_);
        timer.punchOut();
        this.stages.incrementChunks();
    }

    public Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_207970_(ServerLevel p_62162_, HolderSet<ConfiguredStructureFeature<?, ?>> p_62163_, BlockPos p_62164_, int p_62165_, boolean p_62166_) {
        return this.generator.m_207970_(p_62162_, p_62163_, p_62164_, p_62165_, p_62166_);
    }

    public void m_6929_(WorldGenRegion p_62167_) {
        this.generator.m_6929_(p_62167_);
    }

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return this.generator.m_142051_(p_156157_);
    }

    public BiomeSource m_62218_() {
        return this.generator.m_62218_();
    }

    public int m_6331_() {
        return this.generator.m_6331_();
    }

    public int m_6337_() {
        return this.generator.m_6337_();
    }

    public int m_142062_() {
        return this.generator.m_142062_();
    }

    public int m_142647_(int p_156153_, int p_156154_, Heightmap.Types p_156155_, LevelHeightAccessor p_156156_) {
        return this.generator.m_142647_(p_156153_, p_156154_, p_156155_, p_156156_);
    }

    public NoiseColumn m_141914_(int p_156150_, int p_156151_, LevelHeightAccessor p_156152_) {
        return this.generator.m_141914_(p_156150_, p_156151_, p_156152_);
    }

    public int m_156174_(int p_156175_, int p_156176_, Heightmap.Types p_156177_, LevelHeightAccessor p_156178_) {
        return this.generator.m_156174_(p_156175_, p_156176_, p_156177_, p_156178_);
    }

    public int m_156179_(int p_156180_, int p_156181_, Heightmap.Types p_156182_, LevelHeightAccessor p_156183_) {
        return this.generator.m_156179_(p_156180_, p_156181_, p_156182_, p_156183_);
    }

    public void m_207076_(List<String> lines, BlockPos pos) {
        this.generator.m_207076_(lines, pos);
        this.stages.addDebugInfo(DEBUG_INTERVAL_MS, lines);
    }

    private static Registry<StructureSet> getStructures(ChunkGenerator generator) {
        try {
            return STRUCTURE_REGISTRY.invokeExact(generator);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private static Optional<HolderSet<StructureSet>> getOverrides(ChunkGenerator generator) {
        try {
            return STRUCTURE_OVERRIDES.invokeExact(generator);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static GeneratorProfiler wrap(ChunkGenerator generator) {
        if (generator instanceof GeneratorProfiler) {
            GeneratorProfiler profiler = (GeneratorProfiler)generator;
            generator = profiler.getGenerator();
        }
        Registry<StructureSet> structures = GeneratorProfiler.getStructures(generator);
        Optional<HolderSet<StructureSet>> overrides = GeneratorProfiler.getOverrides(generator);
        return new GeneratorProfiler(structures, overrides, generator);
    }
}

