/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.util.delegate;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public class DelegateRegion
extends WorldGenRegion {
    public static final ThreadLocal<Builder> LOCAL_BUILDER = ThreadLocal.withInitial(Builder::new);

    public DelegateRegion(ServerLevel level, List<ChunkAccess> chunks, ChunkStatus status, ChunkStatus stage) {
        super(level, chunks, status, DelegateRegion.getCutoffRadius(stage));
    }

    public static int getCutoffRadius(ChunkStatus status) {
        int cutoff = 0;
        if (status == ChunkStatus.f_62316_) {
            cutoff = -1;
        } else if (status == ChunkStatus.f_62317_) {
            cutoff = -1;
        } else if (status == ChunkStatus.f_62322_) {
            cutoff = 1;
        } else if (status == ChunkStatus.f_62324_) {
            cutoff = -1;
        }
        return cutoff;
    }

    public static class Builder {
        private ServerLevel level;
        private ChunkStatus status;
        private final List<ChunkAccess> chunks = new ArrayList<ChunkAccess>(289);

        public Builder source(WorldGenRegion region) {
            this.chunks.clear();
            this.level = region.m_6018_();
            this.status = ChunkStatus.f_62314_;
            ChunkPos center = region.m_143488_();
            for (int dz = -8; dz <= 8; ++dz) {
                for (int dx = -8; dx <= 8; ++dx) {
                    int cx = center.f_45578_ + dx;
                    int cz = center.f_45579_ + dz;
                    if (!region.m_7232_(cx, cz)) continue;
                    ChunkAccess chunk = region.m_6325_(cx, cz);
                    this.chunks.add(chunk);
                    if (dx != 0 || dz != 0) continue;
                    this.status = chunk.m_6415_();
                }
            }
            return this;
        }

        public <T extends WorldGenRegion> T build(ChunkStatus stage, Factory<T> factory) {
            return factory.build(this.level, this.chunks, this.status, stage);
        }
    }

    public static interface Factory<T extends WorldGenRegion> {
        public T build(ServerLevel var1, List<ChunkAccess> var2, ChunkStatus var3, ChunkStatus var4);
    }
}

