/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IColorablePanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.gui.ClearPanelGUI;
import com.dannyandson.tinyredstone.gui.PanelCrashGUI;
import com.dannyandson.tinyredstone.gui.TinyBlockGUI;
import com.dannyandson.tinyredstone.items.RedstoneWrench;
import com.dannyandson.tinyredstone.setup.Registration;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class PanelBlock
extends Block {
    private static final Map<Direction, VoxelShape> BASE = new HashMap<Direction, VoxelShape>();
    private static final Map<Item, Class<? extends IPanelCell>> itemPanelCellMap;
    private static final Map<Class<? extends IPanelCell>, Item> panelCellItemMap;
    private static final Map<Item, Class<? extends IPanelCover>> itemPanelCoverMap;
    private static final Map<Class<? extends IPanelCover>, Item> panelCoverItemMap;

    public PanelBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(2.0f));
    }

    public Class<? extends IPanelCell> getIPanelCellByItem(Item item) {
        return itemPanelCellMap.get(item);
    }

    public Item getItemByIPanelCell(Class<? extends IPanelCell> panelCell) {
        return panelCellItemMap.get(panelCell);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PanelTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)context.func_196000_l().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext context) {
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof PanelTile) {
            return ((PanelTile)te).getVoxelShape();
        }
        return BASE.get(state.func_177229_b((Property)BlockStateProperties.field_208155_H));
    }

    public boolean func_149744_f(BlockState iBlockState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader blockReader, BlockPos pos, @Nullable Direction directionFromNeighborToThis) {
        TileEntity tileentity = blockReader.func_175625_s(pos);
        if (tileentity instanceof PanelTile && directionFromNeighborToThis != null) {
            PanelTile panelTile = (PanelTile)tileentity;
            Direction facing = directionFromNeighborToThis.func_176734_d();
            return panelTile.hasCellsOnFace(facing);
        }
        return super.canConnectRedstone(state, blockReader, pos, directionFromNeighborToThis);
    }

    public int func_180656_a(BlockState state, IBlockReader blockReader, BlockPos pos, Direction directionFromNeighborToThis) {
        TileEntity tileentity = blockReader.func_175625_s(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            Integer power = panelTile.weakPowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.func_176734_d()));
            return power == null ? 0 : power;
        }
        return 0;
    }

    public int func_176211_b(BlockState state, IBlockReader blockReader, BlockPos pos, Direction directionFromNeighborToThis) {
        TileEntity tileentity = blockReader.func_175625_s(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            Integer power = panelTile.strongPowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.func_176734_d()));
            return power == null ? 0 : power;
        }
        return 0;
    }

    public void func_220069_a(BlockState currentState, World world, BlockPos pos, Block blockIn, BlockPos neighborPos, boolean isMoving) {
        Direction direction;
        if (pos.func_177974_f().equals((Object)neighborPos)) {
            direction = Direction.EAST;
        } else if (pos.func_177968_d().equals((Object)neighborPos)) {
            direction = Direction.SOUTH;
        } else if (pos.func_177976_e().equals((Object)neighborPos)) {
            direction = Direction.WEST;
        } else if (pos.func_177978_c().equals((Object)neighborPos)) {
            direction = Direction.NORTH;
        } else if (pos.func_177984_a().equals((Object)neighborPos)) {
            direction = Direction.UP;
        } else if (pos.func_177977_b().equals((Object)neighborPos)) {
            direction = Direction.DOWN;
        } else {
            return;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof PanelTile) {
            boolean change = false;
            PanelTile panelTile = (PanelTile)tileentity;
            try {
                Side side = panelTile.getSideFromDirection(direction);
                if (side != null) {
                    if (panelTile.pingOutwardObservers(direction)) {
                        change = true;
                    }
                    if (panelTile.updateSide(direction)) {
                        change = true;
                    }
                    if (panelTile.updateOutputs() && !world.field_72995_K) {
                        panelTile.func_70296_d();
                    }
                    if (change) {
                        panelTile.flagSync();
                    }
                }
            }
            catch (Exception e) {
                panelTile.handleCrash(e);
            }
        }
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.get((String)"wrench");
    }

    private ItemStack getItemWithNBT(IBlockReader worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            ItemStack itemstack = this.func_185473_a(worldIn, pos, state);
            CompoundNBT compoundnbt = panelTile.saveToNbt(new CompoundNBT());
            if (!compoundnbt.isEmpty()) {
                itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
            }
            return itemstack;
        }
        return null;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemStack itemstack;
        if (!player.func_184812_l_() && (itemstack = this.getItemWithNBT((IBlockReader)worldIn, pos, state)) != null) {
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        PanelCellPos panelCellPos;
        PanelTile panelTile;
        IPanelCell cell;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PanelTile && (cell = (panelTile = (PanelTile)te).getIPanelCell(panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H), ((RedstoneWrench)Registration.REDSTONE_WRENCH.get()).getBlockRayTraceResult(player.field_70170_p, player)))) != null) {
            return panelCellItemMap.get(cell.getClass()).func_190903_i();
        }
        ItemStack itemStack = this.getItemWithNBT(world, pos, state);
        if (itemStack == null) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        return itemStack;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        boolean handled;
        block45: {
            handled = false;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof PanelTile && hand == Hand.MAIN_HAND) {
                PanelTile panelTile = (PanelTile)te;
                try {
                    block46: {
                        PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, result);
                        if (posInPanelCell == null) break block45;
                        Item heldItem = player.func_184586_b(hand).func_77973_b();
                        if (panelTile.isCrashed()) {
                            if (world.field_72995_K) {
                                PanelCrashGUI.open(panelTile);
                            }
                            handled = true;
                        } else if (posInPanelCell.getIPanelCell() == null && heldItem == Registration.REDSTONE_WRENCH.get() && !player.func_213453_ef() && !panelTile.isCovered()) {
                            panelTile.func_189667_a(Rotation.CLOCKWISE_90);
                            handled = true;
                        } else if (heldItem == Registration.REDSTONE_WRENCH.get() && player.func_213453_ef()) {
                            this.func_176208_a(world, pos, state, player);
                            if (!world.field_72995_K) {
                                world.func_175655_b(pos, true);
                            }
                            handled = true;
                        } else if (heldItem == Registration.TINY_COLOR_SELECTOR.get() && posInPanelCell.getIPanelCell() instanceof IColorablePanelCell) {
                            if (world.field_72995_K) {
                                TinyBlockGUI.open(panelTile, posInPanelCell.getIndex(), (IColorablePanelCell)((Object)posInPanelCell.getIPanelCell()));
                            }
                        } else if (heldItem instanceof DyeItem) {
                            int color = ((DyeItem)heldItem).func_195962_g().getColorValue();
                            if (color != panelTile.Color) {
                                panelTile.Color = ((DyeItem)heldItem).func_195962_g().getColorValue();
                                if (!player.func_184812_l_()) {
                                    player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
                                }
                            }
                            handled = true;
                        } else {
                            if (heldItem.equals(Items.field_221803_eL) && player.func_195047_I_().equals("Dev")) {
                                throw new Exception("Test Exception");
                            }
                            if (itemPanelCoverMap.containsKey(heldItem) && !panelTile.isCovered()) {
                                try {
                                    Object panelCoverObject = itemPanelCoverMap.get(heldItem).getConstructors()[0].newInstance(new Object[0]);
                                    if (!(panelCoverObject instanceof IPanelCover)) break block46;
                                    panelTile.panelCover = (IPanelCover)panelCoverObject;
                                    panelTile.flagLightUpdate = true;
                                    if (!world.field_72995_K) {
                                        world.func_184138_a(pos, state, state, 2);
                                    }
                                    if (!player.func_184812_l_()) {
                                        player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
                                    }
                                }
                                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                    TinyRedstone.LOGGER.error("Exception thrown while" + e.getMessage());
                                }
                            } else if (posInPanelCell.getIPanelCell() != null && !panelTile.isCovered() && posInPanelCell.getIPanelCell().hasActivation() && !player.func_213453_ef()) {
                                if (posInPanelCell.getIPanelCell().onBlockActivated(posInPanelCell, posInPanelCell.getSegment(), player)) {
                                    panelTile.updateCell(posInPanelCell);
                                    panelTile.updateNeighborCells(posInPanelCell);
                                    if (posInPanelCell.getIPanelCell() instanceof RedstoneDust) {
                                        PanelCellPos above = posInPanelCell.offset(Side.TOP);
                                        PanelCellPos below = posInPanelCell.offset(Side.BOTTOM);
                                        if (above != null) {
                                            panelTile.updateNeighborCells(above);
                                        }
                                        if (below != null) {
                                            panelTile.updateNeighborCells(below);
                                        }
                                    }
                                }
                                handled = true;
                            } else if (itemPanelCellMap.containsKey(heldItem) && !panelTile.isCovered()) {
                                PanelCellPos pos1 = posInPanelCell;
                                if (pos1.getIPanelCell() != null) {
                                    pos1 = posInPanelCell.offset(panelTile.getSideFromDirection(result.func_216354_b()));
                                }
                                if (pos1 != null && pos1.getIPanelCell() == null && !panelTile.checkCellForPistonExtension(pos1)) {
                                    try {
                                        Object panelCell = itemPanelCellMap.get(heldItem).getConstructors()[0].newInstance(new Object[0]);
                                        if (panelCell instanceof IPanelCell) {
                                            PanelCellPos basePos;
                                            boolean placementOK = true;
                                            if (((IPanelCell)panelCell).needsSolidBase() && (basePos = pos1.offset(Side.BOTTOM)) != null && (basePos.getIPanelCell() == null || !basePos.getIPanelCell().isPushable())) {
                                                placementOK = false;
                                            }
                                            if (placementOK) {
                                                Side rotationLock = RotationLock.getServerRotationLock(player);
                                                pos1.getPanelTile().addCell(pos1, (IPanelCell)panelCell, rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing(player, ((IPanelCell)panelCell).canPlaceVertical())) : rotationLock, player);
                                                if (!player.func_184812_l_()) {
                                                    player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
                                                }
                                            }
                                        }
                                    }
                                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                        TinyRedstone.LOGGER.error(e.getMessage());
                                    }
                                }
                                handled = true;
                            } else if (panelTile.isOverflown()) {
                                if (world.field_72995_K) {
                                    PanelCrashGUI.open(panelTile);
                                }
                                handled = true;
                            }
                        }
                    }
                    panelTile.flagSync();
                    if (!world.field_72995_K) {
                        panelTile.func_70296_d();
                    }
                    panelTile.updateOutputs();
                }
                catch (Exception e) {
                    panelTile.handleCrash(e);
                }
            }
        }
        if (handled) {
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        int ll = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            ll = panelTile.getLightOutput();
        }
        return Math.min(ll, world.func_201572_C());
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        TileEntity te;
        Item heldItem = player.func_184614_ca().func_77973_b();
        if ((heldItem == Registration.REDSTONE_WRENCH.get() || itemPanelCellMap.containsKey(heldItem) || itemPanelCoverMap.containsKey(heldItem)) && (te = world.func_175625_s(pos)) instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            try {
                if (panelTile.isCovered()) {
                    this.removeCover(panelTile, player);
                    panelTile.flagLightUpdate = true;
                } else if (heldItem == Registration.REDSTONE_WRENCH.get() && player.func_213453_ef()) {
                    if (world.func_201670_d()) {
                        ClearPanelGUI.open(panelTile);
                    }
                } else {
                    BlockRayTraceResult result = ((RedstoneWrench)Registration.REDSTONE_WRENCH.get()).getBlockRayTraceResult(world, player);
                    PanelCellPos panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H), result);
                    if (panelCellPos != null && panelCellPos.getIPanelCell() != null) {
                        this.removeCell(panelCellPos, player);
                    }
                }
            }
            catch (Exception e) {
                panelTile.handleCrash(e);
            }
        }
    }

    protected void removeCell(PanelCellPos cellPos, @Nullable PlayerEntity player) {
        if (cellPos.getIPanelCell() != null) {
            PanelTile panelTile = cellPos.getPanelTile();
            World world = panelTile.func_145831_w();
            BlockPos pos = panelTile.func_174877_v();
            if (player == null || !player.func_184812_l_()) {
                Item item = panelCellItemMap.get(cellPos.getIPanelCell().getClass());
                ItemStack itemStack = new ItemStack((IItemProvider)item);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), itemStack);
                world.func_217376_c((Entity)itemEntity);
                if (player != null) {
                    itemEntity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                }
            }
            panelTile.removeCell(cellPos);
        }
    }

    private void removeCover(PanelTile panelTile, PlayerEntity player) {
        if (panelTile.isCovered()) {
            World world = panelTile.func_145831_w();
            BlockPos pos = panelTile.func_174877_v();
            if (!player.func_184812_l_()) {
                Item item = panelCoverItemMap.get(panelTile.panelCover.getClass());
                ItemStack itemStack = new ItemStack((IItemProvider)item);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), itemStack);
                world.func_217376_c((Entity)itemEntity);
                itemEntity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            }
            panelTile.panelCover = null;
            panelTile.flagSync();
        }
    }

    public static void registerPanelCell(Class<? extends IPanelCell> iPanelCellClass, Item correspondingItem) {
        itemPanelCellMap.put(correspondingItem, iPanelCellClass);
        panelCellItemMap.put(iPanelCellClass, correspondingItem);
    }

    public static void registerPanelCover(Class<? extends IPanelCover> iPanelCellCover, Item correspondingItem) {
        itemPanelCoverMap.put(correspondingItem, iPanelCellCover);
        panelCoverItemMap.put(iPanelCellCover, correspondingItem);
    }

    public static Item getPanelCellItemFromClass(Class<? extends IPanelCell> iPanelCellClass) {
        return panelCellItemMap.get(iPanelCellClass);
    }

    public static Class<? extends IPanelCell> getPanelCellClassFromItem(Item item) {
        return itemPanelCellMap.get(item);
    }

    public static boolean isPanelCellItem(Item item) {
        return itemPanelCellMap.containsKey(item);
    }

    static {
        BASE.put(Direction.UP, Block.func_208617_a((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
        BASE.put(Direction.DOWN, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        BASE.put(Direction.NORTH, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
        BASE.put(Direction.EAST, Block.func_208617_a((double)16.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0));
        BASE.put(Direction.SOUTH, Block.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)14.0));
        BASE.put(Direction.WEST, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
        itemPanelCellMap = new HashMap<Item, Class<? extends IPanelCell>>();
        panelCellItemMap = new HashMap<Class<? extends IPanelCell>, Item>();
        itemPanelCoverMap = new HashMap<Item, Class<? extends IPanelCover>>();
        panelCoverItemMap = new HashMap<Class<? extends IPanelCover>, Item>();
    }
}

