/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class PanelCellNeighbor {
    private IPanelCell iPanelCell = null;
    private BlockPos blockPos = null;
    private final Side neighborDirection;
    private Side neighborsSide = null;
    private final PanelTile panelTile;
    private PanelCellPos cellPos;
    private BlockState blockState;

    PanelCellNeighbor(PanelCellPos cellPos, IPanelCell panelCell, Side neighborsSide, Side neighborDirection) {
        this.iPanelCell = panelCell;
        this.panelTile = cellPos.getPanelTile();
        this.neighborsSide = neighborsSide;
        this.cellPos = cellPos;
        this.neighborDirection = neighborDirection;
    }

    PanelCellNeighbor(PanelTile panelTile, BlockPos blockPos, Side neighborDirection) {
        this.blockPos = blockPos;
        this.panelTile = panelTile;
        this.neighborDirection = neighborDirection;
    }

    public int getWeakRsOutput() {
        if (this.iPanelCell != null) {
            return this.iPanelCell.getWeakRsOutput(this.neighborsSide);
        }
        if (this.blockPos != null) {
            return this.panelTile.func_145831_w().func_175651_c(this.blockPos, this.panelTile.getDirectionFromSide(this.neighborDirection));
        }
        return 0;
    }

    public int getStrongRsOutput() {
        if (this.iPanelCell != null) {
            return this.iPanelCell.getStrongRsOutput(this.neighborsSide);
        }
        if (this.blockPos != null) {
            return this.panelTile.func_145831_w().func_175627_a(this.blockPos, this.panelTile.getDirectionFromSide(this.neighborDirection));
        }
        return 0;
    }

    public boolean hasComparatorOverride() {
        if (this.blockPos != null) {
            return this.getNeighborBlockState().func_185912_n();
        }
        return false;
    }

    public int getComparatorOverride() {
        if (this.blockPos != null && this.hasComparatorOverride()) {
            return this.getNeighborBlockState().func_185888_a(this.panelTile.func_145831_w(), this.blockPos);
        }
        return 0;
    }

    public boolean powerDrops() {
        if (this.iPanelCell != null) {
            return this.iPanelCell.powerDrops();
        }
        if (this.blockPos != null) {
            return this.getNeighborBlockState().func_177230_c() == Blocks.field_150488_af;
        }
        return false;
    }

    public boolean isPushable() {
        return this.panelTile.canExtendTo(this.cellPos, this.neighborDirection, 0);
    }

    public boolean isOnPanel() {
        return this.cellPos != null;
    }

    public boolean canConnectRedstone() {
        BlockState blockState = this.getNeighborBlockState();
        if (blockState != null) {
            return blockState.canConnectRedstone((IBlockReader)this.panelTile.func_145831_w(), this.blockPos, this.panelTile.getDirectionFromSide(this.neighborDirection));
        }
        return this.iPanelCell != null && !(this.iPanelCell instanceof TinyBlock) && !this.iPanelCell.powerDrops();
    }

    public IPanelCell getNeighborIPanelCell() {
        return this.iPanelCell;
    }

    public BlockState getNeighborBlockState() {
        if (this.blockPos != null) {
            if (this.blockState == null) {
                this.blockState = this.panelTile.func_145831_w().func_180495_p(this.blockPos);
            }
            return this.blockState;
        }
        return null;
    }
}

