/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IObservingPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellGhostPos;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.Button;
import com.dannyandson.tinyredstone.blocks.panelcells.Piston;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.blocks.panelcells.StickyPiston;
import com.dannyandson.tinyredstone.blocks.panelcells.StoneButton;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.dannyandson.tinyredstone.setup.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class PanelTile
extends TileEntity
implements ITickableTileEntity {
    private Map<Integer, IPanelCell> cells = new HashMap<Integer, IPanelCell>();
    private Map<Integer, Side> cellDirections = new HashMap<Integer, Side>();
    protected Map<Side, Integer> strongPowerToNeighbors = new HashMap<Side, Integer>();
    protected Map<Side, Integer> weakPowerToNeighbors = new HashMap<Side, Integer>();
    protected Integer Color = DyeColor.GRAY.getColorValue();
    private Integer lightOutput = 0;
    protected boolean flagLightUpdate = false;
    private boolean flagCrashed = false;
    private boolean flagOverflow = false;
    protected IPanelCover panelCover = null;
    private boolean flagUpdate = false;
    private boolean flagSync = true;
    protected PanelCellGhostPos panelCellGhostPos;
    private VoxelShape voxelShape = null;
    private boolean fixLegacyFacing = false;

    public PanelTile() {
        super((TileEntityType)Registration.REDSTONE_PANEL_TILE.get());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        int tileEntityType = -1;
        return new SUpdateTileEntityPacket(this.field_174879_c, tileEntityType, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b.field_72995_K) {
            this.cells.clear();
            this.cellDirections.clear();
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT tag) {
        if (this.field_145850_b.field_72995_K) {
            this.cells.clear();
            this.cellDirections.clear();
        }
        this.func_230337_a_(blockState, tag);
    }

    public CompoundNBT saveToNbt(CompoundNBT compoundNBT) {
        CompoundNBT cellsNBT = new CompoundNBT();
        for (Integer key : this.cells.keySet()) {
            IPanelCell cell = this.cells.get(key);
            CompoundNBT cellNBT = new CompoundNBT();
            cellNBT.func_74778_a("class", cell.getClass().getCanonicalName());
            cellNBT.func_74778_a("facing", this.cellDirections.get(key).name());
            cellNBT.func_218657_a("data", (INBT)cell.writeNBT());
            cellsNBT.func_218657_a(key.toString(), (INBT)cellNBT);
        }
        compoundNBT.func_218657_a("cells", (INBT)cellsNBT);
        if (this.Color.intValue() != DyeColor.GRAY.getColorValue()) {
            compoundNBT.func_74768_a("color", this.Color.intValue());
        }
        if (this.panelCover != null) {
            compoundNBT.func_74778_a("cover", this.panelCover.getClass().getCanonicalName());
        }
        return compoundNBT;
    }

    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        try {
            if (this.strongPowerToNeighbors.size() == 5) {
                CompoundNBT strongPowerToNeighbors = new CompoundNBT();
                strongPowerToNeighbors.func_74768_a(Side.FRONT.ordinal() + "", this.strongPowerToNeighbors.get((Object)Side.FRONT).intValue());
                strongPowerToNeighbors.func_74768_a(Side.RIGHT.ordinal() + "", this.strongPowerToNeighbors.get((Object)Side.RIGHT).intValue());
                strongPowerToNeighbors.func_74768_a(Side.BACK.ordinal() + "", this.strongPowerToNeighbors.get((Object)Side.BACK).intValue());
                strongPowerToNeighbors.func_74768_a(Side.LEFT.ordinal() + "", this.strongPowerToNeighbors.get((Object)Side.LEFT).intValue());
                strongPowerToNeighbors.func_74768_a(Side.TOP.ordinal() + "", this.strongPowerToNeighbors.get((Object)Side.TOP).intValue());
                parentNBTTagCompound.func_218657_a("strong_power_outgoing", (INBT)strongPowerToNeighbors);
            }
            if (this.weakPowerToNeighbors.size() == 5) {
                CompoundNBT weakPowerToNeighbors = new CompoundNBT();
                weakPowerToNeighbors.func_74768_a(Side.FRONT.ordinal() + "", this.weakPowerToNeighbors.get((Object)Side.FRONT).intValue());
                weakPowerToNeighbors.func_74768_a(Side.RIGHT.ordinal() + "", this.weakPowerToNeighbors.get((Object)Side.RIGHT).intValue());
                weakPowerToNeighbors.func_74768_a(Side.BACK.ordinal() + "", this.weakPowerToNeighbors.get((Object)Side.BACK).intValue());
                weakPowerToNeighbors.func_74768_a(Side.LEFT.ordinal() + "", this.weakPowerToNeighbors.get((Object)Side.LEFT).intValue());
                weakPowerToNeighbors.func_74768_a(Side.TOP.ordinal() + "", this.weakPowerToNeighbors.get((Object)Side.TOP).intValue());
                parentNBTTagCompound.func_218657_a("weak_power_outgoing", (INBT)weakPowerToNeighbors);
            }
            parentNBTTagCompound.func_74768_a("lightOutput", this.lightOutput.intValue());
            parentNBTTagCompound.func_74757_a("flagLightUpdate", this.flagLightUpdate);
            parentNBTTagCompound.func_74757_a("flagCrashed", this.flagCrashed);
            parentNBTTagCompound.func_74757_a("flagOverflow", this.flagOverflow);
        }
        catch (NullPointerException exception) {
            TinyRedstone.LOGGER.error("Exception thrown when attempting to save power inputs and outputs: " + exception.toString() + (exception.getStackTrace().length > 0 ? exception.getStackTrace()[0].toString() : ""));
        }
        return super.func_189515_b(this.saveToNbt(parentNBTTagCompound));
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        String coverClass;
        CompoundNBT weakPowerToNeighbors;
        int previousLightOutput = this.lightOutput;
        super.func_230337_a_(blockState, parentNBTTagCompound);
        this.loadCellsFromNBT(parentNBTTagCompound, true);
        CompoundNBT strongPowerToNeighbors = parentNBTTagCompound.func_74775_l("strong_power_outgoing");
        if (!strongPowerToNeighbors.isEmpty()) {
            this.strongPowerToNeighbors.put(Side.FRONT, strongPowerToNeighbors.func_74762_e(Side.FRONT.ordinal() + ""));
            this.strongPowerToNeighbors.put(Side.RIGHT, strongPowerToNeighbors.func_74762_e(Side.RIGHT.ordinal() + ""));
            this.strongPowerToNeighbors.put(Side.BACK, strongPowerToNeighbors.func_74762_e(Side.BACK.ordinal() + ""));
            this.strongPowerToNeighbors.put(Side.LEFT, strongPowerToNeighbors.func_74762_e(Side.LEFT.ordinal() + ""));
            this.strongPowerToNeighbors.put(Side.TOP, strongPowerToNeighbors.func_74762_e(Side.TOP.ordinal() + ""));
        }
        if (!(weakPowerToNeighbors = parentNBTTagCompound.func_74775_l("weak_power_outgoing")).isEmpty()) {
            this.weakPowerToNeighbors.put(Side.FRONT, weakPowerToNeighbors.func_74762_e(Side.FRONT.ordinal() + ""));
            this.weakPowerToNeighbors.put(Side.RIGHT, weakPowerToNeighbors.func_74762_e(Side.RIGHT.ordinal() + ""));
            this.weakPowerToNeighbors.put(Side.BACK, weakPowerToNeighbors.func_74762_e(Side.BACK.ordinal() + ""));
            this.weakPowerToNeighbors.put(Side.LEFT, weakPowerToNeighbors.func_74762_e(Side.LEFT.ordinal() + ""));
            this.weakPowerToNeighbors.put(Side.TOP, weakPowerToNeighbors.func_74762_e(Side.TOP.ordinal() + ""));
        }
        this.lightOutput = parentNBTTagCompound.func_74762_e("lightOutput");
        this.flagLightUpdate = parentNBTTagCompound.func_74767_n("flagLightUpdate");
        this.flagCrashed = parentNBTTagCompound.func_74767_n("flagCrashed");
        this.flagOverflow = parentNBTTagCompound.func_74767_n("flagOverflow");
        if (parentNBTTagCompound.func_74764_b("color")) {
            int color = parentNBTTagCompound.func_74762_e("color");
            if (this.Color != color) {
                this.Color = color;
                this.flagUpdate = true;
            }
        }
        if ((coverClass = parentNBTTagCompound.func_74779_i("cover")).length() > 0) {
            try {
                this.panelCover = (IPanelCover)Class.forName(coverClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCover class " + coverClass + ": " + exception.getMessage() + " " + (exception.getStackTrace().length > 0 ? exception.getStackTrace()[0].toString() : ""));
            }
        } else {
            this.panelCover = null;
        }
        if (this.lightOutput != previousLightOutput) {
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
    }

    public void loadCellsFromNBT(CompoundNBT parentNBTTagCompound, boolean fixFacing) {
        CompoundNBT cellsNBT = parentNBTTagCompound.func_74775_l("cells");
        for (String index : cellsNBT.func_150296_c()) {
            CompoundNBT cellNBT = cellsNBT.func_74775_l(index);
            if (!cellNBT.func_74764_b("data")) continue;
            if (this.cells.size() == 0) {
                this.flagUpdate = true;
            }
            String className = cellNBT.func_74779_i("class");
            try {
                IPanelCell cell = (IPanelCell)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                cell.readNBT(cellNBT.func_74775_l("data"));
                Integer i = Integer.parseInt(index);
                this.cells.put(i, cell);
                if (cellNBT.func_74764_b("direction")) {
                    Direction direction = Direction.func_82600_a((int)cellNBT.func_74762_e("direction"));
                    if (direction == Direction.NORTH) {
                        this.cellDirections.put(i, Side.FRONT);
                    } else if (direction == Direction.EAST) {
                        this.cellDirections.put(i, Side.RIGHT);
                    } else if (direction == Direction.SOUTH) {
                        this.cellDirections.put(i, Side.BACK);
                    } else if (direction == Direction.WEST) {
                        this.cellDirections.put(i, Side.LEFT);
                    }
                    if (!fixFacing) continue;
                    this.fixLegacyFacing = true;
                    continue;
                }
                this.cellDirections.put(i, Side.valueOf(cellNBT.func_74779_i("facing")));
            }
            catch (Exception exception) {
                TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCell class " + className + ": " + exception.getMessage() + " " + (exception.getStackTrace().length > 0 ? exception.getStackTrace()[0].toString() : ""));
            }
        }
        this.clearVoxelShape();
    }

    public double func_145833_n() {
        int MAXIMUM_DISTANCE_IN_BLOCKS = 16;
        return 256.0;
    }

    public void func_73660_a() {
        try {
            if (!this.flagCrashed) {
                boolean dirty = false;
                if (this.fixLegacyFacing) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((PanelBlock)Registration.REDSTONE_PANEL_BLOCK.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN));
                    this.fixLegacyFacing = false;
                    dirty = true;
                }
                ArrayList<Integer> pistons = null;
                for (Integer index : this.cells.keySet()) {
                    PanelCellPos cellPos = PanelCellPos.fromIndex(this, index);
                    IPanelCell panelCell = this.cells.get(index);
                    boolean update = panelCell.tick(cellPos);
                    if (!update) continue;
                    if (panelCell instanceof Piston) {
                        if (pistons == null) {
                            pistons = new ArrayList<Integer>();
                        }
                        pistons.add(index);
                    } else {
                        if (panelCell instanceof Button) {
                            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), panelCell instanceof StoneButton ? SoundEvents.field_187837_fU : SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.25f, 2.0f, false);
                        }
                        this.updateNeighborCells(cellPos);
                    }
                    dirty = true;
                }
                if (pistons != null) {
                    for (Integer index : pistons) {
                        this.updatePiston(index);
                    }
                }
                if (this.flagLightUpdate) {
                    this.flagLightUpdate = false;
                    this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
                }
                if (this.flagUpdate) {
                    this.updateSide(Side.FRONT);
                    this.updateSide(Side.RIGHT);
                    this.updateSide(Side.BACK);
                    this.updateSide(Side.LEFT);
                }
                if (dirty || this.flagUpdate) {
                    this.func_70296_d();
                    this.updateOutputs();
                }
                if (this.flagSync || dirty || this.flagUpdate) {
                    this.sync();
                    this.flagSync = false;
                    this.flagUpdate = false;
                }
                if (this.field_145850_b.field_72995_K) {
                    PanelCellGhostPos gPos = PanelTileRenderer.getPlayerLookingAtCell(this);
                    if (gPos != null) {
                        gPos.getPanelTile().panelCellGhostPos = gPos;
                    } else {
                        this.panelCellGhostPos = null;
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleCrash(e);
        }
    }

    private void updatePiston(int index) {
        IPanelCell panelCell = this.cells.get(index);
        if (panelCell instanceof Piston) {
            PanelCellPos abovePiston;
            PanelTile panelTile = this;
            PanelCellPos pistonPos = PanelCellPos.fromIndex(this, index);
            Side movingToward = pistonPos.getCellFacing().getOpposite();
            PanelCellPos moverPos = pistonPos.offset(movingToward);
            if (!((Piston)panelCell).isExtended() && panelCell instanceof StickyPiston && moverPos != null && moverPos.getIPanelCell() == null) {
                moverPos = moverPos.offset(movingToward);
                movingToward = movingToward.getOpposite();
            }
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ((Piston)panelCell).isExtended() ? SoundEvents.field_187715_dR : SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.25f, 2.0f, false);
            if (moverPos != null) {
                PanelTile moverPanelTile = moverPos.getPanelTile();
                if (moverPanelTile.cells.containsKey(moverPos.getIndex())) {
                    panelTile.moveCell(moverPos, movingToward, 0);
                } else {
                    panelTile.updateNeighborCells(moverPos);
                }
            }
            if ((abovePiston = pistonPos.offset(Side.TOP)) != null && abovePiston.getIPanelCell() != null) {
                panelTile.updateCell(abovePiston);
            }
        }
    }

    private boolean moveCell(PanelCellPos cellPos, Side towardSide, Integer iteration) {
        if (iteration > 12) {
            return false;
        }
        IPanelCell cell = cellPos.getIPanelCell();
        if (cell == null) {
            return true;
        }
        if (!cell.isPushable()) {
            return false;
        }
        PanelCellPos newPos = cellPos.offset(towardSide);
        if (newPos == null || newPos.getIPanelCell() != null && !newPos.getPanelTile().moveCell(newPos, towardSide, iteration + 1)) {
            return false;
        }
        int oldIndex = cellPos.getIndex();
        int newIndex = newPos.getIndex();
        newPos.getPanelTile().cells.put(newIndex, cell);
        newPos.getPanelTile().cellDirections.put(newIndex, cellPos.getCellFacing());
        cellPos.getPanelTile().cells.remove(oldIndex);
        cellPos.getPanelTile().cellDirections.remove(oldIndex);
        newPos.getPanelTile().updateNeighborCells(newPos);
        cellPos.getPanelTile().updateNeighborCells(cellPos);
        newPos.getPanelTile().func_70296_d();
        newPos.getPanelTile().flagSync = true;
        newPos.getPanelTile().clearVoxelShape();
        cellPos.getPanelTile().func_70296_d();
        cellPos.getPanelTile().flagSync = true;
        cellPos.getPanelTile().clearVoxelShape();
        if (cell instanceof IObservingPanelCell) {
            ((IObservingPanelCell)((Object)cell)).frontNeighborUpdated();
        }
        return true;
    }

    public boolean canExtendTo(PanelCellPos cellPos, Side side, Integer iteration) {
        if (iteration > 12) {
            return false;
        }
        IPanelCell iPanelCell = cellPos.getIPanelCell();
        if (this.checkCellForPistonExtension(cellPos)) {
            return false;
        }
        if (iPanelCell == null) {
            return true;
        }
        if (!iPanelCell.isPushable()) {
            return false;
        }
        PanelCellPos adjacentPos = cellPos.offset(side);
        if (adjacentPos == null) {
            return false;
        }
        return adjacentPos.getPanelTile().canExtendTo(adjacentPos, side, iteration + 1);
    }

    public void func_189667_a(Rotation rotationIn) {
        HashMap<Integer, IPanelCell> cells = new HashMap<Integer, IPanelCell>();
        HashMap<Integer, Side> cellDirections = new HashMap<Integer, Side>();
        for (Integer i : this.cells.keySet()) {
            Side side2;
            PanelCellPos cellPos2;
            PanelCellPos cellPos1 = PanelCellPos.fromIndex(this, i);
            Side side1 = this.cellDirections.get(i);
            if (rotationIn == Rotation.COUNTERCLOCKWISE_90) {
                cellPos2 = PanelCellPos.fromRowColumn(this, cellPos1.getColumn(), (cellPos1.getRow() - 4) * -1 + 3, cellPos1.getLevel());
                side2 = side1.rotateYCCW();
            } else if (rotationIn == Rotation.CLOCKWISE_180) {
                cellPos2 = PanelCellPos.fromRowColumn(this, (cellPos1.getRow() - 4) * -1 + 3, (cellPos1.getColumn() - 4) * -1 + 3, cellPos1.getLevel());
                side2 = side1.getOpposite();
            } else {
                cellPos2 = PanelCellPos.fromRowColumn(this, (cellPos1.getColumn() - 4) * -1 + 3, cellPos1.getRow(), cellPos1.getLevel());
                side2 = side1.rotateYCW();
            }
            cells.put(cellPos2.getIndex(), this.cells.get(i));
            cellDirections.put(cellPos2.getIndex(), side2);
        }
        this.cells = cells;
        this.cellDirections = cellDirections;
        this.updateSide(Side.FRONT);
        this.updateSide(Side.RIGHT);
        this.updateSide(Side.BACK);
        this.updateSide(Side.LEFT);
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
        this.updateOutputs();
        this.clearVoxelShape();
        this.flagSync();
    }

    public boolean pingOutwardObservers(Direction facing) {
        boolean updated = false;
        Side side = this.getSideFromDirection(facing);
        List<Integer> cellIndices = this.getEdgeCellIndices(side);
        for (Integer i : cellIndices) {
            if (!this.cells.containsKey(i) || !(this.cells.get(i) instanceof IObservingPanelCell) || this.cellDirections.get(i) != side || !((IObservingPanelCell)((Object)this.cells.get(i))).frontNeighborUpdated()) continue;
            updated = true;
        }
        return updated;
    }

    public boolean updateSide(Direction facing) {
        return this.updateSide(this.getSideFromDirection(facing));
    }

    public boolean updateSide(Side side) {
        boolean updated = false;
        List<Integer> cellIndices = this.getEdgeCellIndices(side);
        for (Integer i : cellIndices) {
            if (!this.cells.containsKey(i) || !this.updateCell(i)) continue;
            updated = true;
        }
        return updated;
    }

    public boolean updateNeighborCells(PanelCellPos cellPos) {
        return this.updateNeighborCells(cellPos, 1);
    }

    private boolean updateNeighborCells(PanelCellPos cellPos, Integer iteration) {
        ArrayList<PanelCellPos> cellPosList = new ArrayList<PanelCellPos>();
        boolean updateOutputs = false;
        if (this.updateNeighbor(cellPos, Side.FRONT, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.RIGHT, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.BACK, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.LEFT, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.TOP, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.BOTTOM, cellPosList)) {
            updateOutputs = true;
        }
        if (updateOutputs) {
            this.updateOutputs();
        }
        boolean updated = false;
        for (PanelCellPos updatePos : cellPosList) {
            if (!this.updateCell(updatePos, iteration + 1)) continue;
            updated = true;
        }
        return updated || updateOutputs;
    }

    private boolean updateNeighbor(PanelCellPos cellPos, Side side, List<PanelCellPos> cellPosList) {
        PanelCellPos neighborPos = cellPos.offset(side);
        if (neighborPos == null) {
            return true;
        }
        IPanelCell adjacentCell = neighborPos.getIPanelCell();
        if (adjacentCell instanceof IObservingPanelCell) {
            Side direction2;
            Side direction1 = neighborPos.getCellFacing();
            if (direction1 == (direction2 = side.getOpposite())) {
                ((IObservingPanelCell)((Object)adjacentCell)).frontNeighborUpdated();
            }
        } else if (adjacentCell != null && (!adjacentCell.isIndependentState() || side == Side.TOP && adjacentCell.needsSolidBase())) {
            cellPosList.add(neighborPos);
        }
        return false;
    }

    public boolean checkCellForPistonExtension(PanelCellPos cellPos) {
        for (Side panelSide : new Side[]{Side.FRONT, Side.RIGHT, Side.BACK, Side.LEFT, Side.TOP, Side.BOTTOM}) {
            IPanelCell cell;
            PanelCellPos neighborPos = cellPos.offset(panelSide);
            if (neighborPos == null || !((cell = neighborPos.getIPanelCell()) instanceof Piston) || neighborPos.getCellFacing() != panelSide || !((Piston)cell).isExtended()) continue;
            return true;
        }
        return false;
    }

    protected boolean updateCell(Integer cellIndex) {
        PanelCellPos cellPos = PanelCellPos.fromIndex(this, cellIndex);
        return this.updateCell(cellPos, 1);
    }

    protected boolean updateCell(PanelCellPos cellPos) {
        return this.updateCell(cellPos, 1);
    }

    private boolean updateCell(PanelCellPos cellPos, int iteration) {
        boolean change = false;
        if (iteration > 16 * (Integer)Config.CIRCUIT_MAX_ITERATION.get()) {
            if (!this.flagOverflow) {
                TinyRedstone.LOGGER.warn("Redstone panel at " + this.field_174879_c.func_177958_n() + "," + this.field_174879_c.func_177956_o() + "," + this.field_174879_c.func_177952_p() + " iterated too many times.");
            }
            this.flagOverflow = true;
            return false;
        }
        if (cellPos.getPanelTile() != this) {
            return cellPos.getPanelTile().updateCell(cellPos, iteration);
        }
        IPanelCell thisCell = cellPos.getIPanelCell();
        if (thisCell != null) {
            PanelCellPos basePos;
            if (!(!thisCell.needsSolidBase() || (basePos = cellPos.offset(Side.BOTTOM)) == null || basePos.getIPanelCell() != null && (basePos.getIPanelCell().isPushable() || basePos.getIPanelCell() instanceof Piston && basePos.getCellFacing() == Side.TOP))) {
                ((PanelBlock)Registration.REDSTONE_PANEL_BLOCK.get()).removeCell(cellPos, null);
                change = true;
            }
            if (!change && !thisCell.isIndependentState() && thisCell.neighborChanged(cellPos)) {
                this.updateNeighborCells(cellPos, iteration + 1);
                if (thisCell instanceof RedstoneDust) {
                    PanelCellPos above = cellPos.offset(Side.TOP);
                    PanelCellPos below = cellPos.offset(Side.BOTTOM);
                    if (above != null) {
                        this.updateNeighborCells(above, iteration + 1);
                    }
                    if (below != null) {
                        this.updateNeighborCells(below, iteration + 1);
                    }
                }
                change = true;
            }
        }
        if (change) {
            this.func_70296_d();
            this.flagSync();
        }
        return change;
    }

    private Side getPanelCellSide(PanelCellPos cellPos, Direction facing) {
        return this.getPanelCellSide(cellPos, this.getSideFromDirection(facing));
    }

    public Side getPanelCellSide(PanelCellPos cellPos, Side panelSide) {
        Side cellDirection = cellPos.getPanelTile().getCellFacing(cellPos);
        if (cellDirection == null) {
            return null;
        }
        if (cellDirection == panelSide) {
            return Side.FRONT;
        }
        if ((panelSide == Side.TOP || panelSide == Side.BOTTOM) && cellDirection != Side.TOP && cellDirection != Side.BOTTOM) {
            return panelSide;
        }
        if (cellDirection == panelSide.getOpposite()) {
            return Side.BACK;
        }
        if (cellDirection == panelSide.rotateYCW()) {
            return Side.LEFT;
        }
        if (cellDirection == panelSide.rotateYCCW()) {
            return Side.RIGHT;
        }
        if (cellDirection == panelSide.rotateForward()) {
            return Side.TOP;
        }
        if (cellDirection == panelSide.rotateBack()) {
            return Side.BOTTOM;
        }
        return null;
    }

    public boolean updateOutputs() {
        boolean change = false;
        ArrayList<Direction> directionsUpdated = new ArrayList<Direction>();
        for (Side panelSide : new Side[]{Side.FRONT, Side.RIGHT, Side.BACK, Side.LEFT, Side.TOP}) {
            Direction direction = this.getDirectionFromSide(panelSide);
            int weak = 0;
            int strong = 0;
            List<Integer> indices = this.getEdgeCellIndices(direction);
            for (int i : indices) {
                PanelCellPos cellPos = PanelCellPos.fromIndex(this, i);
                IPanelCell cell = cellPos.getIPanelCell();
                Side side = this.getPanelCellSide(cellPos, direction);
                int cellStrongOutput = cell.getStrongRsOutput(side);
                int cellWeakOutput = cell.getWeakRsOutput(side);
                if (cell.powerDrops() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c() == Blocks.field_150488_af) {
                    --cellStrongOutput;
                    --cellWeakOutput;
                }
                if (cell instanceof TinyBlock && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c() == Blocks.field_150488_af) {
                    cellWeakOutput = cellStrongOutput;
                }
                if (cellStrongOutput > strong) {
                    strong = cellStrongOutput;
                }
                if (cellWeakOutput <= weak) continue;
                weak = cellWeakOutput;
            }
            if (this.strongPowerToNeighbors.get((Object)panelSide) != null && strong == this.strongPowerToNeighbors.get((Object)panelSide) && this.weakPowerToNeighbors.get((Object)panelSide) != null && weak == this.weakPowerToNeighbors.get((Object)panelSide)) continue;
            change = true;
            this.strongPowerToNeighbors.put(panelSide, strong);
            this.weakPowerToNeighbors.put(panelSide, weak);
            directionsUpdated.add(direction);
        }
        int ll = 0;
        for (Integer index : this.cells.keySet()) {
            ll += this.cells.get(index).lightOutput();
        }
        if (ll != this.lightOutput) {
            this.lightOutput = ll;
            this.flagLightUpdate = true;
        }
        if (change) {
            this.flagSync();
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            for (Direction direction : directionsUpdated) {
                BlockPos neighborPos = this.field_174879_c.func_177972_a(direction);
                BlockState neighborBlockState = this.field_145850_b.func_180495_p(neighborPos);
                if (neighborBlockState == null || !neighborBlockState.func_200132_m()) continue;
                this.field_145850_b.func_175695_a(neighborPos, neighborBlockState.func_177230_c(), direction.func_176734_d());
            }
        }
        return change;
    }

    private List<Integer> getEdgeCellIndices(Direction edge) {
        return this.getEdgeCellIndices(this.getSideFromDirection(edge));
    }

    private List<Integer> getEdgeCellIndices(Side side) {
        ArrayList<Integer> cellIndices;
        block15: {
            int i;
            block14: {
                cellIndices = new ArrayList<Integer>();
                int i1 = 0;
                while ((double)i1 < 447.0) {
                    int i2;
                    if (side == Side.LEFT) {
                        for (i2 = i1; i2 < i1 + 8; ++i2) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                    } else if (side == Side.FRONT) {
                        for (i2 = i1; i2 < i1 + 64; i2 += 8) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                    } else if (side == Side.RIGHT) {
                        for (i2 = i1 + 56; i2 < i1 + 64; ++i2) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                    } else if (side == Side.BACK) {
                        for (i2 = i1 + 7; i2 < i1 + 64; i2 += 8) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                    }
                    i1 += 64;
                }
                if (side != Side.TOP) break block14;
                for (i = 384; i < 448; ++i) {
                    if (!this.cells.containsKey(i)) continue;
                    cellIndices.add(i);
                }
                break block15;
            }
            if (side != Side.BOTTOM) break block15;
            for (i = 0; i < 64; ++i) {
                if (!this.cells.containsKey(i)) continue;
                cellIndices.add(i);
            }
        }
        return cellIndices;
    }

    public int getColor() {
        if (this.Color == null) {
            return DyeColor.GRAY.getColorValue();
        }
        return this.Color;
    }

    public int getLightOutput() {
        if (this.panelCover == null || this.panelCover.allowsLightOutput()) {
            return this.lightOutput;
        }
        return 0;
    }

    public void sync() {
        if (!(this.field_145850_b.field_72995_K || this.isCovered() && !this.panelCover.allowsLightOutput())) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    protected void handleCrash(Exception e) {
        this.flagCrashed = true;
        TinyRedstone.LOGGER.error("Redstone Panel Crashed at " + this.field_174879_c.func_177958_n() + "," + this.field_174879_c.func_177956_o() + "," + this.field_174879_c.func_177952_p(), (Throwable)e);
    }

    public boolean isCrashed() {
        return this.flagCrashed;
    }

    public void resetCrashFlag() {
        this.flagCrashed = false;
    }

    public boolean isOverflown() {
        return this.flagOverflow;
    }

    public void resetOverflownFlag() {
        this.flagOverflow = false;
    }

    public boolean isCovered() {
        return this.panelCover != null;
    }

    protected Direction getDirectionFromSide(Side side) {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        switch (side) {
            case FRONT: {
                switch (facing) {
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Direction.NORTH;
                    }
                    case UP: {
                        return Direction.SOUTH;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.UP;
                    }
                    case WEST: {
                        return Direction.DOWN;
                    }
                }
                break;
            }
            case BACK: {
                switch (facing) {
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Direction.SOUTH;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case SOUTH: {
                        return Direction.UP;
                    }
                    case NORTH: {
                        return Direction.DOWN;
                    }
                }
                break;
            }
            case LEFT: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.UP;
                    }
                }
            }
            case TOP: {
                return facing.func_176734_d();
            }
            case BOTTOM: {
                return facing;
            }
        }
        return null;
    }

    public Side getSideFromDirection(Direction direction) {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        switch (direction) {
            case NORTH: {
                switch (facing) {
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Side.FRONT;
                    }
                    case UP: {
                        return Side.BACK;
                    }
                    case NORTH: {
                        return Side.BOTTOM;
                    }
                    case SOUTH: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case EAST: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Side.RIGHT;
                    }
                    case EAST: {
                        return Side.BOTTOM;
                    }
                    case WEST: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (facing) {
                    case UP: {
                        return Side.FRONT;
                    }
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Side.BACK;
                    }
                    case SOUTH: {
                        return Side.BOTTOM;
                    }
                    case NORTH: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case WEST: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Side.LEFT;
                    }
                    case WEST: {
                        return Side.BOTTOM;
                    }
                    case EAST: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case UP: {
                switch (facing) {
                    case NORTH: {
                        return Side.FRONT;
                    }
                    case EAST: {
                        return Side.RIGHT;
                    }
                    case SOUTH: {
                        return Side.BACK;
                    }
                    case WEST: {
                        return Side.LEFT;
                    }
                    case UP: {
                        return Side.BOTTOM;
                    }
                    case DOWN: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case DOWN: {
                switch (facing) {
                    case SOUTH: {
                        return Side.FRONT;
                    }
                    case WEST: {
                        return Side.RIGHT;
                    }
                    case NORTH: {
                        return Side.BACK;
                    }
                    case EAST: {
                        return Side.LEFT;
                    }
                    case DOWN: {
                        return Side.BOTTOM;
                    }
                    case UP: {
                        return Side.TOP;
                    }
                }
            }
        }
        return null;
    }

    protected Direction getPlayerDirectionFacing(PlayerEntity player, boolean allowVertical) {
        Direction[] playerFacings;
        Direction panelFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        for (Direction facing : playerFacings = Direction.func_196054_a((Entity)player)) {
            if (!allowVertical && (facing == panelFacing || facing == panelFacing.func_176734_d())) continue;
            return facing;
        }
        return player.func_174811_aO();
    }

    @CheckForNull
    public IPanelCell getIPanelCell(PanelCellPos cellPos) {
        if (cellPos == null) {
            return null;
        }
        return this.cells.get(cellPos.getIndex());
    }

    @CheckForNull
    public Side getCellFacing(PanelCellPos cellPos) {
        if (cellPos == null) {
            return null;
        }
        return this.cellDirections.get(cellPos.getIndex());
    }

    public List<PanelCellPos> getCellPositions() {
        ArrayList<PanelCellPos> poss = new ArrayList<PanelCellPos>();
        for (Integer index : this.cells.keySet()) {
            poss.add(PanelCellPos.fromIndex(this, index));
        }
        return poss;
    }

    public int getCellCount() {
        return this.cells.size();
    }

    public void removeCell(PanelCellPos cellPos) {
        if (cellPos.getIPanelCell() != null) {
            int cellIndex = cellPos.getIndex();
            boolean isRedstoneDust = cellPos.getIPanelCell() instanceof RedstoneDust;
            this.cellDirections.remove(cellIndex);
            this.cells.remove(cellIndex);
            BlockPos pos = cellPos.getPanelTile().func_174877_v();
            cellPos.getPanelTile().func_145831_w().func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 0.15f, 2.0f, false);
            this.updateNeighborCells(cellPos);
            if (isRedstoneDust) {
                PanelCellPos above = cellPos.offset(Side.TOP);
                PanelCellPos below = cellPos.offset(Side.BOTTOM);
                if (above != null) {
                    this.updateNeighborCells(above);
                }
                if (below != null) {
                    this.updateNeighborCells(below);
                }
            }
            this.clearVoxelShape();
            this.flagSync();
        }
    }

    public void removeAllCells(@Nullable PlayerEntity player) {
        Object[] indices;
        for (Object index : indices = this.cells.keySet().toArray()) {
            ((PanelBlock)this.func_195044_w().func_177230_c()).removeCell(PanelCellPos.fromIndex(this, (Integer)index), player);
        }
    }

    public void addCell(PanelCellPos cellPos, IPanelCell panelCell, Side facing, PlayerEntity player) {
        int cellIndex = cellPos.getIndex();
        this.cellDirections.put(cellIndex, facing);
        this.cells.put(cellIndex, panelCell);
        BlockPos pos = cellPos.getPanelTile().func_174877_v();
        cellPos.getPanelTile().func_145831_w().func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.15f, 2.0f, false);
        panelCell.onPlace(cellPos, player);
        this.updateNeighborCells(cellPos);
        this.clearVoxelShape();
    }

    public boolean hasCellsOnFace(Direction direction) {
        return !this.getEdgeCellIndices(direction).isEmpty();
    }

    public void flagSync() {
        this.flagSync = true;
    }

    public VoxelShape getVoxelShape() {
        if (this.isCovered()) {
            return VoxelShapes.func_197868_b();
        }
        if (this.voxelShape == null) {
            switch ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)) {
                case UP: {
                    this.voxelShape = Block.func_208617_a((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
                    break;
                }
                case NORTH: {
                    this.voxelShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
                    break;
                }
                case EAST: {
                    this.voxelShape = Block.func_208617_a((double)16.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
                    break;
                }
                case SOUTH: {
                    this.voxelShape = Block.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)14.0);
                    break;
                }
                case WEST: {
                    this.voxelShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
                    break;
                }
                default: {
                    this.voxelShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
                }
            }
            if (!this.isCovered()) {
                block14: for (Integer index : this.cells.keySet()) {
                    PanelCellPos cellPos = PanelCellPos.fromIndex(this, index);
                    IPanelCell cell = cellPos.getIPanelCell();
                    if (cell == null) continue;
                    PanelCellVoxelShape cellShape = cell.getShape();
                    float rowStart = (float)cellPos.getRow() * 2.0f + (float)cellShape.getPoint1().field_72450_a * 2.0f;
                    float rowEnd = (float)cellPos.getRow() * 2.0f + (float)cellShape.getPoint2().field_72450_a * 2.0f;
                    float columnStart = (float)cellPos.getColumn() * 2.0f + (float)cellShape.getPoint1().field_72449_c * 2.0f;
                    float columnEnd = (float)cellPos.getColumn() * 2.0f + (float)cellShape.getPoint2().field_72449_c * 2.0f;
                    float levelStart = 2.0f + (float)cellPos.getLevel() * 2.0f + (float)cellShape.getPoint1().field_72448_b * 2.0f;
                    float levelEnd = 2.0f + (float)cellPos.getLevel() * 2.0f + (float)cellShape.getPoint2().field_72448_b * 2.0f;
                    switch ((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)) {
                        case UP: {
                            this.voxelShape = VoxelShapes.func_197872_a((VoxelShape)this.voxelShape, (VoxelShape)Block.func_208617_a((double)rowStart, (double)(16.0f - levelStart), (double)(16.0f - columnStart), (double)rowEnd, (double)(16.0f - levelEnd), (double)(16.0f - columnEnd)));
                            continue block14;
                        }
                        case NORTH: {
                            this.voxelShape = VoxelShapes.func_197872_a((VoxelShape)this.voxelShape, (VoxelShape)Block.func_208617_a((double)rowStart, (double)(16.0f - columnStart), (double)levelStart, (double)rowEnd, (double)(16.0f - columnEnd), (double)levelEnd));
                            continue block14;
                        }
                        case EAST: {
                            this.voxelShape = VoxelShapes.func_197872_a((VoxelShape)this.voxelShape, (VoxelShape)Block.func_208617_a((double)(16.0f - levelStart), (double)rowStart, (double)columnStart, (double)(16.0f - levelEnd), (double)rowEnd, (double)columnEnd));
                            continue block14;
                        }
                        case SOUTH: {
                            this.voxelShape = VoxelShapes.func_197872_a((VoxelShape)this.voxelShape, (VoxelShape)Block.func_208617_a((double)rowStart, (double)columnStart, (double)(16.0f - levelStart), (double)rowEnd, (double)columnEnd, (double)(16.0f - levelEnd)));
                            continue block14;
                        }
                        case WEST: {
                            this.voxelShape = VoxelShapes.func_197872_a((VoxelShape)this.voxelShape, (VoxelShape)Block.func_208617_a((double)levelStart, (double)(16.0f - rowStart), (double)columnStart, (double)levelEnd, (double)(16.0f - rowEnd), (double)columnEnd));
                            continue block14;
                        }
                    }
                    this.voxelShape = VoxelShapes.func_197872_a((VoxelShape)this.voxelShape, (VoxelShape)Block.func_208617_a((double)rowStart, (double)levelStart, (double)columnStart, (double)rowEnd, (double)levelEnd, (double)columnEnd));
                }
            }
        }
        return this.voxelShape;
    }

    public void clearVoxelShape() {
        this.voxelShape = null;
    }
}

