/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellGhostPos;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.items.RedstoneWrench;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class PanelTileRenderer
extends TileEntityRenderer<PanelTile> {
    public static ResourceLocation TEXTURE = new ResourceLocation("tinyredstone", "block/redstone_panel");
    public static ResourceLocation TEXTURE_CRASHED = new ResourceLocation("tinyredstone", "block/redstone_panel_crashed");
    private float scale = 0.125f;
    private float t2X = 0.0f;
    private float t2Y = -1.0f;
    private float t2Z = 0.0f;
    private float rotation1 = 270.0f;
    private double cellSize = 0.125;

    public PanelTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(PanelTile tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        switch ((Direction)tileEntity.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case UP: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.0, -1.0, -1.0);
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
            }
        }
        if (tileEntity.isCovered()) {
            matrixStack.func_227860_a_();
            tileEntity.panelCover.render(matrixStack, buffer, combinedLight, combinedOverlay, tileEntity.getColor());
            matrixStack.func_227865_b_();
        } else {
            List<PanelCellPos> positions = tileEntity.getCellPositions();
            for (PanelCellPos pos : positions) {
                IPanelCell panelCell = pos.getIPanelCell();
                if (panelCell == null) continue;
                this.renderCell(matrixStack, pos, buffer, tileEntity.isCrashed() ? 0 : combinedLight, combinedOverlay, tileEntity.isCrashed() ? 0.5f : 1.0f);
            }
            if (tileEntity.panelCellGhostPos != null) {
                this.renderCell(matrixStack, tileEntity.panelCellGhostPos, buffer, combinedLight, combinedOverlay, 0.5f);
            }
        }
        if (tileEntity.isCrashed() || tileEntity.isOverflown()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.126, 1.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.rotation1));
            TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE_CRASHED);
            RenderHelper.drawRectangle(buffer.getBuffer(Minecraft.func_238218_y_() ? RenderType.func_228639_c_() : RenderType.func_228645_f_()), matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, 0.9f);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private void renderCell(MatrixStack matrixStack, PanelCellPos pos, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        alpha = Minecraft.func_238218_y_() ? 1.0f : alpha;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(this.cellSize * (double)pos.getRow(), 0.125 + (double)pos.getLevel() * 0.125, this.cellSize * (double)pos.getColumn());
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.rotation1));
        Side facing = pos.getCellFacing();
        if (facing == Side.LEFT) {
            matrixStack.func_227861_a_(0.0, -this.cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        } else if (facing == Side.BACK) {
            matrixStack.func_227861_a_(this.cellSize, -this.cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        } else if (facing == Side.RIGHT) {
            matrixStack.func_227861_a_(this.cellSize, 0.0, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
        } else if (pos.getCellFacing() == Side.BOTTOM) {
            matrixStack.func_227861_a_(0.0, -this.cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        } else if (pos.getCellFacing() == Side.TOP) {
            matrixStack.func_227861_a_(0.0, 0.0, this.cellSize);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        }
        matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
        matrixStack.func_227861_a_((double)this.t2X, (double)this.t2Y, (double)this.t2Z);
        pos.getIPanelCell().render(matrixStack, buffer, combinedLight, combinedOverlay, alpha);
        matrixStack.func_227865_b_();
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registration.REDSTONE_PANEL_TILE.get()), PanelTileRenderer::new);
    }

    @CheckForNull
    public static PanelCellGhostPos getPlayerLookingAtCell(PanelTile panelTile) {
        Vector3d lookVector;
        BlockPos blockPos;
        TileEntity te;
        RayTraceResult lookingAt;
        World world = panelTile.func_145831_w();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && PanelBlock.isPanelCellItem(player.func_184614_ca().func_77973_b()) && (lookingAt = Minecraft.func_71410_x().field_71476_x) != null && lookingAt.func_216346_c() == RayTraceResult.Type.BLOCK && (te = world.func_175625_s(blockPos = new BlockPos(lookVector = Minecraft.func_71410_x().field_71476_x.func_216347_e()))) == panelTile) {
            BlockRayTraceResult result = ((RedstoneWrench)Registration.REDSTONE_WRENCH.get()).getBlockRayTraceResult(world, (PlayerEntity)player);
            PanelCellPos cellPos = PosInPanelCell.fromHitVec(panelTile, panelTile.func_174877_v(), result);
            if (cellPos != null) {
                if (cellPos.getIPanelCell() != null && (!cellPos.getIPanelCell().hasActivation() || player.func_213453_ef())) {
                    cellPos = cellPos.offset(panelTile.getSideFromDirection(result.func_216354_b()));
                }
                if (cellPos != null && cellPos.getIPanelCell() == null) {
                    try {
                        PanelCellPos basePos;
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(player.func_184614_ca().func_77973_b()).getConstructors()[0].newInstance(new Object[0]);
                        if (panelCell.needsSolidBase() && (basePos = cellPos.offset(Side.BOTTOM)) != null && (basePos.getIPanelCell() == null || !basePos.getIPanelCell().isPushable())) {
                            return null;
                        }
                        Side rotationLock = RotationLock.getRotationLock();
                        panelCell.onPlace(cellPos, (PlayerEntity)player);
                        return PanelCellGhostPos.fromPosInPanelCell(cellPos, panelCell, rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing((PlayerEntity)player, panelCell.canPlaceVertical())) : rotationLock);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to draw ghost cell: " + e.getMessage());
                    }
                }
            }
        }
        return null;
    }
}

