/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class PosInPanelCell
extends PanelCellPos {
    private final double x;
    private final double z;
    private final double y;

    protected PosInPanelCell(PanelTile panelTile, int row, int level, int cell, double x, double y, double z) {
        super(panelTile, row, cell, level);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public PanelCellSegment getSegment() {
        int segmentRow = Math.round((float)(this.x * 3.0) - 0.5f);
        int segmentColumn = Math.round((float)(this.z * 3.0) - 0.5f);
        if (segmentRow == 0) {
            switch (segmentColumn) {
                case 0: {
                    return PanelCellSegment.FRONT_RIGHT;
                }
                case 1: {
                    return PanelCellSegment.FRONT;
                }
                case 2: {
                    return PanelCellSegment.FRONT_LEFT;
                }
            }
        } else if (segmentRow == 1) {
            switch (segmentColumn) {
                case 0: {
                    return PanelCellSegment.RIGHT;
                }
                case 1: {
                    return PanelCellSegment.CENTER;
                }
                case 2: {
                    return PanelCellSegment.LEFT;
                }
            }
        } else if (segmentRow == 2) {
            switch (segmentColumn) {
                case 0: {
                    return PanelCellSegment.BACK_RIGHT;
                }
                case 1: {
                    return PanelCellSegment.BACK;
                }
                case 2: {
                    return PanelCellSegment.BACK_LEFT;
                }
            }
        }
        return null;
    }

    public static PosInPanelCell fromCoordinates(PanelTile panelTile, PanelCellPos panelCellPos, double x, double y, double z) {
        if (x >= 0.0 && x <= 1.0 && z >= 0.0 && z <= 1.0) {
            double rotatedZ;
            double rotatedX;
            Side direction = panelCellPos.getCellFacing();
            if (direction == Side.FRONT) {
                rotatedX = z;
                rotatedZ = 1.0 - x;
            } else if (direction == Side.RIGHT) {
                rotatedX = 1.0 - x;
                rotatedZ = 1.0 - z;
            } else if (direction == Side.BACK) {
                rotatedX = 1.0 - z;
                rotatedZ = x;
            } else {
                rotatedX = x;
                rotatedZ = z;
            }
            return new PosInPanelCell(panelTile, panelCellPos.getRow(), panelCellPos.getLevel(), panelCellPos.getColumn(), rotatedX, y, rotatedZ);
        }
        return null;
    }

    public static PosInPanelCell fromHitVec(PanelTile panelTile, BlockPos pos, BlockRayTraceResult result) {
        PanelCellPos panelCellPos;
        double relZ;
        double relY;
        double relX;
        Direction panelFacing = (Direction)panelTile.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        Direction rayTraceDirection = result.func_216354_b().func_176734_d();
        Vector3d hitVec = result.func_216347_e().func_72441_c((double)rayTraceDirection.func_82601_c() * 0.001, (double)rayTraceDirection.func_96559_d() * 0.001, (double)rayTraceDirection.func_82599_e() * 0.001);
        if (panelFacing == Direction.NORTH) {
            relX = hitVec.field_72450_a - (double)pos.func_177958_n();
            relY = hitVec.field_72449_c - (double)pos.func_177952_p();
            relZ = 1.0 - (hitVec.field_72448_b - (double)pos.func_177956_o());
        } else if (panelFacing == Direction.EAST) {
            relX = hitVec.field_72448_b - (double)pos.func_177956_o();
            relY = 1.0 - (hitVec.field_72450_a - (double)pos.func_177958_n());
            relZ = hitVec.field_72449_c - (double)pos.func_177952_p();
        } else if (panelFacing == Direction.SOUTH) {
            relX = hitVec.field_72450_a - (double)pos.func_177958_n();
            relY = 1.0 - (hitVec.field_72449_c - (double)pos.func_177952_p());
            relZ = hitVec.field_72448_b - (double)pos.func_177956_o();
        } else if (panelFacing == Direction.WEST) {
            relX = 1.0 - (hitVec.field_72448_b - (double)pos.func_177956_o());
            relY = hitVec.field_72450_a - (double)pos.func_177958_n();
            relZ = hitVec.field_72449_c - (double)pos.func_177952_p();
        } else if (panelFacing == Direction.UP) {
            relX = hitVec.field_72450_a - (double)pos.func_177958_n();
            relY = 1.0 - (hitVec.field_72448_b - (double)pos.func_177956_o());
            relZ = 1.0 - (hitVec.field_72449_c - (double)pos.func_177952_p());
        } else {
            relX = hitVec.field_72450_a - (double)pos.func_177958_n();
            relZ = hitVec.field_72449_c - (double)pos.func_177952_p();
            relY = hitVec.field_72448_b - (double)pos.func_177956_o();
        }
        if (relY < 0.125 && relY > 0.0625) {
            relY += (double)0.002f;
        }
        if ((panelCellPos = PanelCellPos.fromCoordinates(panelTile, relX, relY, relZ)) == null) {
            return null;
        }
        relX = (relX - (double)panelCellPos.getRow() / 8.0) * 8.0;
        relY = (relY - 0.125 - (double)panelCellPos.getLevel() / 8.0) * 8.0;
        relZ = (relZ - (double)panelCellPos.getColumn() / 8.0) * 8.0;
        return PosInPanelCell.fromCoordinates(panelTile, panelCellPos, relX, relY, relZ);
    }
}

