/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3f;

public class Button
implements IPanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_OAK_PLANKS = new ResourceLocation("minecraft", "block/oak_planks");
    protected boolean active = false;
    protected Integer ticksRemaining = 0;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite = this.getSprite();
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        matrixStack.func_227861_a_(0.0, 0.0, this.active ? 0.0625 : 0.125);
        float x1 = 0.3125f;
        float x2 = 0.6875f;
        float y1 = 0.375f;
        float y2 = 0.625f;
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -0.125, (double)(-y1));
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, 0.0f, 0.125f, sprite, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.6875);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.25f, 0.0f, 0.125f, sprite, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.25);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.375f, 0.0f, 0.125f, sprite, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.375);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.25f, 0.0f, 0.125f, sprite, combinedLight, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.active && outputDirection != Side.TOP ? 15 : 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.active && outputDirection == Side.BOTTOM ? 15 : 0;
    }

    @Override
    public boolean isIndependentState() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.active && this.ticksRemaining > 0) {
            Integer n = this.ticksRemaining;
            Integer n2 = this.ticksRemaining = Integer.valueOf(this.ticksRemaining - 1);
            if (this.ticksRemaining == 0) {
                this.active = false;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        if (!this.active) {
            PanelTile panelTile = cellPos.getPanelTile();
            panelTile.func_145831_w().func_184134_a((double)panelTile.func_174877_v().func_177958_n(), (double)panelTile.func_174877_v().func_177956_o(), (double)panelTile.func_174877_v().func_177952_p(), SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.25f, 2.0f, false);
            this.active = true;
            this.ticksRemaining = 30;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("ticksRemaining", this.ticksRemaining.intValue());
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.active = compoundNBT.func_74767_n("active");
        this.ticksRemaining = compoundNBT.func_74762_e("ticksRemaining");
    }

    protected TextureAtlasSprite getSprite() {
        return RenderHelper.getSprite(TEXTURE_OAK_PLANKS);
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.active ? 15 : 0);
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.BUTTONSHAPE;
    }
}

