/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3f;

public class Lever
implements IPanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_LEVER = new ResourceLocation("tinyredstone", "block/lever");
    public static ResourceLocation TEXTURE_LEVER_TOP = new ResourceLocation("tinyredstone", "block/lever_top");
    public static ResourceLocation TEXTURE_COBBLESTONE = new ResourceLocation("minecraft", "block/cobblestone");
    private boolean active = false;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite_cobble = RenderHelper.getSprite(TEXTURE_COBBLESTONE);
        TextureAtlasSprite sprite_lever = RenderHelper.getSprite(TEXTURE_LEVER);
        TextureAtlasSprite sprite_lever_top = RenderHelper.getSprite(TEXTURE_LEVER_TOP);
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        matrixStack.func_227860_a_();
        float x1 = 0.3125f;
        float x2 = 0.6875f;
        float y1 = 0.25f;
        float y2 = 0.75f;
        float w = 0.375f;
        float d = 0.5f;
        float h = 0.1875f;
        matrixStack.func_227861_a_(0.0, 0.0, (double)h);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_cobble, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, (double)(-h), (double)(-y1));
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)(1.0f - x1));
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, d, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)d);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, w, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)w);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, d, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(60.0f));
        matrixStack.func_227861_a_(0.0, 0.03125, 0.0);
        matrixStack.func_227865_b_();
        x1 = 0.4375f;
        x2 = 0.5625f;
        y1 = 0.0f;
        y2 = 0.625f;
        matrixStack.func_227861_a_(0.0, 0.40625, (double)(h / 2.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.active ? 45.0f : 135.0f));
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_lever, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_lever, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_lever, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_lever, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_(0.0, (double)(-x1), (double)y2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, x1, x2, sprite_lever_top, combinedLight, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.active && outputDirection != Side.TOP ? 15 : 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.active && outputDirection == Side.BOTTOM ? 15 : 0;
    }

    @Override
    public boolean isIndependentState() {
        return true;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        PanelTile panelTile = cellPos.getPanelTile();
        panelTile.func_145831_w().func_184134_a((double)panelTile.func_174877_v().func_177958_n(), (double)panelTile.func_174877_v().func_177956_o(), (double)panelTile.func_174877_v().func_177952_p(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.25f, 2.0f, false);
        this.active = !this.active;
        return true;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.active = compoundNBT.func_74767_n("active");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("State", this.active ? "On" : "Off");
        overlayBlockInfo.setPowerOutput(0);
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.BUTTONSHAPE;
    }
}

