/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.dannyandson.tinyredstone.gui.NoteBlockGUI;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.PlaySound;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TranslationTextComponent;

public class NoteBlock
extends TinyBlock
implements IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_TINY_NOTE_BLOCK = new ResourceLocation("minecraft", "block/note_block");
    private static final String[] noteNames = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F"};
    private boolean powered = false;
    private int pitch = 0;
    private String instrument = "harp";

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE_TINY_NOTE_BLOCK);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        boolean r = super.neighborChanged(cellPos);
        if (this.weakSignalStrength + this.strongSignalStrength > 0 || (frontNeighbor != null ? frontNeighbor.getWeakRsOutput() : 0) + (rightNeighbor != null ? rightNeighbor.getWeakRsOutput() : 0) + (backNeighbor != null ? backNeighbor.getWeakRsOutput() : 0) + (leftNeighbor != null ? leftNeighbor.getWeakRsOutput() : 0) + (topNeighbor != null ? topNeighbor.getWeakRsOutput() : 0) + (bottomNeighbor != null ? bottomNeighbor.getWeakRsOutput() : 0) > 0) {
            if (!this.powered) {
                this.powered = true;
                this.playNote(cellPos.getPanelTile());
                return true;
            }
        } else if (this.powered) {
            this.powered = false;
            return true;
        }
        return r;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() == Registration.REDSTONE_WRENCH.get()) {
            if (cellPos.getPanelTile().func_145831_w().field_72995_K) {
                NoteBlockGUI.open(cellPos.getPanelTile(), cellPos.getIndex(), this);
            }
        } else {
            ++this.pitch;
            if (this.pitch > 24) {
                this.pitch = 0;
            }
            this.playNote(cellPos.getPanelTile());
        }
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = super.writeNBT();
        nbt.func_74768_a("pitch", this.pitch);
        nbt.func_74778_a("instrument", this.instrument);
        nbt.func_74757_a("powered", this.powered);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        super.readNBT(compoundNBT);
        this.pitch = compoundNBT.func_74762_e("pitch");
        this.instrument = compoundNBT.func_74779_i("instrument");
        this.powered = compoundNBT.func_74767_n("powered");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("Instrument", new TranslationTextComponent("tinyredstone.noteblock." + this.instrument).getString());
        overlayBlockInfo.addText("Note", this.pitch + " (" + noteNames[this.pitch % 12] + ")");
    }

    private void playNote(PanelTile panelTile) {
        if (!panelTile.func_145831_w().field_72995_K) {
            BlockPos pos = panelTile.func_174877_v();
            for (PlayerEntity player : panelTile.func_145831_w().func_217369_A()) {
                if (!panelTile.func_145831_w().func_217358_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 48.0)) continue;
                ModNetworkHandler.sendToClient(new PlaySound(pos, "minecraft", "block.note_block." + this.instrument, 0.5f, this.pitch == 0 ? 0.5f : (float)Math.pow(2.0, ((float)this.pitch - 12.0f) / 12.0f)), (ServerPlayerEntity)player);
            }
        }
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }
}

