/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class Piston
implements IPanelCell {
    public static ResourceLocation TEXTURE_PISTON_SIDE = new ResourceLocation("minecraft", "block/piston_side");
    public static ResourceLocation TEXTURE_PISTON_SIDE_TOP = new ResourceLocation("tinyredstone", "block/piston_side_top");
    public static ResourceLocation TEXTURE_PISTON_SIDE_BOTTOM = new ResourceLocation("tinyredstone", "block/piston_side_bottom");
    public static ResourceLocation TEXTURE_PISTON_TOP = new ResourceLocation("minecraft", "block/piston_top");
    public static ResourceLocation TEXTURE_PISTON_BOTTOM = new ResourceLocation("minecraft", "block/piston_bottom");
    public static ResourceLocation TEXTURE_PISTON_INNER = new ResourceLocation("minecraft", "block/piston_inner");
    protected boolean extended = false;
    protected int changePending = -1;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite_bottom = RenderHelper.getSprite(TEXTURE_PISTON_BOTTOM);
        TextureAtlasSprite sprite_inner = RenderHelper.getSprite(TEXTURE_PISTON_INNER);
        TextureAtlasSprite sprite_inner_top = RenderHelper.getSprite(TEXTURE_PISTON_TOP);
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite_top = this.getSprite_top();
        boolean renderExtended = this.extended && this.changePending == -1 || !this.extended && this.changePending != -1;
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-1.0, -1.0, 0.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(-1.0, 0.0, 1.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_bottom, combinedLight, alpha);
        if (renderExtended) {
            matrixStack.func_227861_a_(0.0, 0.0, -1.75);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_inner_top, combinedLight, alpha);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 1.0);
        if (renderExtended) {
            matrixStack.func_227861_a_(0.0, 0.0, -0.25);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_inner, combinedLight, alpha);
            matrixStack.func_227861_a_(0.0, 0.0, 1.25);
        }
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_top, combinedLight, alpha);
    }

    private void drawSide(MatrixStack matrixStack, IVertexBuilder builder, int combinedLight, float alpha) {
        boolean renderExtended = this.extended && this.changePending == -1 || !this.extended && this.changePending != -1;
        TextureAtlasSprite sprite_side_top = RenderHelper.getSprite(TEXTURE_PISTON_SIDE_TOP);
        TextureAtlasSprite sprite_side_bottom = renderExtended ? RenderHelper.getSprite(TEXTURE_PISTON_SIDE_BOTTOM) : RenderHelper.getSprite(TEXTURE_PISTON_SIDE);
        matrixStack.func_227860_a_();
        if (renderExtended) {
            matrixStack.func_227862_a_(1.0f, 0.75f, 1.0f);
        }
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_side_bottom, combinedLight, alpha);
        matrixStack.func_227865_b_();
        if (renderExtended) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 1.75, 0.0);
            matrixStack.func_227862_a_(1.0f, 0.25f, 1.0f);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_side_top, combinedLight, alpha);
            matrixStack.func_227862_a_(0.25f, 4.0f, 1.0f);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(-1.0, -2.5, -0.375);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_side_top, combinedLight, alpha);
            matrixStack.func_227865_b_();
        }
    }

    protected TextureAtlasSprite getSprite_top() {
        return RenderHelper.getSprite(TEXTURE_PISTON_TOP);
    }

    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        boolean extend;
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        boolean bl = extend = (cellPos.getLevel() > 0 || cellPos.getCellFacing() != Side.TOP) && (rightNeighbor != null && rightNeighbor.getWeakRsOutput() > 0 || frontNeighbor != null && frontNeighbor.getWeakRsOutput() > 0 || leftNeighbor != null && leftNeighbor.getWeakRsOutput() > 0 || topNeighbor != null && topNeighbor.getWeakRsOutput() > 0 || bottomNeighbor != null && bottomNeighbor.getWeakRsOutput() > 0) && (backNeighbor == null || backNeighbor.isOnPanel()) && (this.extended || backNeighbor == null || backNeighbor.getNeighborIPanelCell() != null && backNeighbor.isPushable());
        if (extend != this.extended) {
            this.extended = extend;
            this.changePending = 2;
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return 0;
    }

    @Override
    public boolean isPushable() {
        return !this.extended;
    }

    @Override
    public boolean canPlaceVertical() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changePending < 0) {
            return false;
        }
        if (this.changePending > 0) {
            --this.changePending;
            return false;
        }
        --this.changePending;
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("extended", this.extended);
        nbt.func_74768_a("changePending", this.changePending);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.extended = compoundNBT.func_74767_n("extended");
        this.changePending = compoundNBT.func_74762_e("changePending");
    }
}

