/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.Comparator;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class Repeater
implements IPanelCell,
IPanelCellInfoProvider {
    protected boolean input = false;
    protected boolean output = false;
    protected boolean locked = false;
    private int onPending = -1;
    private int offPending = -1;
    protected Integer ticks = 2;
    public static ResourceLocation TEXTURE_REPEATER_ON = new ResourceLocation("tinyredstone", "block/panel_repeater_on");
    public static ResourceLocation TEXTURE_REPEATER_OFF = new ResourceLocation("tinyredstone", "block/panel_repeater_off");

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_repeater = this.getRepeaterTexture();
        TextureAtlasSprite sprite_torch_head = RenderHelper.getSprite(RedstoneDust.TEXTURE_REDSTONE_DUST_SEGMENT_ON);
        if (!this.output) {
            sprite_torch_head = RenderHelper.getSprite(RedstoneDust.TEXTURE_REDSTONE_DUST_SEGMENT_OFF);
        }
        if (this.locked) {
            sprite_torch_head = RenderHelper.getSprite(new ResourceLocation("minecraft", "block/bedrock"));
        }
        matrixStack.func_227861_a_(0.0, 0.0, 0.25);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-1.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_repeater, combinedLight, alpha);
        matrixStack.func_227865_b_();
        if (this.ticks > 8) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 0.01);
            RenderHelper.drawRectangle(builder, matrixStack, 0.25f, 0.75f, 0.125f, 0.25f, sprite_torch_head, combinedLight, alpha);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.125);
        RenderHelper.drawRectangle(builder, matrixStack, 0.4375f, 0.5625f, 0.75f, 0.875f, sprite_torch_head, combinedLight, alpha);
        float torch2Y = this.ticks < 8 ? 0.75f - this.ticks.floatValue() * 0.0625f : 0.25f;
        RenderHelper.drawRectangle(builder, matrixStack, 0.4375f, 0.5625f, torch2Y - 0.125f, torch2Y, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -0.25, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.4375, 0.25, -0.75);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227861_a_(0.0, 0.0, 0.875 - (double)torch2Y);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.75, 0.25, -0.4375);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227861_a_((double)torch2Y - 0.875, 0.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.4375, 0.25, -0.125);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227861_a_(0.0, 0.0, (double)torch2Y - 0.875);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.125, 0.25, -0.4375);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227861_a_(0.875 - (double)torch2Y, 0.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, sprite_torch_head, combinedLight, alpha);
        matrixStack.func_227865_b_();
    }

    protected TextureAtlasSprite getRepeaterTexture() {
        if (this.output) {
            return RenderHelper.getSprite(TEXTURE_REPEATER_ON);
        }
        return RenderHelper.getSprite(TEXTURE_REPEATER_OFF);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        if (backNeighbor != null && backNeighbor.getWeakRsOutput() > 0 && !this.input) {
            this.input = true;
            if (this.offPending == 1) {
                this.onPending = this.ticks;
            }
        } else if ((backNeighbor == null || backNeighbor.getWeakRsOutput() == 0) && this.input) {
            this.input = false;
        }
        boolean wasLocked = this.locked;
        boolean bl = this.locked = leftNeighbor != null && leftNeighbor.getStrongRsOutput() > 0 && (leftNeighbor.getNeighborIPanelCell() instanceof Repeater || leftNeighbor.getNeighborIPanelCell() instanceof Comparator || leftNeighbor.getNeighborBlockState() != null && (leftNeighbor.getNeighborBlockState().func_177230_c() == Blocks.field_196633_cV || leftNeighbor.getNeighborBlockState().func_177230_c() == Blocks.field_196762_fd)) || rightNeighbor != null && rightNeighbor.getStrongRsOutput() > 0 && (rightNeighbor.getNeighborIPanelCell() instanceof Repeater || rightNeighbor.getNeighborIPanelCell() instanceof Comparator || rightNeighbor.getNeighborBlockState() != null && (rightNeighbor.getNeighborBlockState().func_177230_c() == Blocks.field_196633_cV || rightNeighbor.getNeighborBlockState().func_177230_c() == Blocks.field_196762_fd));
        if (wasLocked && !this.locked && this.output != this.input) {
            if (this.input) {
                this.onPending = this.ticks;
            } else {
                this.offPending = this.ticks;
            }
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.getStrongRsOutput(outputDirection);
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        if (this.output && outputDirection == Side.FRONT) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.input != this.output) {
            if (this.input && this.onPending == -1) {
                this.onPending = this.ticks;
            }
            if (!this.input && this.offPending == -1) {
                this.offPending = this.ticks;
            }
        }
        if (this.onPending >= 0) {
            --this.onPending;
        }
        if (this.offPending >= 0) {
            --this.offPending;
        }
        if (this.onPending == 0 && !this.locked) {
            this.output = true;
            this.offPending = this.input ? -1 : this.ticks;
            return true;
        }
        if (this.offPending == 0 && !this.locked && (!this.input || this.output && this.onPending > -1)) {
            if (this.output && this.onPending > -1) {
                this.onPending = this.ticks;
            }
            this.output = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        if (this.ticks < 8) {
            this.ticks = this.ticks + 2;
            return true;
        }
        this.ticks = 2;
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("output", this.output);
        nbt.func_74757_a("input", this.input);
        nbt.func_74757_a("locked", this.locked);
        nbt.func_74768_a("offPending", this.offPending);
        nbt.func_74768_a("onPending", this.onPending);
        nbt.func_74768_a("ticks", this.ticks.intValue());
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.output = compoundNBT.func_74767_n("output");
        this.input = compoundNBT.func_74767_n("input");
        this.locked = compoundNBT.func_74767_n("locked");
        this.ticks = compoundNBT.func_74762_e("ticks");
        this.offPending = compoundNBT.func_74762_e("offPending");
        this.onPending = compoundNBT.func_74762_e("onPending");
    }

    public Integer getTicks() {
        return this.ticks;
    }

    public void setTicks(Integer ticks) {
        this.ticks = ticks < 0 ? Integer.valueOf(0) : (ticks > (Integer)Config.SUPER_REPEATER_MAX.get() * 2 ? Integer.valueOf((Integer)Config.SUPER_REPEATER_MAX.get() * 2) : ticks);
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("Delay", this.ticks / 2 + " ticks");
        if (this.locked) {
            overlayBlockInfo.addInfo("Locked");
        }
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.QUARTERCELLSLAB;
    }
}

