/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IColorablePanelCell;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class TinyBlock
implements IPanelCell,
IColorablePanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_TINY_BLOCK = new ResourceLocation("minecraft", "block/white_wool");
    protected int weakSignalStrength = 0;
    protected int strongSignalStrength = 0;
    protected int color = DyeColor.WHITE.getColorValue();

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE_TINY_BLOCK);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        int weak = 0;
        int strong = 0;
        if (frontNeighbor != null) {
            if (frontNeighbor.powerDrops()) {
                weak = frontNeighbor.getWeakRsOutput();
            } else if (!(frontNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = frontNeighbor.getStrongRsOutput();
            }
        }
        if (rightNeighbor != null) {
            if (rightNeighbor.powerDrops()) {
                weak = Math.max(weak, rightNeighbor.getWeakRsOutput());
            } else if (!(rightNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, rightNeighbor.getStrongRsOutput());
            }
        }
        if (backNeighbor != null) {
            if (backNeighbor.powerDrops()) {
                weak = Math.max(weak, backNeighbor.getWeakRsOutput());
            } else if (!(backNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, backNeighbor.getStrongRsOutput());
            }
        }
        if (leftNeighbor != null) {
            if (leftNeighbor.powerDrops()) {
                weak = Math.max(weak, leftNeighbor.getWeakRsOutput());
            } else if (!(leftNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, leftNeighbor.getStrongRsOutput());
            }
        }
        if (topNeighbor != null) {
            if (topNeighbor.powerDrops()) {
                weak = Math.max(weak, topNeighbor.getWeakRsOutput());
            } else if (!(topNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, topNeighbor.getStrongRsOutput());
            }
        }
        if (bottomNeighbor != null) {
            if (bottomNeighbor.powerDrops()) {
                weak = Math.max(weak, bottomNeighbor.getWeakRsOutput());
            } else if (!(bottomNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, bottomNeighbor.getStrongRsOutput());
            }
        }
        if ((weak = Math.max(weak, strong)) != this.weakSignalStrength || strong != this.strongSignalStrength) {
            this.weakSignalStrength = weak;
            this.strongSignalStrength = strong;
            return true;
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.weakSignalStrength;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.strongSignalStrength;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("strong", this.strongSignalStrength);
        nbt.func_74768_a("weak", this.weakSignalStrength);
        nbt.func_74768_a("color", this.color);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.strongSignalStrength = compoundNBT.func_74762_e("strong");
        this.weakSignalStrength = compoundNBT.func_74762_e("weak");
        this.color = compoundNBT.func_74762_e("color");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.weakSignalStrength);
    }
}

