/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModWidget
extends Widget {
    private HAlignment halignment = HAlignment.LEFT;
    private VAlignment valignment = VAlignment.TOP;
    private float scale = 1.0f;
    private int color;
    private int bgcolor = -1;
    private int textWidth;
    private int textHeight;
    private ITextComponent toolTipTextComponent;
    private IPressable pressedAction = null;

    public ModWidget(int x, int y, int width, int height, ITextComponent title, int textColor, int bgColor) {
        super(x, y, width, height, title);
        this.color = textColor;
        this.bgcolor = bgColor;
        if (title.getString().length() > 0) {
            this.textWidth = Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)this.func_230458_i_());
            Minecraft.func_71410_x().field_71466_p.getClass();
            this.textHeight = 9;
        }
    }

    public ModWidget(int x, int y, int width, int height, ITextComponent title, int textColor) {
        this(x, y, width, height, title, textColor, -1);
    }

    public ModWidget(int x, int y, int width, int height, ITextComponent title) {
        this(x, y, width, height, title, -1, -1);
    }

    public ModWidget(int x, int y, int width, int height, int bgColor) {
        this(x, y, width, height, ITextComponent.func_244388_a((String)""), -1, bgColor);
    }

    public ModWidget(int x, int y, int width, int height, int bgColor, IPressable pressedAction) {
        this(x, y, width, height, ITextComponent.func_244388_a((String)""), -1, bgColor);
        this.pressedAction = pressedAction;
    }

    public ModWidget setTextHAlignment(HAlignment alignment) {
        this.halignment = alignment;
        return this;
    }

    public ModWidget setTextVAlignment(VAlignment alignment) {
        this.valignment = alignment;
        return this;
    }

    public ModWidget setToolTip(ITextComponent textComponent) {
        this.toolTipTextComponent = textComponent;
        return this;
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        if (this.pressedAction == null || mouseX < (double)this.field_230690_l_ || mouseX > (double)(this.field_230690_l_ + this.field_230688_j_) || mouseY < (double)this.field_230691_m_ || mouseY > (double)(this.field_230691_m_ + this.field_230689_k_)) {
            return false;
        }
        this.pressedAction.onPress(this);
        return true;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.field_230694_p_) {
            int drawX;
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            switch (this.halignment) {
                default: {
                    drawX = this.field_230690_l_;
                    break;
                }
                case CENTER: {
                    drawX = this.field_230690_l_ + (int)((float)((this.field_230688_j_ - this.textWidth) / 2) * this.scale);
                    break;
                }
                case RIGHT: {
                    drawX = this.field_230690_l_ + (int)((float)(this.field_230688_j_ - this.textWidth) * this.scale);
                }
            }
            switch (this.valignment) {
                default: {
                    int drawY = this.field_230691_m_;
                    break;
                }
                case MIDDLE: {
                    int drawY = this.field_230691_m_ + (int)((float)((this.field_230689_k_ - this.textHeight) / 2) * this.scale);
                    break;
                }
                case BOTTOM: {
                    int drawY = this.field_230691_m_ + (int)((float)(this.field_230689_k_ - this.textHeight) * this.scale);
                }
            }
            if (this.scale != 1.0f) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                matrixStack.func_227861_a_((double)drawX, (double)this.field_230691_m_, 0.0);
                fr.func_238422_b_(matrixStack, this.func_230458_i_().func_241878_f(), (float)drawX, (float)this.field_230691_m_, this.color);
                matrixStack.func_227865_b_();
            } else {
                fr.func_238422_b_(matrixStack, this.func_230458_i_().func_241878_f(), (float)drawX, (float)this.field_230691_m_, this.color);
            }
            if (this.bgcolor != -1) {
                ModWidget.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.bgcolor);
            }
            if (this.toolTipTextComponent != null && mouseX >= this.field_230690_l_ && mouseX <= this.field_230690_l_ + this.field_230688_j_ && mouseY >= this.field_230691_m_ && mouseY <= this.field_230691_m_ + this.field_230689_k_) {
                this.renderHoverToolTip(matrixStack, mouseX, mouseY);
            }
        }
    }

    public void renderHoverToolTip(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.toolTipTextComponent != null) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int width = fr.func_238414_a_((ITextProperties)this.toolTipTextComponent);
            fr.getClass();
            int height = 9;
            ModWidget.func_238467_a_((MatrixStack)matrixStack, (int)mouseX, (int)(mouseY + 10), (int)(mouseX + width + 4), (int)(mouseY + 10 + height + 4), (int)-872415232);
            ModWidget.func_238467_a_((MatrixStack)matrixStack, (int)(mouseX + 1), (int)(mouseY + 11), (int)(mouseX + width + 3), (int)(mouseY + 10 + height + 3), (int)0x66EEEEEE);
            fr.func_238422_b_(matrixStack, this.toolTipTextComponent.func_241878_f(), (float)((double)mouseX + 3.0), (float)((double)mouseY + 13.0), -65794);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(ModWidget var1);
    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

