/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.items;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.gui.BlueprintGUI;
import com.dannyandson.tinyredstone.setup.ModSetup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Blueprint
extends Item {
    public Blueprint() {
        super(new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flags) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("blueprint")) {
            list.add((ITextComponent)new TranslationTextComponent("message.item.blueprint.full"));
            Map<Item, Integer> blueprintItems = Blueprint.getRequiredComponents(stack.func_179543_a("blueprint"));
            for (Item item : blueprintItems.keySet()) {
                list.add(ITextComponent.func_244388_a((String)(item.getRegistryName().toString() + " : " + blueprintItems.get(item))));
            }
        } else {
            list.add((ITextComponent)new TranslationTextComponent("message.item.blueprint.empty"));
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (te instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            if (context.func_195996_i().func_77978_p() != null && context.func_195996_i().func_77978_p().func_74764_b("blueprint")) {
                PlayerEntity player = context.func_195999_j();
                if (panelTile.getCellCount() == 0 && player != null) {
                    CompoundNBT blueprintNBT = context.func_195996_i().func_179543_a("blueprint");
                    Map<Item, Integer> items = Blueprint.getRequiredComponents(blueprintNBT);
                    if (player.func_184812_l_() || Blueprint.playerHasSufficientComponents(items, player)) {
                        panelTile.loadCellsFromNBT(blueprintNBT, false);
                        panelTile.updateSide(Side.FRONT);
                        panelTile.updateSide(Side.RIGHT);
                        panelTile.updateSide(Side.BACK);
                        panelTile.updateSide(Side.LEFT);
                        panelTile.func_70296_d();
                        if (!player.func_184812_l_()) {
                            block0: for (Item item : items.keySet()) {
                                int itemsToRemove = items.get(item);
                                for (ItemStack invStack : player.field_71071_by.field_70462_a) {
                                    if (invStack.func_77973_b().equals(item)) {
                                        int removeCt = Math.min(invStack.func_190916_E(), itemsToRemove);
                                        invStack.func_190920_e(invStack.func_190916_E() - removeCt);
                                        itemsToRemove -= removeCt;
                                    }
                                    if (itemsToRemove != 0) continue;
                                    continue block0;
                                }
                            }
                        }
                    }
                }
            } else {
                CompoundNBT nbt = new CompoundNBT();
                CompoundNBT blueprintNBT = panelTile.saveToNbt(new CompoundNBT());
                nbt.func_74768_a("CustomModelData", 1);
                nbt.func_218657_a("blueprint", (INBT)blueprintNBT);
                context.func_195996_i().func_77982_d(nbt);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K && ((Boolean)Config.JSON_BLUEPRINT.get()).booleanValue()) {
            BlueprintGUI.open(playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private static Map<Item, Integer> getRequiredComponents(CompoundNBT blueprintNBT) {
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        if (blueprintNBT.func_74764_b("cells")) {
            CompoundNBT cellsNBT = blueprintNBT.func_74775_l("cells");
            for (String key : cellsNBT.func_150296_c()) {
                try {
                    Class<?> iPanelCellClass = Class.forName(cellsNBT.func_74775_l(key).func_74779_i("class"));
                    if (!IPanelCell.class.isAssignableFrom(iPanelCellClass)) continue;
                    Item item = PanelBlock.getPanelCellItemFromClass(iPanelCellClass);
                    if (items.containsKey(item)) {
                        items.put(item, (Integer)items.get(item) + 1);
                        continue;
                    }
                    items.put(item, 1);
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
        }
        return items;
    }

    private static boolean playerHasSufficientComponents(Map<Item, Integer> items, PlayerEntity player) {
        for (Item item : items.keySet()) {
            ItemStack itemStack = new ItemStack((IItemProvider)item);
            int count = 0;
            for (ItemStack invStack : player.field_71071_by.field_70462_a) {
                if (!invStack.func_77973_b().equals(itemStack.func_77973_b())) continue;
                count += invStack.func_190916_E();
            }
            if (count >= items.get(item)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static CompoundNBT cleanUpBlueprintNBT(CompoundNBT nbt) {
        CompoundNBT blueprintNBT;
        if (nbt.func_74764_b("blueprint") && (blueprintNBT = nbt.func_74775_l("blueprint")).func_74764_b("cells")) {
            CompoundNBT newCellsNBT = new CompoundNBT();
            CompoundNBT cellsNBT = blueprintNBT.func_74775_l("cells");
            for (String key : cellsNBT.func_150296_c()) {
                try {
                    if (!IPanelCell.class.isAssignableFrom(Class.forName(cellsNBT.func_74775_l(key).func_74779_i("class")))) continue;
                    newCellsNBT.func_218657_a(key, (INBT)cellsNBT.func_74775_l(key));
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
            CompoundNBT newNBT = new CompoundNBT();
            CompoundNBT newBlueprintNBT = new CompoundNBT();
            newNBT.func_74768_a("CustomModelData", 1);
            newBlueprintNBT.func_218657_a("cells", (INBT)newCellsNBT);
            newNBT.func_218657_a("blueprint", (INBT)newBlueprintNBT);
            if (nbt.func_74764_b("display")) {
                newNBT.func_218657_a("display", (INBT)nbt.func_74775_l("display"));
            }
            return newNBT;
        }
        return null;
    }
}

