/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.panelcells.NoteBlock;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class NoteBlockInstrumentSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final String instrument;

    public NoteBlockInstrumentSync(BlockPos pos, int cellIndex, String instrument) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.instrument = instrument;
    }

    public NoteBlockInstrumentSync(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.cellIndex = buffer.readInt();
        this.instrument = buffer.func_150789_c(32);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.cellIndex);
        buf.func_180714_a(this.instrument);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PanelCellPos cellPos;
            IPanelCell cell;
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.pos);
            if (te instanceof PanelTile && (cell = (cellPos = PanelCellPos.fromIndex((PanelTile)te, this.cellIndex)).getIPanelCell()) instanceof NoteBlock) {
                ((NoteBlock)cell).setInstrument(this.instrument);
                ((PanelTile)te).flagSync();
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

