/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IColorablePanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.gui.ClearPanelGUI;
import com.dannyandson.tinyredstone.gui.PanelCrashGUI;
import com.dannyandson.tinyredstone.gui.TinyBlockGUI;
import com.dannyandson.tinyredstone.items.RedstoneWrench;
import com.dannyandson.tinyredstone.setup.Registration;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PanelBlock
extends BaseEntityBlock {
    private static final Map<Direction, VoxelShape> BASE = new HashMap<Direction, VoxelShape>();
    private static final Map<Item, Class<? extends IPanelCell>> itemPanelCellMap;
    private static final Map<Class<? extends IPanelCell>, Item> panelCellItemMap;
    private static final Map<Item, Class<? extends IPanelCover>> itemPanelCoverMap;
    private static final Map<Class<? extends IPanelCover>, Item> panelCoverItemMap;

    public PanelBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(2.0f));
    }

    public Class<? extends IPanelCell> getIPanelCellByItem(Item item) {
        return itemPanelCellMap.get(item);
    }

    public Item getItemByIPanelCell(Class<? extends IPanelCell> panelCell) {
        return panelCellItemMap.get(panelCell);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PanelTile(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            BlockEntity panelTile$temp = t;
            if (panelTile$temp instanceof PanelTile) {
                PanelTile panelTile = (PanelTile)panelTile$temp;
                panelTile.tick();
            }
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext context) {
        BlockEntity te = source.m_7702_(pos);
        if (te instanceof PanelTile) {
            return ((PanelTile)te).getVoxelShape();
        }
        return BASE.get(state.m_61143_((Property)BlockStateProperties.f_61372_));
    }

    public boolean m_7899_(BlockState iBlockState) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction directionFromNeighborToThis) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof PanelTile && directionFromNeighborToThis != null) {
            PanelTile panelTile = (PanelTile)tileentity;
            Direction facing = directionFromNeighborToThis.m_122424_();
            return panelTile.hasCellsOnFace(facing);
        }
        return super.shouldCheckWeakPower(state, world, pos, directionFromNeighborToThis);
    }

    public int m_6378_(BlockState state, BlockGetter blockReader, BlockPos pos, Direction directionFromNeighborToThis) {
        BlockEntity tileentity = blockReader.m_7702_(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            Integer power = panelTile.weakPowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.m_122424_()));
            return power == null ? 0 : power;
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter blockReader, BlockPos pos, Direction directionFromNeighborToThis) {
        BlockEntity tileentity = blockReader.m_7702_(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            Integer power = panelTile.strongPowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.m_122424_()));
            return power == null ? 0 : power;
        }
        return 0;
    }

    public void m_6861_(BlockState currentState, Level world, BlockPos pos, Block blockIn, BlockPos neighborPos, boolean isMoving) {
        Direction direction;
        if (pos.m_142126_().equals((Object)neighborPos)) {
            direction = Direction.EAST;
        } else if (pos.m_142128_().equals((Object)neighborPos)) {
            direction = Direction.SOUTH;
        } else if (pos.m_142125_().equals((Object)neighborPos)) {
            direction = Direction.WEST;
        } else if (pos.m_142127_().equals((Object)neighborPos)) {
            direction = Direction.NORTH;
        } else if (pos.m_7494_().equals((Object)neighborPos)) {
            direction = Direction.UP;
        } else if (pos.m_7495_().equals((Object)neighborPos)) {
            direction = Direction.DOWN;
        } else {
            return;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof PanelTile) {
            boolean change = false;
            PanelTile panelTile = (PanelTile)tileentity;
            try {
                Side side = panelTile.getSideFromDirection(direction);
                if (side != null) {
                    if (panelTile.pingOutwardObservers(direction)) {
                        change = true;
                    }
                    if (panelTile.updateSide(direction)) {
                        change = true;
                    }
                    if (panelTile.updateOutputs() && !world.f_46443_) {
                        panelTile.m_6596_();
                    }
                    if (change) {
                        panelTile.flagSync();
                    }
                }
            }
            catch (Exception e) {
                panelTile.handleCrash(e);
            }
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return true;
    }

    private ItemStack getItemWithNBT(BlockGetter worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            ItemStack itemstack = this.m_7397_(worldIn, pos, state);
            CompoundTag compoundnbt = panelTile.saveToNbt(new CompoundTag());
            if (!compoundnbt.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
            }
            return itemstack;
        }
        return null;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        ItemStack itemstack;
        if (!player.m_7500_() && (itemstack = this.getItemWithNBT((BlockGetter)worldIn, pos, state)) != null) {
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            worldIn.m_7967_((Entity)itementity);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        PanelCellPos panelCellPos;
        PanelTile panelTile;
        IPanelCell cell;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PanelTile && (cell = (panelTile = (PanelTile)te).getIPanelCell(panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), ((RedstoneWrench)Registration.REDSTONE_WRENCH.get()).getHitResult(player.f_19853_, player)))) != null) {
            return panelCellItemMap.get(cell.getClass()).m_7968_();
        }
        ItemStack itemStack = this.getItemWithNBT(world, pos, state);
        if (itemStack == null) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        return itemStack;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        boolean handled;
        block49: {
            handled = false;
            BlockEntity te = world.m_7702_(pos);
            BlockEntity blockEntity = te;
            if (blockEntity instanceof PanelTile) {
                PanelTile panelTile = (PanelTile)blockEntity;
                if (hand == InteractionHand.MAIN_HAND) {
                    try {
                        block50: {
                            PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, blockHitResult);
                            if (posInPanelCell == null) break block49;
                            Item heldItem = player.m_21120_(hand).m_41720_();
                            if (panelTile.isCrashed() || panelTile.isOverflown()) {
                                if (world.f_46443_) {
                                    PanelCrashGUI.open(panelTile);
                                }
                                handled = true;
                            } else if (posInPanelCell.getIPanelCell() == null && heldItem == Registration.REDSTONE_WRENCH.get() && !player.m_6047_() && !panelTile.isCovered()) {
                                panelTile.rotate(Rotation.CLOCKWISE_90);
                                handled = true;
                            } else if (heldItem == Registration.REDSTONE_WRENCH.get() && player.m_6047_()) {
                                this.m_5707_(world, pos, state, player);
                                if (!world.f_46443_) {
                                    world.m_46961_(pos, true);
                                }
                                handled = true;
                            } else if (heldItem == Registration.TINY_COLOR_SELECTOR.get() && posInPanelCell.getIPanelCell() instanceof IColorablePanelCell) {
                                if (world.f_46443_) {
                                    TinyBlockGUI.open(panelTile, posInPanelCell.getIndex(), (IColorablePanelCell)((Object)posInPanelCell.getIPanelCell()));
                                }
                            } else if (heldItem instanceof DyeItem) {
                                int color = RenderHelper.getTextureDiffusedColor(((DyeItem)heldItem).m_41089_());
                                if (color != panelTile.Color) {
                                    panelTile.Color = color;
                                    if (!player.m_7500_()) {
                                        player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                                    }
                                }
                                handled = true;
                            } else {
                                if (heldItem.equals(Items.f_42127_) && player.m_6302_().equals("Dev")) {
                                    throw new Exception("Test Exception");
                                }
                                if (itemPanelCoverMap.containsKey(heldItem) && !panelTile.isCovered()) {
                                    try {
                                        Object panelCoverObject = itemPanelCoverMap.get(heldItem).getConstructors()[0].newInstance(new Object[0]);
                                        if (!(panelCoverObject instanceof IPanelCover)) break block50;
                                        panelTile.panelCover = (IPanelCover)panelCoverObject;
                                        panelTile.flagLightUpdate = true;
                                        if (!world.f_46443_) {
                                            world.m_7260_(pos, state, state, 2);
                                        }
                                        if (!player.m_7500_()) {
                                            player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                                        }
                                    }
                                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                        TinyRedstone.LOGGER.error("Exception thrown while" + e.getMessage());
                                    }
                                } else if (posInPanelCell.getIPanelCell() != null && !panelTile.isCovered() && posInPanelCell.getIPanelCell().hasActivation() && !player.m_6047_()) {
                                    if (posInPanelCell.getIPanelCell().onBlockActivated(posInPanelCell, posInPanelCell.getSegment(), player)) {
                                        panelTile.updateCell(posInPanelCell);
                                        panelTile.updateNeighborCells(posInPanelCell);
                                        if (posInPanelCell.getIPanelCell() instanceof RedstoneDust) {
                                            PanelCellPos above = posInPanelCell.offset(Side.TOP);
                                            PanelCellPos below = posInPanelCell.offset(Side.BOTTOM);
                                            if (above != null) {
                                                panelTile.updateNeighborCells(above);
                                            }
                                            if (below != null) {
                                                panelTile.updateNeighborCells(below);
                                            }
                                        }
                                    }
                                    handled = true;
                                } else if (itemPanelCellMap.containsKey(heldItem) && !panelTile.isCovered()) {
                                    PanelCellPos placementPos = posInPanelCell;
                                    if (placementPos.getIPanelCell() != null) {
                                        placementPos = posInPanelCell.offset(panelTile.getSideFromDirection(blockHitResult.m_82434_()));
                                    }
                                    if (placementPos != null && placementPos.getIPanelCell() == null && !panelTile.checkCellForPistonExtension(placementPos)) {
                                        try {
                                            Object panelCell;
                                            Object obj = panelCell = itemPanelCellMap.get(heldItem).getConstructors()[0].newInstance(new Object[0]);
                                            if (obj instanceof IPanelCell) {
                                                Side cellFacing;
                                                IPanelCell cell = (IPanelCell)obj;
                                                boolean placementOK = true;
                                                Side rotationLock = RotationLock.getServerRotationLock(player);
                                                Side side = cellFacing = rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing(player, cell.canPlaceVertical())) : rotationLock;
                                                if (cell.needsSolidBase()) {
                                                    Side attachingSideRel;
                                                    Side attachingSideDir = panelTile.getSideFromDirection(blockHitResult.m_82434_()).getOpposite();
                                                    Side side2 = attachingSideRel = attachingSideDir == Side.TOP || attachingSideDir == Side.BOTTOM ? attachingSideDir : Side.FRONT;
                                                    if (!(posInPanelCell.equals(placementPos) || posInPanelCell.getIPanelCell() != null && posInPanelCell.getIPanelCell().isPushable() && posInPanelCell.getIPanelCell().canAttachToBaseOnSide(attachingSideRel))) {
                                                        placementOK = false;
                                                    } else {
                                                        cell.setBaseSide(attachingSideRel);
                                                        if (attachingSideRel == Side.FRONT) {
                                                            cellFacing = attachingSideDir;
                                                        }
                                                    }
                                                }
                                                if (placementOK) {
                                                    placementPos.getPanelTile().addCell(placementPos, cell, cellFacing, player);
                                                    if (!player.m_7500_()) {
                                                        player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                                                    }
                                                }
                                            }
                                        }
                                        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                            TinyRedstone.LOGGER.error((Object)e);
                                        }
                                    }
                                    handled = true;
                                } else if (panelTile.isOverflown()) {
                                    if (world.f_46443_) {
                                        PanelCrashGUI.open(panelTile);
                                    }
                                    handled = true;
                                }
                            }
                        }
                        panelTile.flagSync();
                        if (!world.f_46443_) {
                            panelTile.m_6596_();
                        }
                        panelTile.updateOutputs();
                    }
                    catch (Exception e) {
                        panelTile.handleCrash(e);
                    }
                }
            }
        }
        if (handled) {
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, world, pos, player, hand, blockHitResult);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        int ll = 0;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            ll = panelTile.getLightOutput();
        }
        return Math.min(ll, world.m_7469_());
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity te;
        Item heldItem = player.m_21205_().m_41720_();
        if ((heldItem == Registration.REDSTONE_WRENCH.get() || itemPanelCellMap.containsKey(heldItem) || itemPanelCoverMap.containsKey(heldItem)) && (te = world.m_7702_(pos)) instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            try {
                if (panelTile.isCovered()) {
                    this.removeCover(panelTile, player);
                    panelTile.flagLightUpdate = true;
                } else if (heldItem == Registration.REDSTONE_WRENCH.get() && player.m_6047_()) {
                    if (world.m_5776_()) {
                        ClearPanelGUI.open(panelTile);
                    }
                } else {
                    BlockHitResult result = ((RedstoneWrench)Registration.REDSTONE_WRENCH.get()).getHitResult(world, player);
                    PanelCellPos panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), result);
                    if (panelCellPos != null && panelCellPos.getIPanelCell() != null) {
                        this.removeCell(panelCellPos, player);
                    }
                }
            }
            catch (Exception e) {
                panelTile.handleCrash(e);
            }
        }
    }

    protected void removeCell(PanelCellPos cellPos, @Nullable Player player) {
        if (cellPos.getIPanelCell() != null) {
            PanelTile panelTile = cellPos.getPanelTile();
            Level world = panelTile.m_58904_();
            BlockPos pos = panelTile.m_58899_();
            if (player == null || !player.m_7500_()) {
                Item item = panelCellItemMap.get(cellPos.getIPanelCell().getClass());
                ItemStack itemStack = new ItemStack((ItemLike)item);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), itemStack);
                world.m_7967_((Entity)itemEntity);
                if (player != null) {
                    itemEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                }
            }
            panelTile.removeCell(cellPos);
        }
    }

    private void removeCover(PanelTile panelTile, Player player) {
        if (panelTile.isCovered()) {
            Level world = panelTile.m_58904_();
            BlockPos pos = panelTile.m_58899_();
            if (!player.m_7500_()) {
                Item item = panelCoverItemMap.get(panelTile.panelCover.getClass());
                ItemStack itemStack = new ItemStack((ItemLike)item);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), itemStack);
                world.m_7967_((Entity)itemEntity);
                itemEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
            panelTile.panelCover = null;
            panelTile.flagSync();
        }
    }

    public static void registerPanelCell(Class<? extends IPanelCell> iPanelCellClass, Item correspondingItem) {
        itemPanelCellMap.put(correspondingItem, iPanelCellClass);
        panelCellItemMap.put(iPanelCellClass, correspondingItem);
    }

    public static void registerPanelCover(Class<? extends IPanelCover> iPanelCellCover, Item correspondingItem) {
        itemPanelCoverMap.put(correspondingItem, iPanelCellCover);
        panelCoverItemMap.put(iPanelCellCover, correspondingItem);
    }

    public static Item getPanelCellItemFromClass(Class<? extends IPanelCell> iPanelCellClass) {
        return panelCellItemMap.get(iPanelCellClass);
    }

    public static Class<? extends IPanelCell> getPanelCellClassFromItem(Item item) {
        return itemPanelCellMap.get(item);
    }

    public static boolean isPanelCellItem(Item item) {
        return itemPanelCellMap.containsKey(item);
    }

    static {
        BASE.put(Direction.UP, Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        BASE.put(Direction.DOWN, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        BASE.put(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
        BASE.put(Direction.EAST, Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        BASE.put(Direction.SOUTH, Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
        BASE.put(Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
        itemPanelCellMap = new HashMap<Item, Class<? extends IPanelCell>>();
        panelCellItemMap = new HashMap<Class<? extends IPanelCell>, Item>();
        itemPanelCoverMap = new HashMap<Item, Class<? extends IPanelCover>>();
        panelCoverItemMap = new HashMap<Class<? extends IPanelCover>, Item>();
    }
}

