/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import javax.annotation.CheckForNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PanelCellPos {
    private final int row;
    private final int column;
    private final int level;
    private Integer index = null;
    private final PanelTile panelTile;

    protected PanelCellPos(PanelTile panelTile, int row, int column, int level) {
        this.row = row;
        this.column = column;
        this.level = level;
        this.panelTile = panelTile;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLevel() {
        return this.level;
    }

    public int getIndex() {
        if (this.index == null) {
            this.index = this.level * 64 + this.row * 8 + this.column;
        }
        return this.index;
    }

    public PanelTile getPanelTile() {
        return this.panelTile;
    }

    public static PanelCellPos fromCoordinates(PanelTile panelTile, double x, double y, double z) {
        int row = Math.round((float)(x * 8.0) - 0.5f);
        int cell = Math.round((float)(z * 8.0) - 0.5f);
        int level = Math.round((float)(y * 8.0) - 0.5f) - 1;
        if (row >= 0 && row < 8 && cell >= 0 && cell < 8 && level >= 0 && level < 7) {
            return new PanelCellPos(panelTile, row, cell, level);
        }
        return null;
    }

    public static PanelCellPos fromHitVec(PanelTile panelTile, Direction panelFacing, BlockHitResult result) {
        double relZ;
        double relY;
        double relX;
        BlockPos pos = panelTile.m_58899_();
        Direction rayTraceDirection = result.m_82434_().m_122424_();
        Vec3 hitVec = result.m_82450_().m_82520_((double)rayTraceDirection.m_122429_() * 0.001, (double)rayTraceDirection.m_122430_() * 0.001, (double)rayTraceDirection.m_122431_() * 0.001);
        if (panelFacing == Direction.NORTH) {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relY = hitVec.f_82481_ - (double)pos.m_123343_();
            relZ = 1.0 - (hitVec.f_82480_ - (double)pos.m_123342_());
        } else if (panelFacing == Direction.EAST) {
            relX = hitVec.f_82480_ - (double)pos.m_123342_();
            relY = 1.0 - (hitVec.f_82479_ - (double)pos.m_123341_());
            relZ = hitVec.f_82481_ - (double)pos.m_123343_();
        } else if (panelFacing == Direction.SOUTH) {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relY = 1.0 - (hitVec.f_82481_ - (double)pos.m_123343_());
            relZ = hitVec.f_82480_ - (double)pos.m_123342_();
        } else if (panelFacing == Direction.WEST) {
            relX = 1.0 - (hitVec.f_82480_ - (double)pos.m_123342_());
            relY = hitVec.f_82479_ - (double)pos.m_123341_();
            relZ = hitVec.f_82481_ - (double)pos.m_123343_();
        } else if (panelFacing == Direction.UP) {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relY = 1.0 - (hitVec.f_82480_ - (double)pos.m_123342_());
            relZ = 1.0 - (hitVec.f_82481_ - (double)pos.m_123343_());
        } else {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relZ = hitVec.f_82481_ - (double)pos.m_123343_();
            relY = hitVec.f_82480_ - (double)pos.m_123342_();
        }
        if (relY < 0.125 && relY > 0.0625) {
            relY += (double)0.002f;
        }
        return PanelCellPos.fromCoordinates(panelTile, relX, relY, relZ);
    }

    public static PanelCellPos fromIndex(PanelTile panelTile, Integer cellIndex) {
        int level = Math.round(cellIndex.floatValue() / 64.0f - 0.5f);
        int row = Math.round(cellIndex.floatValue() % 64.0f / 8.0f - 0.5f);
        int cell = cellIndex % 8;
        return new PanelCellPos(panelTile, row, cell, level);
    }

    public static PanelCellPos fromRowColumn(PanelTile panelTile, int row, int column, int level) {
        return new PanelCellPos(panelTile, row, column, level);
    }

    @CheckForNull
    public PanelCellPos offset(Side side) {
        PanelCellPos cellPos = null;
        if (side == Side.FRONT) {
            if (this.column > 0) {
                cellPos = new PanelCellPos(this.panelTile, this.row, this.column - 1, this.level);
            }
        } else if (side == Side.BACK) {
            if (this.column < 7) {
                cellPos = new PanelCellPos(this.panelTile, this.row, this.column + 1, this.level);
            }
        } else if (side == Side.LEFT) {
            if (this.row > 0) {
                cellPos = new PanelCellPos(this.panelTile, this.row - 1, this.column, this.level);
            }
        } else if (side == Side.RIGHT) {
            if (this.row < 7) {
                cellPos = new PanelCellPos(this.panelTile, this.row + 1, this.column, this.level);
            }
        } else if (side == Side.TOP) {
            if (this.level < 6) {
                cellPos = new PanelCellPos(this.panelTile, this.row, this.column, this.level + 1);
            }
        } else if (side == Side.BOTTOM && this.level > 0) {
            cellPos = new PanelCellPos(this.panelTile, this.row, this.column, this.level - 1);
        }
        if (cellPos == null && side != Side.TOP && side != Side.BOTTOM) {
            PanelTile panelTile2;
            Direction direction = this.panelTile.getDirectionFromSide(side);
            BlockEntity te = this.panelTile.m_58904_().m_7702_(this.panelTile.m_58899_().m_142300_(direction));
            if (te instanceof PanelTile && (panelTile2 = (PanelTile)te).m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == this.panelTile.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)) {
                int neighborLevel;
                int neighborColumn;
                int neighborRow;
                if (side == Side.FRONT || side == Side.BACK) {
                    neighborRow = this.row;
                    neighborColumn = (this.column - 7) * -1;
                    neighborLevel = this.level;
                } else {
                    neighborRow = (this.row - 7) * -1;
                    neighborColumn = this.column;
                    neighborLevel = this.level;
                }
                cellPos = new PanelCellPos(panelTile2, neighborRow, neighborColumn, neighborLevel);
            }
        }
        return cellPos;
    }

    @CheckForNull
    public IPanelCell getIPanelCell() {
        return this.panelTile.getIPanelCell(this);
    }

    @CheckForNull
    public Side getCellFacing() {
        return this.panelTile.getCellFacing(this);
    }

    @CheckForNull
    public Side getBaseDirection() {
        IPanelCell thisCell = this.getIPanelCell();
        if (thisCell == null || thisCell.getBaseSide() == null) {
            return null;
        }
        return thisCell.getBaseSide() == Side.FRONT ? this.getCellFacing() : thisCell.getBaseSide();
    }

    @CheckForNull
    public PanelCellNeighbor getNeighbor(Side side) {
        Side cellFacing = this.getCellFacing();
        return this.getNeighbor(side, cellFacing);
    }

    public PanelCellNeighbor getNeighbor(Side side, Side cellFacing) {
        Side towardPanelSide = cellFacing == Side.FRONT ? side : ((side == Side.TOP || side == Side.BOTTOM) && cellFacing != Side.TOP && cellFacing != Side.BOTTOM ? side : (cellFacing == Side.BACK ? side.getOpposite() : (cellFacing == Side.RIGHT ? side.rotateYCW() : (cellFacing == Side.LEFT ? side.rotateYCCW() : (cellFacing == Side.TOP ? side.rotateBack() : side.rotateForward())))));
        PanelCellPos neighborPos = this.offset(towardPanelSide);
        if (neighborPos != null) {
            IPanelCell neighborCell = neighborPos.getIPanelCell();
            if (neighborCell != null) {
                Side neighborSide = neighborPos.getPanelTile().getPanelCellSide(neighborPos, towardPanelSide.getOpposite());
                return new PanelCellNeighbor(neighborPos, neighborCell, neighborSide, towardPanelSide);
            }
            if (neighborPos.getPanelTile().checkCellForPistonExtension(neighborPos)) {
                return new PanelCellNeighbor(neighborPos, null, null, side);
            }
        } else if (towardPanelSide != Side.BOTTOM) {
            BlockPos blockPos = this.panelTile.m_58899_().m_142300_(this.panelTile.getDirectionFromSide(towardPanelSide));
            return new PanelCellNeighbor(this.panelTile, blockPos, towardPanelSide);
        }
        return null;
    }
}

