/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellGhostPos;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PanelTileRenderer
implements BlockEntityRenderer<PanelTile> {
    public static ResourceLocation TEXTURE = new ResourceLocation("tinyredstone", "block/redstone_panel");
    public static ResourceLocation TEXTURE_CRASHED = new ResourceLocation("tinyredstone", "block/redstone_panel_crashed");
    private float scale = 0.125f;
    private float t2X = 0.0f;
    private float t2Y = -1.0f;
    private float t2Z = 0.0f;
    private float rotation1 = 270.0f;
    private double cellSize = 0.125;

    public PanelTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PanelTile tileEntity, float p_112308_, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.m_85836_();
        switch ((Direction)tileEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)) {
            case UP: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                matrixStack.m_85837_(0.0, -1.0, -1.0);
                break;
            }
            case NORTH: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                matrixStack.m_85837_(0.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                matrixStack.m_85837_(0.0, -1.0, 0.0);
                break;
            }
            case SOUTH: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                matrixStack.m_85837_(0.0, -1.0, 0.0);
                break;
            }
            case WEST: {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
                matrixStack.m_85837_(-1.0, 0.0, 0.0);
            }
        }
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        int color = tileEntity.getColor();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(270.0f));
        matrixStack.m_85837_(0.0, -1.0, 0.125);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, -0.125, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color, 1.0f);
        matrixStack.m_85849_();
        if (tileEntity.isCovered()) {
            matrixStack.m_85836_();
            tileEntity.panelCover.render(matrixStack, buffer, combinedLight, combinedOverlay, tileEntity.getColor());
            matrixStack.m_85849_();
        } else {
            List<PanelCellPos> positions = tileEntity.getCellPositions();
            for (PanelCellPos pos : positions) {
                IPanelCell panelCell = pos.getIPanelCell();
                if (panelCell == null) continue;
                this.renderCell(matrixStack, pos, buffer, tileEntity.isCrashed() ? 0 : combinedLight, combinedOverlay, tileEntity.isCrashed() ? 0.5f : 1.0f);
            }
            if (tileEntity.panelCellGhostPos != null) {
                this.renderCell(matrixStack, tileEntity.panelCellGhostPos, buffer, combinedLight, combinedOverlay, 0.5f);
            }
        }
        if (tileEntity.isCrashed() || tileEntity.isOverflown()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.126, 1.0);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(this.rotation1));
            sprite = RenderHelper.getSprite(TEXTURE_CRASHED);
            RenderHelper.drawRectangle(buffer.m_6299_(Minecraft.m_91085_() ? RenderType.m_110451_() : RenderType.m_110466_()), matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, 0.9f);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private void renderCell(PoseStack matrixStack, PanelCellPos pos, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        alpha = Minecraft.m_91085_() ? 1.0f : alpha;
        matrixStack.m_85836_();
        matrixStack.m_85837_(this.cellSize * (double)pos.getRow(), 0.125 + (double)pos.getLevel() * 0.125, this.cellSize * (double)pos.getColumn());
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(this.rotation1));
        Side facing = pos.getCellFacing();
        if (facing == Side.LEFT) {
            matrixStack.m_85837_(0.0, -this.cellSize, 0.0);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        } else if (facing == Side.BACK) {
            matrixStack.m_85837_(this.cellSize, -this.cellSize, 0.0);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        } else if (facing == Side.RIGHT) {
            matrixStack.m_85837_(this.cellSize, 0.0, 0.0);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(270.0f));
        } else if (pos.getCellFacing() == Side.BOTTOM) {
            matrixStack.m_85837_(0.0, -this.cellSize, 0.0);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        } else if (pos.getCellFacing() == Side.TOP) {
            matrixStack.m_85837_(0.0, 0.0, this.cellSize);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        }
        matrixStack.m_85841_(this.scale, this.scale, this.scale);
        matrixStack.m_85837_((double)this.t2X, (double)this.t2Y, (double)this.t2Z);
        pos.getIPanelCell().render(matrixStack, buffer, combinedLight, combinedOverlay, alpha);
        matrixStack.m_85849_();
    }

    @CheckForNull
    public static PanelCellGhostPos getPlayerLookingAtCell(PanelTile panelTile) {
        HitResult lookingAt;
        Level world = panelTile.m_58904_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && PanelBlock.isPanelCellItem(player.m_21205_().m_41720_()) && (lookingAt = Minecraft.m_91087_().f_91077_) != null && lookingAt.m_6662_() == HitResult.Type.BLOCK) {
            PosInPanelCell cellPos1;
            BlockHitResult blockHitResult = (BlockHitResult)lookingAt;
            Vec3 lookVector = Minecraft.m_91087_().f_91077_.m_82450_();
            BlockPos blockPos = new BlockPos(lookVector);
            BlockEntity te = world.m_7702_(blockPos);
            if (te == panelTile && (cellPos1 = PosInPanelCell.fromHitVec(panelTile, panelTile.m_58899_(), blockHitResult)) != null) {
                PanelCellPos cellPos = cellPos1;
                if (cellPos.getIPanelCell() != null && (!cellPos.getIPanelCell().hasActivation() || player.m_6047_())) {
                    cellPos = cellPos.offset(panelTile.getSideFromDirection(blockHitResult.m_82434_()));
                }
                if (cellPos != null && cellPos.getIPanelCell() == null) {
                    try {
                        Side cellFacing;
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(player.m_21205_().m_41720_()).getConstructors()[0].newInstance(new Object[0]);
                        Side rotationLock = RotationLock.getRotationLock();
                        Side side = cellFacing = rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing((Player)player, panelCell.canPlaceVertical())) : rotationLock;
                        if (panelCell.needsSolidBase()) {
                            Side attachingSideRel;
                            Side attachingSideDir = panelTile.getSideFromDirection(blockHitResult.m_82434_()).getOpposite();
                            Side side2 = attachingSideRel = attachingSideDir == Side.TOP || attachingSideDir == Side.BOTTOM ? attachingSideDir : Side.FRONT;
                            if (!(cellPos1.equals(cellPos) || cellPos1.getIPanelCell() != null && cellPos1.getIPanelCell().isPushable() && cellPos1.getIPanelCell().canAttachToBaseOnSide(attachingSideRel))) {
                                return null;
                            }
                            panelCell.setBaseSide(attachingSideRel);
                            if (attachingSideRel == Side.FRONT) {
                                cellFacing = attachingSideDir;
                            }
                        }
                        panelCell.onPlace(cellPos, (Player)player);
                        return PanelCellGhostPos.fromPosInPanelCell(cellPos, panelCell, cellFacing);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to draw ghost cell: " + e.getMessage());
                    }
                }
            }
        }
        return null;
    }
}

