/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PosInPanelCell
extends PanelCellPos {
    private final double x;
    private final double z;
    private final double y;

    protected PosInPanelCell(PanelTile panelTile, int row, int level, int cell, double x, double y, double z) {
        super(panelTile, row, cell, level);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public PanelCellSegment getSegment() {
        int segmentRow = Math.round((float)(this.x * 3.0) - 0.5f);
        int segmentColumn = Math.round((float)(this.z * 3.0) - 0.5f);
        if (segmentRow == 0) {
            switch (segmentColumn) {
                case 0: {
                    return PanelCellSegment.FRONT_RIGHT;
                }
                case 1: {
                    return PanelCellSegment.FRONT;
                }
                case 2: {
                    return PanelCellSegment.FRONT_LEFT;
                }
            }
        } else if (segmentRow == 1) {
            switch (segmentColumn) {
                case 0: {
                    return PanelCellSegment.RIGHT;
                }
                case 1: {
                    return PanelCellSegment.CENTER;
                }
                case 2: {
                    return PanelCellSegment.LEFT;
                }
            }
        } else if (segmentRow == 2) {
            switch (segmentColumn) {
                case 0: {
                    return PanelCellSegment.BACK_RIGHT;
                }
                case 1: {
                    return PanelCellSegment.BACK;
                }
                case 2: {
                    return PanelCellSegment.BACK_LEFT;
                }
            }
        }
        return null;
    }

    public static PosInPanelCell fromCoordinates(PanelTile panelTile, PanelCellPos panelCellPos, double x, double y, double z) {
        if (x >= 0.0 && x <= 1.0 && z >= 0.0 && z <= 1.0) {
            double rotatedZ;
            double rotatedX;
            Side direction = panelCellPos.getCellFacing();
            if (direction == Side.FRONT) {
                rotatedX = z;
                rotatedZ = 1.0 - x;
            } else if (direction == Side.RIGHT) {
                rotatedX = 1.0 - x;
                rotatedZ = 1.0 - z;
            } else if (direction == Side.BACK) {
                rotatedX = 1.0 - z;
                rotatedZ = x;
            } else {
                rotatedX = x;
                rotatedZ = z;
            }
            return new PosInPanelCell(panelTile, panelCellPos.getRow(), panelCellPos.getLevel(), panelCellPos.getColumn(), rotatedX, y, rotatedZ);
        }
        return null;
    }

    public static PosInPanelCell fromHitVec(PanelTile panelTile, BlockPos pos, BlockHitResult result) {
        PanelCellPos panelCellPos;
        double relZ;
        double relY;
        double relX;
        Direction panelFacing = (Direction)panelTile.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Direction rayTraceDirection = result.m_82434_().m_122424_();
        Vec3 hitVec = result.m_82450_().m_82520_((double)rayTraceDirection.m_122429_() * 0.001, (double)rayTraceDirection.m_122430_() * 0.001, (double)rayTraceDirection.m_122431_() * 0.001);
        if (panelFacing == Direction.NORTH) {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relY = hitVec.f_82481_ - (double)pos.m_123343_();
            relZ = 1.0 - (hitVec.f_82480_ - (double)pos.m_123342_());
        } else if (panelFacing == Direction.EAST) {
            relX = hitVec.f_82480_ - (double)pos.m_123342_();
            relY = 1.0 - (hitVec.f_82479_ - (double)pos.m_123341_());
            relZ = hitVec.f_82481_ - (double)pos.m_123343_();
        } else if (panelFacing == Direction.SOUTH) {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relY = 1.0 - (hitVec.f_82481_ - (double)pos.m_123343_());
            relZ = hitVec.f_82480_ - (double)pos.m_123342_();
        } else if (panelFacing == Direction.WEST) {
            relX = 1.0 - (hitVec.f_82480_ - (double)pos.m_123342_());
            relY = hitVec.f_82479_ - (double)pos.m_123341_();
            relZ = hitVec.f_82481_ - (double)pos.m_123343_();
        } else if (panelFacing == Direction.UP) {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relY = 1.0 - (hitVec.f_82480_ - (double)pos.m_123342_());
            relZ = 1.0 - (hitVec.f_82481_ - (double)pos.m_123343_());
        } else {
            relX = hitVec.f_82479_ - (double)pos.m_123341_();
            relZ = hitVec.f_82481_ - (double)pos.m_123343_();
            relY = hitVec.f_82480_ - (double)pos.m_123342_();
        }
        if (relY < 0.125 && relY > 0.0625) {
            relY += (double)0.002f;
        }
        if ((panelCellPos = PanelCellPos.fromCoordinates(panelTile, relX, relY, relZ)) == null) {
            return null;
        }
        relX = (relX - (double)panelCellPos.getRow() / 8.0) * 8.0;
        relY = (relY - 0.125 - (double)panelCellPos.getLevel() / 8.0) * 8.0;
        relZ = (relZ - (double)panelCellPos.getColumn() / 8.0) * 8.0;
        return PosInPanelCell.fromCoordinates(panelTile, panelCellPos, relX, relY, relZ);
    }
}

