/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;

public class RenderHelper {
    private static int[] textureDiffusedColors = new int[]{0xF9FFFE, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150, 11546150, 0x1D1D21};

    public static void drawRectangle(VertexConsumer builder, PoseStack matrixStack, float x1, float x2, float y1, float y2, TextureAtlasSprite sprite, int combinedLight, float alpha) {
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite, combinedLight, -1, alpha);
    }

    public static void drawRectangle(VertexConsumer builder, PoseStack matrixStack, float x1, float x2, float y1, float y2, TextureAtlasSprite sprite, int combinedLight, int color, float alpha) {
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), combinedLight, color, alpha);
    }

    public static void drawRectangle(VertexConsumer builder, PoseStack matrixStack, float x1, float x2, float y1, float y2, float u0, float u1, float v0, float v1, int combinedLight, int color, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        RenderHelper.add(builder, matrix4f, x1, y1, 0.0f, u0, v0, combinedLight, color, alpha);
        RenderHelper.add(builder, matrix4f, x2, y1, 0.0f, u1, v0, combinedLight, color, alpha);
        RenderHelper.add(builder, matrix4f, x2, y2, 0.0f, u1, v1, combinedLight, color, alpha);
        RenderHelper.add(builder, matrix4f, x1, y2, 0.0f, u0, v1, combinedLight, color, alpha);
    }

    public static void drawTriangle(VertexConsumer builder, PoseStack matrixStack, float x1, float y1, float x2, float y2, float x3, float y3, int color, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        RenderHelper.add(builder, matrix4f, x1, y1, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x2, y2, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x3, y3, 0.0f, color, alpha);
    }

    public static void drawTriangleRectangle(VertexConsumer builder, PoseStack matrixStack, float x1, float x2, float y1, float y2, int color, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        RenderHelper.add(builder, matrix4f, x1, y1, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x2, y2, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x2, y1, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x1, y1, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x1, y2, 0.0f, color, alpha);
        RenderHelper.add(builder, matrix4f, x2, y2, 0.0f, color, alpha);
    }

    public static void add(VertexConsumer renderer, Matrix4f matrix4f, float x, float y, float z, int color, float alpha) {
        renderer.m_85982_(matrix4f, x, y, z).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, (int)(alpha * 255.0f)).m_5752_();
    }

    public static void add(VertexConsumer renderer, Matrix4f matrix4f, float x, float y, float z, float u, float v, int combinedLightIn, int color, float alpha) {
        renderer.m_85982_(matrix4f, x, y, z).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, (int)(alpha * 255.0f)).m_7421_(u, v).m_85969_(combinedLightIn).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static int getColor(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int getTextureDiffusedColor(DyeColor dyeColor) {
        return textureDiffusedColors[dyeColor.m_41060_()];
    }

    public static int getRed(int packedColor) {
        return packedColor >> 16 & 0xFF;
    }

    public static int getGreen(int packedColor) {
        return packedColor >> 8 & 0xFF;
    }

    public static int getBlue(int packedColor) {
        return packedColor & 0xFF;
    }

    public static int getAlpha(int packedColor) {
        return packedColor >>> 24;
    }

    public static TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(resourceLocation);
    }
}

