/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class Piston
implements IPanelCell {
    public static ResourceLocation TEXTURE_PISTON_SIDE = new ResourceLocation("minecraft", "block/piston_side");
    public static ResourceLocation TEXTURE_PISTON_TOP = new ResourceLocation("minecraft", "block/piston_top");
    public static ResourceLocation TEXTURE_PISTON_BOTTOM = new ResourceLocation("minecraft", "block/piston_bottom");
    public static ResourceLocation TEXTURE_PISTON_INNER = new ResourceLocation("minecraft", "block/piston_inner");
    protected boolean extended = false;
    protected int changePending = -1;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite_bottom = RenderHelper.getSprite(TEXTURE_PISTON_BOTTOM);
        TextureAtlasSprite sprite_inner = RenderHelper.getSprite(TEXTURE_PISTON_INNER);
        TextureAtlasSprite sprite_inner_top = RenderHelper.getSprite(TEXTURE_PISTON_TOP);
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite_top = this.getSprite_top();
        boolean renderExtended = this.extended && this.changePending == -1 || !this.extended && this.changePending != -1;
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-1.0, -1.0, 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(-1.0, 0.0, 1.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStack.m_85837_(-1.0, 0.0, 0.0);
        this.drawSide(matrixStack, builder, combinedLight, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_bottom, combinedLight, alpha);
        if (renderExtended) {
            matrixStack.m_85837_(0.0, 0.0, -1.75);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_inner_top, combinedLight, alpha);
        }
        matrixStack.m_85849_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        matrixStack.m_85837_(0.0, -1.0, 1.0);
        if (renderExtended) {
            matrixStack.m_85837_(0.0, 0.0, -0.25);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_inner, combinedLight, alpha);
            matrixStack.m_85837_(0.0, 0.0, 1.25);
        }
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_top, combinedLight, alpha);
    }

    private void drawSide(PoseStack matrixStack, VertexConsumer builder, int combinedLight, float alpha) {
        boolean renderExtended = this.extended && this.changePending == -1 || !this.extended && this.changePending != -1;
        TextureAtlasSprite sprite_side_bottom = RenderHelper.getSprite(TEXTURE_PISTON_SIDE);
        float bu0 = sprite_side_bottom.m_118409_();
        float bu1 = sprite_side_bottom.m_118410_();
        float bv0 = sprite_side_bottom.m_118411_();
        float bv1 = sprite_side_bottom.m_118412_();
        matrixStack.m_85836_();
        if (renderExtended) {
            matrixStack.m_85841_(1.0f, 0.75f, 1.0f);
            bv0 += (bv1 - bv0) * 0.25f;
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrixStack.m_85837_(0.0, -1.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, bu0, bu1, bv0, bv1, combinedLight, -1, alpha);
        matrixStack.m_85849_();
        if (renderExtended) {
            float tu0 = bu0;
            float tu1 = bu1;
            float tv0 = sprite_side_bottom.m_118411_();
            float tv1 = tv0 + (bv1 - tv0) * 0.25f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 1.75, 0.0);
            matrixStack.m_85841_(1.0f, 0.25f, 1.0f);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, tu0, tu1, tv0, tv1, combinedLight, -1, alpha);
            matrixStack.m_85841_(0.25f, 4.0f, 1.0f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            matrixStack.m_85837_(-1.0, -2.5, -0.375);
            RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, tu0, tu1, tv0, tv1, combinedLight, -1, alpha);
            matrixStack.m_85849_();
        }
    }

    protected TextureAtlasSprite getSprite_top() {
        return RenderHelper.getSprite(TEXTURE_PISTON_TOP);
    }

    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        boolean extend;
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        boolean bl = extend = !(cellPos.getLevel() <= 0 && cellPos.getCellFacing() == Side.TOP || !(rightNeighbor != null && rightNeighbor.getWeakRsOutput() > 0 || frontNeighbor != null && frontNeighbor.getWeakRsOutput() > 0 || leftNeighbor != null && leftNeighbor.getWeakRsOutput() > 0 || topNeighbor != null && topNeighbor.getWeakRsOutput() > 0) && (bottomNeighbor == null || bottomNeighbor.getWeakRsOutput() <= 0) || backNeighbor != null && !backNeighbor.isOnPanel() || !this.extended && backNeighbor != null && (backNeighbor.getNeighborIPanelCell() == null || !backNeighbor.isPushable() && !backNeighbor.getNeighborIPanelCell().needsSolidBase()));
        if (extend != this.extended) {
            this.extended = extend;
            this.changePending = 2;
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return 0;
    }

    @Override
    public boolean isPushable() {
        return !this.extended;
    }

    @Override
    public boolean canPlaceVertical() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changePending < 0) {
            return false;
        }
        if (this.changePending > 0) {
            --this.changePending;
            return false;
        }
        --this.changePending;
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("extended", this.extended);
        nbt.m_128405_("changePending", this.changePending);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.extended = compoundNBT.m_128471_("extended");
        this.changePending = compoundNBT.m_128451_("changePending");
    }
}

