/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TransparentBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class RedstoneDust
implements IPanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_REDSTONE_DUST_ON = new ResourceLocation("tinyredstone", "block/panel_redstone_dust_on");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_OFF = new ResourceLocation("tinyredstone", "block/panel_redstone_dust_off");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_SEGMENT_ON = new ResourceLocation("tinyredstone", "block/panel_redstone_segment_on");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_SEGMENT_OFF = new ResourceLocation("tinyredstone", "block/panel_redstone_segment_off");
    public static ResourceLocation TEXTURE_REDSTONE_DUST = new ResourceLocation("tinyredstone", "block/panel_redstone_dust");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_SEGMENT = new ResourceLocation("tinyredstone", "block/panel_redstone_segment");
    private static final float s6 = 0.375f;
    private static final float s7 = 0.4375f;
    private static final float s9 = 0.5625f;
    private static final float s10 = 0.625f;
    protected int signalStrength = 0;
    protected boolean frontEnabled = true;
    protected boolean rightEnabled = false;
    protected boolean backEnabled = true;
    protected boolean leftEnabled = false;
    protected List<Side> crawlUpSide = new ArrayList<Side>();
    private float red = 0.25f;
    private float green = 0.0f;
    private float blue = 0.0f;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        this.red = this.signalStrength == 0 ? 0.25f : 0.3f + 0.04f * (float)this.signalStrength;
        int color = RenderHelper.getColor(255, Math.round(this.red * 255.0f), 0, 0);
        TextureAtlasSprite sprite_redstone_dust = RenderHelper.getSprite(TEXTURE_REDSTONE_DUST);
        TextureAtlasSprite sprite_redstone_segment = RenderHelper.getSprite(TEXTURE_REDSTONE_DUST_SEGMENT);
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        matrixStack.m_85837_(0.0, 0.0, 0.01);
        RenderHelper.drawRectangle(builder, matrixStack, 0.365f, 0.635f, 0.365f, 0.635f, sprite_redstone_dust, combinedLight, color, alpha);
        if (this.rightEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, 0.625f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.RIGHT)) {
                matrixStack.m_85836_();
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                matrixStack.m_85837_(0.0, 0.0, 1.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.m_85849_();
            }
        }
        if (this.leftEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 0.375f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.LEFT)) {
                matrixStack.m_85836_();
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                matrixStack.m_85837_(-1.0, 0.0, 0.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        if (this.frontEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, 0.625f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.FRONT)) {
                matrixStack.m_85836_();
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                matrixStack.m_85837_(0.0, 0.0, 1.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.m_85849_();
            }
        }
        if (this.backEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 0.375f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.BACK)) {
                matrixStack.m_85836_();
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                matrixStack.m_85837_(-1.0, 0.0, 0.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.m_85849_();
            }
        }
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        int signal;
        PanelCellNeighbor bottomNeighbor;
        int front = 0;
        int right = 0;
        int back = 0;
        int left = 0;
        int top = 0;
        int bottom = 0;
        this.crawlUpSide.clear();
        PanelCellPos above = null;
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        if (topNeighbor != null) {
            int n = top = topNeighbor.canConnectRedstone() ? topNeighbor.getWeakRsOutput() : topNeighbor.getStrongRsOutput();
            if (topNeighbor.getNeighborIPanelCell() instanceof TransparentBlock) {
                above = cellPos.offset(Side.TOP);
            }
        } else {
            above = cellPos.offset(Side.TOP);
        }
        if ((bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM)) != null) {
            bottom = bottomNeighbor.getStrongRsOutput();
        }
        PanelCellPos below = cellPos.offset(Side.BOTTOM);
        if (this.frontEnabled) {
            front = this.checkSideInput(cellPos, Side.FRONT, above, below);
        }
        if (this.rightEnabled) {
            right = this.checkSideInput(cellPos, Side.RIGHT, above, below);
        }
        if (this.backEnabled) {
            back = this.checkSideInput(cellPos, Side.BACK, above, below);
        }
        if (this.leftEnabled) {
            left = this.checkSideInput(cellPos, Side.LEFT, above, below);
        }
        if ((signal = Math.max(Math.max(Math.max(Math.max(front, right), Math.max(back, left)), Math.max(top, bottom)), 0)) != this.signalStrength) {
            this.signalStrength = signal;
            return true;
        }
        return false;
    }

    protected int checkSideInput(PanelCellPos cellPos, Side side, PanelCellPos above, PanelCellPos below) {
        PanelCellNeighbor belowNeighbor;
        PanelCellNeighbor aboveNeighbor;
        PanelCellNeighbor neighbor = cellPos.getNeighbor(side);
        int input = 0;
        if (neighbor != null) {
            input = this.getNeighborOutput(neighbor);
        }
        if ((neighbor == null || !(neighbor.getNeighborIPanelCell() instanceof TransparentBlock)) && above != null && (aboveNeighbor = above.getNeighbor(side, cellPos.getCellFacing())) != null && aboveNeighbor.getNeighborIPanelCell() instanceof RedstoneDust) {
            input = Math.max(input, this.getNeighborOutput(aboveNeighbor));
        }
        if (below != null && (neighbor == null || neighbor.getNeighborIPanelCell() instanceof TransparentBlock) && (belowNeighbor = below.getNeighbor(side, cellPos.getCellFacing())) != null && belowNeighbor.getNeighborIPanelCell() instanceof RedstoneDust) {
            input = Math.max(input, this.getNeighborOutput(belowNeighbor));
            this.crawlUpSide.add(side);
        }
        return input;
    }

    protected int getNeighborOutput(PanelCellNeighbor neighbor) {
        int input;
        int s = neighbor.getStrongRsOutput();
        int w = neighbor.getWeakRsOutput();
        int n = input = neighbor.powerDrops() ? s - 1 : s;
        if (w > input && neighbor.canConnectRedstone()) {
            input = neighbor.getWeakRsOutput();
        }
        return input;
    }

    protected boolean sideEnabled(Side side) {
        return side == Side.FRONT && this.frontEnabled || side == Side.RIGHT && this.rightEnabled || side == Side.BACK && this.backEnabled || side == Side.LEFT && this.leftEnabled;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        if (this.sideEnabled(outputDirection) || outputDirection == Side.BOTTOM) {
            return Math.max(this.signalStrength, 0);
        }
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.getWeakRsOutput(outputDirection);
    }

    @Override
    public boolean powerDrops() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean canAttachToBaseOnSide(Side side) {
        return side == Side.BOTTOM;
    }

    @Override
    public Side getBaseSide() {
        return Side.BOTTOM;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        if (cellPos.getPanelTile().m_58904_().f_46443_) {
            return false;
        }
        if (segmentClicked == PanelCellSegment.FRONT) {
            this.frontEnabled = !this.frontEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.RIGHT) {
            this.rightEnabled = !this.rightEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.LEFT) {
            this.leftEnabled = !this.leftEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.BACK) {
            this.backEnabled = !this.backEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.CENTER) {
            if (!(this.frontEnabled && this.rightEnabled && this.backEnabled && this.leftEnabled)) {
                this.frontEnabled = true;
                this.rightEnabled = true;
                this.backEnabled = true;
                this.leftEnabled = true;
            } else {
                this.frontEnabled = false;
                this.rightEnabled = false;
                this.backEnabled = false;
                this.leftEnabled = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("strength", this.signalStrength);
        nbt.m_128379_("front", this.frontEnabled);
        nbt.m_128379_("right", this.rightEnabled);
        nbt.m_128379_("back", this.backEnabled);
        nbt.m_128379_("left", this.leftEnabled);
        StringJoiner crawlUpSides = new StringJoiner(",");
        for (Side side : this.crawlUpSide) {
            crawlUpSides.add(side.name());
        }
        nbt.m_128359_("crawlUpSides", crawlUpSides.toString());
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.signalStrength = compoundNBT.m_128451_("strength");
        this.frontEnabled = compoundNBT.m_128471_("front");
        this.rightEnabled = compoundNBT.m_128471_("right");
        this.backEnabled = compoundNBT.m_128471_("back");
        this.leftEnabled = compoundNBT.m_128471_("left");
        String crawlUpSides = compoundNBT.m_128461_("crawlUpSides");
        if (!crawlUpSides.equals("")) {
            for (String side : crawlUpSides.split(",")) {
                this.crawlUpSide.add(Side.valueOf(side));
            }
        }
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.signalStrength);
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return new PanelCellVoxelShape(new Vector3d(0.0, 0.0, 0.0), new Vector3d(1.0, 0.05, 1.0));
    }
}

