/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.compat.theoneprobe;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.compat.CompatHandler;
import com.dannyandson.tinyredstone.compat.theoneprobe.OverlayBlockInfo;
import java.util.function.Function;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PanelProvider
implements IBlockDisplayOverride,
Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    private IProbeConfig.ConfigMode redstoneMode;

    public ResourceLocation getID() {
        return new ResourceLocation("tinyredstone", "panel");
    }

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((IBlockDisplayOverride)this);
        theOneProbe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    private boolean show(ProbeMode probeMode, Player playerEntity) {
        switch ((Integer)Config.DISPLAY_MODE.get()) {
            case 0: {
                return probeMode == ProbeMode.DEBUG;
            }
            case 1: {
                break;
            }
            case 2: {
                if (probeMode != ProbeMode.NORMAL) break;
                return false;
            }
            case 3: {
                if (probeMode == ProbeMode.DEBUG) break;
                return CompatHandler.isMeasuringDevice(playerEntity.m_21205_().m_41720_());
            }
            case 4: {
                if (probeMode == ProbeMode.DEBUG) break;
                return CompatHandler.isTinyComponent(playerEntity.m_21205_().m_41720_());
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean overrideStandardInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData probeHitData) {
        BlockPos pos = probeHitData.getPos();
        BlockEntity tileEntity = world.m_7702_(pos);
        IProbeConfig config = mcjty.theoneprobe.config.Config.getRealConfig();
        BlockEntity blockEntity = tileEntity;
        if (blockEntity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)blockEntity;
            if (this.show(probeMode, playerEntity)) {
                IPanelCell panelCell;
                Block block;
                if (this.redstoneMode == null) {
                    this.redstoneMode = config.getShowRedstone();
                }
                config.showRedstone(IProbeConfig.ConfigMode.NOT);
                Block block2 = blockState.m_60734_();
                if (panelTile.isCovered() || !((block = block2) instanceof PanelBlock)) return false;
                PanelBlock panelBlock = (PanelBlock)block;
                BlockHitResult result = new BlockHitResult(probeHitData.getHitVec(), probeHitData.getSideHit(), pos, true);
                PanelCellPos panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_), result);
                if (panelCellPos == null || (panelCell = panelCellPos.getIPanelCell()) == null) return false;
                String modName = Tools.getModName((IForgeRegistryEntry)block2);
                Item item = panelBlock.getItemByIPanelCell(panelCell.getClass());
                ItemStack itemStack = item.m_7968_();
                if (Tools.show((ProbeMode)probeMode, (IProbeConfig.ConfigMode)config.getShowModName())) {
                    probeInfo.horizontal().item(itemStack).vertical().itemLabel(itemStack).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
                    return true;
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(itemStack).itemLabel(itemStack);
                }
                return true;
            }
        }
        if (this.redstoneMode == null) return false;
        config.showRedstone(this.redstoneMode);
        this.redstoneMode = null;
        return false;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData probeHitData) {
        BlockPos pos = probeHitData.getPos();
        BlockEntity tileEntity = world.m_7702_(pos);
        BlockEntity blockEntity = tileEntity;
        if (blockEntity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)blockEntity;
            if (this.show(probeMode, playerEntity)) {
                if (!panelTile.isCovered()) {
                    BlockHitResult rtr = new BlockHitResult(probeHitData.getHitVec(), probeHitData.getSideHit(), pos, true);
                    PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, rtr);
                    if (posInPanelCell != null) {
                        IPanelCell panelCell;
                        if (probeMode == ProbeMode.DEBUG) {
                            int cellIndex = posInPanelCell.getIndex();
                            PanelCellSegment segment = posInPanelCell.getSegment();
                            probeInfo.vertical((ILayoutStyle)new LayoutStyle().borderColor(Integer.valueOf(-12255420)).spacing(2)).text(CompoundText.createLabelInfo((String)"X: ", (Object)posInPanelCell.getX())).text(CompoundText.createLabelInfo((String)"Z: ", (Object)posInPanelCell.getZ())).text(CompoundText.createLabelInfo((String)"Y: ", (Object)posInPanelCell.getY())).text(CompoundText.createLabelInfo((String)"Row: ", (Object)posInPanelCell.getRow())).text(CompoundText.createLabelInfo((String)"Column: ", (Object)posInPanelCell.getColumn())).text(CompoundText.createLabelInfo((String)"Level: ", (Object)posInPanelCell.getLevel())).text(CompoundText.createLabelInfo((String)"Index: ", (Object)cellIndex)).text(CompoundText.createLabelInfo((String)"Segment: ", (Object)((Object)segment))).text(CompoundText.createLabelInfo((String)"Facing: ", (Object)((Object)posInPanelCell.getCellFacing())));
                        }
                        if ((panelCell = posInPanelCell.getIPanelCell()) != null) {
                            boolean handled = false;
                            if (panelCell instanceof IPanelCellInfoProvider) {
                                OverlayBlockInfo overlayBlockInfo = new OverlayBlockInfo(probeInfo, probeMode);
                                ((IPanelCellInfoProvider)((Object)panelCell)).addInfo(overlayBlockInfo, panelTile, posInPanelCell);
                                if (overlayBlockInfo.power > -1) {
                                    handled = true;
                                    PanelProvider.showRedstonePower(probeInfo, overlayBlockInfo.power);
                                }
                            }
                            if (!handled) {
                                Side sideHit = panelTile.getPanelCellSide((PanelCellPos)posInPanelCell, panelTile.getSideFromDirection(probeHitData.getSideHit()));
                                PanelProvider.showRedstonePower(probeInfo, panelCell.getWeakRsOutput(sideHit));
                            }
                        }
                    } else {
                        PanelProvider.showBlockRedstonePower(probeInfo, probeMode, this.redstoneMode, world, pos, probeHitData.getSideHit());
                    }
                } else {
                    PanelProvider.showBlockRedstonePower(probeInfo, probeMode, this.redstoneMode, world, pos, probeHitData.getSideHit());
                }
            }
        }
    }

    private static void showBlockRedstonePower(IProbeInfo probeInfo, ProbeMode probeMode, IProbeConfig.ConfigMode redstoneMode, Level world, BlockPos pos, Direction sideHit) {
        if (Tools.show((ProbeMode)probeMode, (IProbeConfig.ConfigMode)redstoneMode)) {
            PanelProvider.showRedstonePower(probeInfo, world.m_46681_(pos, sideHit.m_122424_()));
        }
    }

    private static void showRedstonePower(IProbeInfo probeInfo, int power) {
        if (power > 0) {
            probeInfo.horizontal().item(new ItemStack((ItemLike)Items.f_42451_), probeInfo.defaultItemStyle().width(14).height(14)).text(CompoundText.createLabelInfo((String)"Power: ", (Object)power));
        }
    }
}

