/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.items;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.gui.BlueprintGUI;
import com.dannyandson.tinyredstone.setup.ModSetup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Blueprint
extends Item {
    public Blueprint() {
        super(new Item.Properties().m_41491_(ModSetup.ITEM_GROUP));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flags) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("blueprint")) {
            list.add((Component)new TranslatableComponent("message.item.blueprint.full"));
            Map<Item, Integer> blueprintItems = Blueprint.getRequiredComponents(stack.m_41737_("blueprint"));
            for (Item item : blueprintItems.keySet()) {
                list.add(Component.m_130674_((String)(item.getRegistryName().toString() + " : " + blueprintItems.get(item))));
            }
        } else {
            list.add((Component)new TranslatableComponent("message.item.blueprint.empty"));
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
        if (te instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            if (context.m_43722_().m_41783_() != null && context.m_43722_().m_41783_().m_128441_("blueprint")) {
                Player player = context.m_43723_();
                if (panelTile.getCellCount() == 0 && player != null) {
                    CompoundTag blueprintNBT = context.m_43722_().m_41737_("blueprint");
                    Map<Item, Integer> items = Blueprint.getRequiredComponents(blueprintNBT);
                    if (player.m_7500_() || Blueprint.playerHasSufficientComponents(items, player)) {
                        try {
                            panelTile.loadCellsFromNBT(blueprintNBT, false);
                            panelTile.updateSide(Side.FRONT);
                            panelTile.updateSide(Side.RIGHT);
                            panelTile.updateSide(Side.BACK);
                            panelTile.updateSide(Side.LEFT);
                            panelTile.m_6596_();
                        }
                        catch (Exception e) {
                            panelTile.handleCrash(e);
                        }
                        if (!player.m_7500_()) {
                            block2: for (Item item : items.keySet()) {
                                int itemsToRemove = items.get(item);
                                for (ItemStack invStack : player.m_150109_().f_35974_) {
                                    if (invStack.m_41720_().equals(item)) {
                                        int removeCt = Math.min(invStack.m_41613_(), itemsToRemove);
                                        invStack.m_41764_(invStack.m_41613_() - removeCt);
                                        itemsToRemove -= removeCt;
                                    }
                                    if (itemsToRemove != 0) continue;
                                    continue block2;
                                }
                            }
                        }
                    }
                }
            } else {
                CompoundTag nbt = new CompoundTag();
                CompoundTag blueprintNBT = panelTile.saveToNbt(new CompoundTag());
                nbt.m_128405_("CustomModelData", 1);
                nbt.m_128365_("blueprint", (Tag)blueprintNBT);
                context.m_43722_().m_41751_(nbt);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_ && ((Boolean)Config.JSON_BLUEPRINT.get()).booleanValue()) {
            BlueprintGUI.open(playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    private static Map<Item, Integer> getRequiredComponents(CompoundTag blueprintNBT) {
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        if (blueprintNBT.m_128441_("cells")) {
            CompoundTag cellsNBT = blueprintNBT.m_128469_("cells");
            for (String key : cellsNBT.m_128431_()) {
                try {
                    Class<?> iPanelCellClass = Class.forName(cellsNBT.m_128469_(key).m_128461_("class"));
                    if (!IPanelCell.class.isAssignableFrom(iPanelCellClass)) continue;
                    Item item = PanelBlock.getPanelCellItemFromClass(iPanelCellClass);
                    if (items.containsKey(item)) {
                        items.put(item, (Integer)items.get(item) + 1);
                        continue;
                    }
                    items.put(item, 1);
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
        }
        return items;
    }

    private static boolean playerHasSufficientComponents(Map<Item, Integer> items, Player player) {
        for (Item item : items.keySet()) {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            int count = 0;
            for (ItemStack invStack : player.m_150109_().f_35974_) {
                if (!invStack.m_41720_().equals(itemStack.m_41720_())) continue;
                count += invStack.m_41613_();
            }
            if (count >= items.get(item)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static CompoundTag cleanUpBlueprintNBT(CompoundTag nbt) {
        CompoundTag blueprintNBT;
        if (nbt.m_128441_("blueprint") && (blueprintNBT = nbt.m_128469_("blueprint")).m_128441_("cells")) {
            CompoundTag newCellsNBT = new CompoundTag();
            CompoundTag cellsNBT = blueprintNBT.m_128469_("cells");
            for (String key : cellsNBT.m_128431_()) {
                try {
                    if (!IPanelCell.class.isAssignableFrom(Class.forName(cellsNBT.m_128469_(key).m_128461_("class")))) continue;
                    newCellsNBT.m_128365_(key, (Tag)cellsNBT.m_128469_(key));
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
            CompoundTag newNBT = new CompoundTag();
            CompoundTag newBlueprintNBT = new CompoundTag();
            newNBT.m_128405_("CustomModelData", 1);
            newBlueprintNBT.m_128365_("cells", (Tag)newCellsNBT);
            newNBT.m_128365_("blueprint", (Tag)newBlueprintNBT);
            if (nbt.m_128441_("display")) {
                newNBT.m_128365_("display", (Tag)nbt.m_128469_("display"));
            }
            return newNBT;
        }
        return null;
    }
}

