/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.panelcells.Repeater;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class RepeaterTickSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final int ticks;

    public RepeaterTickSync(BlockPos pos, int cellIndex, int ticks) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.ticks = ticks;
    }

    public RepeaterTickSync(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.cellIndex = buffer.readInt();
        this.ticks = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.cellIndex);
        buf.writeInt(this.ticks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PanelCellPos cellPos;
            IPanelCell cell;
            BlockEntity te = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_7702_(this.pos);
            if (te instanceof PanelTile && (cell = (cellPos = PanelCellPos.fromIndex((PanelTile)te, this.cellIndex)).getIPanelCell()) instanceof Repeater) {
                ((Repeater)cell).setTicks(this.ticks);
                ((PanelTile)te).flagSync();
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

